/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.DrawBase;
import com.runqian.base.graph.DrawGantt;
import com.runqian.base.graph.GraphParam;
import com.runqian.base.graph.StatisticGraph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Vector;

public class TimeState
implements DrawBase {
    GraphParam gp;

    public TimeState(GraphParam graphParam) {
        this.gp = graphParam;
    }

    public void drawGraph(StringBuffer sb, String link, String target) {
        int y;
        int x;
        String value;
        this.gp.coorWidth = 0;
        this.gp.baseValue = 0.0;
        this.gp.initGraphInset();
        DrawGantt.createCoorValue(this.gp);
        StatisticGraph.drawLegend(sb, link, target, this.gp);
        StatisticGraph.drawTitle(this.gp);
        StatisticGraph.drawLabel(this.gp);
        StatisticGraph.keepGraphSpace(this.gp);
        this.gp.adjustCoorInset();
        this.gp.graphRect = new Rectangle(this.gp.leftInset, this.gp.topInset, this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset, this.gp.graphHeight - this.gp.topInset - this.gp.bottomInset);
        if (this.gp.graphRect.width < 10 || this.gp.graphRect.height < 10) {
            return;
        }
        double seriesWidth = this.gp.graphRect.height / (this.gp.series.size() + 1);
        double coorWidth = this.gp.graphRect.width / this.gp.coorValue.size();
        this.gp.gRect1 = new Rectangle(this.gp.graphRect);
        this.gp.gRect2 = new Rectangle(this.gp.graphRect);
        StatisticGraph.drawGraphRect(this.gp);
        int i = 0;
        while (i < this.gp.tickNum) {
            this.gp.g.setColor(this.gp.coorColor);
            this.gp.g.drawLine((int)((double)this.gp.graphRect.x + (double)i * coorWidth), this.gp.graphRect.y + this.gp.graphRect.height, (int)((double)this.gp.graphRect.x + (double)i * coorWidth), this.gp.graphRect.y + this.gp.graphRect.height + this.gp.tickLen);
            if (i != 0) {
                float[] dashes = new float[]{2.0f};
                this.gp.g.setStroke(new BasicStroke(1.0E-5f, 1, 1, 1.0f, dashes, 0.0f));
            }
            this.gp.g.drawLine((int)((double)this.gp.graphRect.x + (double)i * coorWidth), this.gp.graphRect.y + this.gp.graphRect.height, (int)((double)this.gp.graphRect.x + (double)i * coorWidth), this.gp.graphRect.y + 1);
            this.gp.g.setStroke(new BasicStroke(1.0E-5f));
            value = this.gp.coorValue.get(i).toString();
            TR.setBounds(this.gp.GFV_XLABEL.getTextSize(value));
            x = (int)((double)this.gp.graphRect.x + (double)i * coorWidth - (double)(TimeState.TR.width / 2));
            y = this.gp.graphRect.y + this.gp.graphRect.height + this.gp.tickLen + TimeState.TR.height;
            this.gp.GFV_XLABEL.outText(x, y, value);
            this.gp.g.drawLine(this.gp.graphRect.x, this.gp.graphRect.y + this.gp.graphRect.height, this.gp.graphRect.x + this.gp.graphRect.width, this.gp.graphRect.y + this.gp.graphRect.height);
            ++i;
        }
        i = 1;
        while (i <= this.gp.series.size()) {
            value = this.gp.series.get(i - 1).toString();
            TR.setBounds(this.gp.GFV_YLABEL.getTextSize(value));
            x = this.gp.graphRect.x - TimeState.TR.width - this.gp.tickLen;
            y = (int)((double)(this.gp.graphRect.y + this.gp.graphRect.height) - (double)i * seriesWidth + (double)(TimeState.TR.height / 2));
            this.gp.GFV_YLABEL.outText(x, y, value);
            this.gp.g.drawLine(this.gp.graphRect.x - this.gp.tickLen, (int)((double)(this.gp.graphRect.y + this.gp.graphRect.height) - (double)i * seriesWidth), this.gp.graphRect.x, (int)((double)(this.gp.graphRect.y + this.gp.graphRect.height) - (double)i * seriesWidth));
            Vector[] data = (Vector[])this.gp.graphData.get(value);
            int j = 0;
            while (j < data[0].size()) {
                Object oState = data[0].get(j);
                Object oStart = data[1].get(j);
                Object oEnd = data[2].get(j);
                int x1 = StatisticGraph.calcDateX(this.gp, oStart.toString(), coorWidth);
                int x2 = StatisticGraph.calcDateX(this.gp, oEnd.toString(), coorWidth);
                int[] px = new int[]{x1, x1, x2, x2};
                int[] py = new int[]{(int)((double)(this.gp.graphRect.y + this.gp.graphRect.height) - (double)i * seriesWidth + (double)(this.gp.stateH / 2)), (int)((double)(this.gp.graphRect.y + this.gp.graphRect.height) - (double)i * seriesWidth - (double)(this.gp.stateH / 2)), (int)((double)(this.gp.graphRect.y + this.gp.graphRect.height) - (double)i * seriesWidth - (double)(this.gp.stateH / 2)), (int)((double)(this.gp.graphRect.y + this.gp.graphRect.height) - (double)i * seriesWidth + (double)(this.gp.stateH / 2))};
                this.gp.g.setColor(this.getStateColor(oState));
                this.gp.g.fillPolygon(px, py, 4);
                this.gp.g.setColor(this.gp.lineColor);
                this.gp.g.drawPolygon(px, py, 4);
                ++j;
            }
            ++i;
        }
        this.gp.g.setColor(this.gp.coorColor);
        this.gp.g.drawLine(this.gp.graphRect.x, this.gp.graphRect.y, this.gp.graphRect.x, this.gp.graphRect.y + this.gp.graphRect.height);
    }

    private Color getStateColor(Object oState) {
        int i = 0;
        i = 0;
        while (i < this.gp.category.size()) {
            Object tmp = this.gp.category.get(i);
            if (tmp.equals(oState)) break;
            ++i;
        }
        return this.gp.getColor(i);
    }
}

