/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.graph;

import com.runqian.base.graph.DrawBase;
import com.runqian.base.graph.GraphDataSource;
import com.runqian.base.graph.GraphParam;
import com.runqian.base.graph.StatisticGraph;
import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

public class TimeTrend
implements DrawBase {
    GraphParam gp;

    public TimeTrend(GraphParam graphParam) {
        this.gp = graphParam;
    }

    public void drawGraph(StringBuffer sb, String link, String target) {
        int y;
        int x;
        this.gp.coorWidth = 0;
        this.gp.baseValue = 0.0;
        this.gp.initGraphInset();
        this.gp.createCoorValue();
        StatisticGraph.drawLegend(sb, link, target, this.gp);
        StatisticGraph.drawTitle(this.gp);
        StatisticGraph.drawLabel(this.gp);
        StatisticGraph.keepGraphSpace(this.gp);
        SimpleDateFormat sdf = null;
        if (this.gp.timeRange != null && this.gp.timeRange[3].size() > 0) {
            int labeling = Integer.parseInt(this.gp.timeRange[3].get(0).toString());
            String format = "yyyy-MM-dd HH:mm:ss";
            switch (labeling) {
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    format = "yyyy-MM-dd";
                    break;
                }
                case 4: {
                    format = "yyyy-MM-dd HH";
                    break;
                }
                case 5: {
                    format = "yyyy-MM-dd HH:mm";
                }
            }
            sdf = new SimpleDateFormat(format);
        }
        this.gp.adjustCoorInset();
        this.gp.graphRect = new Rectangle(this.gp.leftInset, this.gp.topInset, this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset, this.gp.graphHeight - this.gp.topInset - this.gp.bottomInset);
        if (this.gp.graphRect.width < 10 || this.gp.graphRect.height < 10) {
            return;
        }
        if (this.gp.coorWidth < 0 || this.gp.coorWidth > 10000) {
            this.gp.coorWidth = 0;
        }
        double categorySpan = (double)this.gp.graphRect.width * 1.0 / (double)(this.gp.sampling.size() + 1);
        double coorWidth = this.gp.coorWidth;
        int tmpInt = (int)((double)(this.gp.sampling.size() + 1) * categorySpan);
        this.gp.graphRect.x += (this.gp.graphRect.width - tmpInt) / 2;
        this.gp.graphRect.width = tmpInt;
        double dely = ((double)this.gp.graphRect.height - coorWidth) / (double)this.gp.tickNum;
        tmpInt = (int)(dely * (double)this.gp.tickNum + coorWidth);
        this.gp.graphRect.y += (this.gp.graphRect.height - tmpInt) / 2;
        this.gp.graphRect.height = tmpInt;
        this.gp.gRect1 = new Rectangle(this.gp.graphRect);
        this.gp.gRect2 = new Rectangle(this.gp.graphRect);
        this.gp.gRect1.y = (int)((double)this.gp.gRect1.y + coorWidth);
        this.gp.gRect1.width = (int)((double)this.gp.gRect1.width - coorWidth);
        this.gp.gRect1.height = (int)((double)this.gp.gRect1.height - coorWidth);
        this.gp.gRect2.x = (int)((double)this.gp.gRect2.x + coorWidth);
        this.gp.gRect2.width = (int)((double)this.gp.gRect2.width - coorWidth);
        this.gp.gRect2.height = (int)((double)this.gp.gRect2.height - coorWidth);
        StatisticGraph.drawGraphRect(this.gp);
        int i = 0;
        while (i <= this.gp.tickNum) {
            this.gp.g.setColor(this.gp.coorColor);
            this.gp.g.drawLine(this.gp.gRect1.x - this.gp.tickLen, (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), this.gp.gRect1.x, (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely));
            if (i != this.gp.tickNum || this.gp.gRect1.height != 10 * (this.gp.gRect1.height / 10)) {
                this.gp.g.setColor(this.gp.gridColor);
                this.gp.g.drawLine(this.gp.gRect1.x, (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), this.gp.gRect2.x, (int)((double)(this.gp.gRect2.y + this.gp.gRect2.height) - (double)i * dely));
                if (i != 0) {
                    float[] dashes = new float[]{2.0f};
                    this.gp.g.setStroke(new BasicStroke(1.0E-5f, 1, 1, 1.0f, dashes, 0.0f));
                }
                this.gp.g.drawLine(this.gp.gRect2.x, (int)((double)(this.gp.gRect2.y + this.gp.gRect2.height) - (double)i * dely), this.gp.gRect2.x + this.gp.gRect2.width - 1, (int)((double)(this.gp.gRect2.y + this.gp.gRect2.height) - (double)i * dely));
                this.gp.g.setStroke(new BasicStroke(1.0E-5f));
            }
            if (i == 0) {
                int[] ptx1 = new int[]{this.gp.gRect1.x, (int)((double)this.gp.gRect1.x + coorWidth), (int)((double)this.gp.gRect1.x + coorWidth + (double)this.gp.gRect2.width), this.gp.gRect1.x + this.gp.gRect1.width};
                int[] pty1 = new int[]{(int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely - coorWidth), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely - coorWidth), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely)};
                this.gp.g.setColor(this.gp.coor3DColor);
                this.gp.g.fillPolygon(ptx1, pty1, 4);
                this.gp.g.setColor(this.gp.coorColor);
                this.gp.g.drawPolygon(ptx1, pty1, 4);
            }
            Number coory = (Number)this.gp.coorValue.get(i);
            String scoory = coory.toString();
            DecimalFormat df = null;
            if (this.gp.dataMarkFormat != null && this.gp.dataMarkFormat.trim().length() > 0) {
                df = new DecimalFormat(this.gp.dataMarkFormat, GraphParam.dfs);
                scoory = df.format(coory.doubleValue());
            }
            TR.setBounds(this.gp.GFV_YLABEL.getTextSize(scoory));
            x = this.gp.gRect1.x - TimeTrend.TR.width - this.gp.tickLen;
            y = (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely + (double)(TimeTrend.TR.height / 2));
            this.gp.GFV_YLABEL.outText(x, y, scoory);
            if (coory.doubleValue() == this.gp.minValue) {
                this.gp.valueBaseLine = (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely);
                int[] ptx1 = new int[]{this.gp.gRect1.x, (int)((double)this.gp.gRect1.x + coorWidth), (int)((double)this.gp.gRect1.x + coorWidth + (double)this.gp.gRect2.width), this.gp.gRect1.x + this.gp.gRect1.width};
                int[] pty1 = new int[]{(int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely - coorWidth), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely - coorWidth), (int)((double)(this.gp.gRect1.y + this.gp.gRect1.height) - (double)i * dely)};
                this.gp.g.setColor(this.gp.coor3DColor);
                this.gp.g.fillPolygon(ptx1, pty1, 4);
                this.gp.g.setColor(this.gp.coorColor);
                this.gp.g.drawPolygon(ptx1, pty1, 4);
            }
            ++i;
        }
        StatisticGraph.drawWarnLine(this.gp);
        Point[] prePoints1 = new Point[this.gp.series.size()];
        Point[] prePoints2 = new Point[this.gp.series.size()];
        i = 0;
        while (i < this.gp.sampling.size()) {
            Object cat = this.gp.sampling.get(i);
            int delx = (int)((double)(i + 1) * categorySpan);
            this.gp.g.setColor(this.gp.coorColor);
            if (this.gp.category.contains(cat)) {
                String label = cat.toString();
                if (sdf != null) {
                    label = sdf.format(Timestamp.valueOf(cat.toString()));
                }
                this.gp.g.drawLine(this.gp.gRect1.x + delx, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect1.x + delx, this.gp.gRect1.y + this.gp.gRect1.height + this.gp.tickLen);
                TR.setBounds(this.gp.GFV_XLABEL.getTextSize(label));
                x = this.gp.gRect1.x + delx - TimeTrend.TR.width / 2;
                y = this.gp.gRect1.y + this.gp.gRect1.height + this.gp.tickLen + TimeTrend.TR.height;
                this.gp.GFV_XLABEL.outText(x, y, label);
            }
            GraphDataSource ht = (GraphDataSource)this.gp.graphData.get(cat);
            Object o = this.gp.graphData.getKey(1);
            if (ht != null) {
                int j = 0;
                while (j < this.gp.series.size()) {
                    int len = 0;
                    Object ser = this.gp.series.get(j);
                    if (ser == null) {
                        len = 0;
                    } else {
                        Object val = ht.get(ser);
                        if (val == null || val.toString().trim().length() == 0) {
                            len = 0;
                        } else {
                            Number d = (Number)val;
                            double tmp = d.doubleValue();
                            len = (int)(dely * (double)this.gp.tickNum * (tmp - this.gp.minValue) / (this.gp.maxValue * this.gp.coorScale));
                        }
                    }
                    double lb = (double)this.gp.gRect1.x + (double)(i + 1) * categorySpan;
                    Point pt1 = new Point((int)lb, this.gp.valueBaseLine - len);
                    Point pt2 = new Point((int)(lb + coorWidth), (int)((double)(this.gp.valueBaseLine - len) - coorWidth));
                    if (prePoints1[j] == null) {
                        prePoints1[j] = pt1;
                    }
                    if (prePoints2[j] == null) {
                        prePoints2[j] = pt2;
                    }
                    this.gp.g.setColor(this.gp.seriesColor[j % this.gp.seriesColor.length]);
                    this.gp.g.setStroke(new BasicStroke(1.0f));
                    this.gp.g.drawLine(prePoints1[j].x, prePoints1[j].y, pt1.x, pt1.y);
                    prePoints1[j] = pt1;
                    prePoints2[j] = pt2;
                    ++j;
                }
            }
            ++i;
        }
        this.gp.g.setColor(this.gp.coorColor);
        this.gp.g.drawLine(this.gp.gRect1.x, this.gp.valueBaseLine, this.gp.gRect1.x + this.gp.gRect1.width, this.gp.valueBaseLine);
        this.gp.g.drawLine(this.gp.gRect1.x + this.gp.gRect1.width, this.gp.valueBaseLine, (int)((double)(this.gp.gRect1.x + this.gp.gRect1.width) + coorWidth), (int)((double)this.gp.valueBaseLine - coorWidth));
    }
}

