/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import com.runqian.base.module.DataSource;
import com.runqian.base.tool.AppTools;
import com.runqian.base.tool.Tools;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Vector;

public class DBInformation {
    private Connection con = null;
    private DataSource ds = null;
    private boolean useSchema = false;

    public DBInformation(DataSource ds, boolean useSchema) {
        this.ds = ds;
        this.useSchema = useSchema;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public void closeConnection() {
        try {
            this.con.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void gainConnection() {
        if (this.con == null && this.ds != null && this.ds.getRQConnection() != null) {
            this.con = this.ds.getRQConnection().getConnection();
        }
    }

    public void SetUseSchema(boolean ifuse) {
        this.useSchema = ifuse;
    }

    public Vector getSchemas() throws Exception {
        this.gainConnection();
        Vector<String> schemas = new Vector<String>();
        if (this.con == null) {
            return schemas;
        }
        DatabaseMetaData md = this.con.getMetaData();
        ResultSet rs = md.getSchemas();
        while (rs.next()) {
            schemas.add(rs.getString(1));
        }
        return schemas;
    }

    public String getCurrentSchema() throws Exception {
        this.gainConnection();
        DatabaseMetaData md = this.con.getMetaData();
        System.out.println(this.con.getCatalog());
        System.out.println(md.getCatalogTerm());
        System.out.println(md.getUserName());
        return md.getSchemaTerm();
    }

    public Vector getTables(boolean showSystemTables) throws Exception {
        return this.getTables(showSystemTables, null);
    }

    public Vector getTables(boolean showSystemTables, String schema) throws Exception {
        Vector<String> tableNames = new Vector<String>();
        this.gainConnection();
        if (this.con == null || this.ds == null) {
            return AppTools.listRegistTables().toVector();
        }
        DatabaseMetaData md = this.con.getMetaData();
        String[] types = null;
        types = showSystemTables ? new String[]{"TABLE", "VIEW", "SYSTEM TABLE"} : new String[]{"TABLE", "VIEW"};
        ResultSet rs = md.getTables(this.con.getCatalog(), schema, null, types);
        int count = 0;
        while (rs.next()) {
            String name = this.useSchema ? String.valueOf(rs.getString(2)) + "." + rs.getString(3) : rs.getString(3);
            tableNames.addElement(name);
            ++count;
        }
        rs.close();
        return tableNames;
    }

    public Vector getColumnNames(String table) {
        return this.getColumnInfo(table, 4);
    }

    public Vector getColumnNames(String table, String schema) {
        return this.getColumnInfo(table, 4, schema);
    }

    public Vector getColumnInfo(String table, int describeColumn, String schem) {
        Vector<String> columnNames = new Vector<String>();
        this.gainConnection();
        if (this.con == null || this.ds == null) {
            return AppTools.listRegistColumns(table).toVector();
        }
        try {
            String name;
            int index = table.indexOf(46);
            String schema = null;
            if (index > -1) {
                schema = table.substring(0, index);
                name = table.substring(index + 1, table.length());
            } else {
                name = table;
            }
            if (!Tools.isValidString(schema)) {
                schema = schem;
            }
            DatabaseMetaData md = this.con.getMetaData();
            ResultSet rs = md.getColumns(null, schema, name, "%");
            while (rs.next()) {
                String columnName = rs.getString(describeColumn);
                columnNames.addElement(columnName);
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return columnNames;
    }

    public Vector getColumnInfo(String table, int describeColumn) {
        return this.getColumnInfo(table, describeColumn, null);
    }

    public Vector getColumnTypes(String table) throws Exception {
        Vector<String> columnTypes = new Vector<String>();
        if (this.ds == null) {
            return columnTypes;
        }
        this.gainConnection();
        String schema = null;
        String name = null;
        int index = table.indexOf(46);
        if (index > -1) {
            schema = table.substring(0, index);
            name = table.substring(index + 1, table.length());
        } else {
            name = table;
        }
        DatabaseMetaData md = this.con.getMetaData();
        ResultSet rs = md.getColumns(null, schema, name, "%");
        while (rs.next()) {
            String typeName;
            short type = rs.getShort(5);
            short width = rs.getShort(7);
            short scale = rs.getShort(9);
            switch (type) {
                case -7: {
                    typeName = "BIT";
                    break;
                }
                case -6: {
                    typeName = "TINYINT";
                    break;
                }
                case 5: {
                    typeName = "SMALLINT";
                    break;
                }
                case 4: {
                    typeName = "INTEGER";
                    break;
                }
                case -5: {
                    typeName = "BIGINT";
                    break;
                }
                case 6: {
                    typeName = "FLOAT";
                    break;
                }
                case 8: {
                    typeName = "DOUBLE";
                    break;
                }
                case 7: {
                    typeName = "REAL";
                    break;
                }
                case 2: {
                    typeName = "NUMERIC(" + width + "," + scale + ")";
                    break;
                }
                case 3: {
                    typeName = "DECIMAL(" + width + "," + scale + ")";
                    break;
                }
                case 1: {
                    typeName = "CHAR(" + width + ")";
                    break;
                }
                case 12: {
                    typeName = "VARCHAR(" + width + ")";
                    break;
                }
                case -1: {
                    typeName = "LONGVARCHAR";
                    break;
                }
                case -2: {
                    typeName = "BINARY(" + width + ")";
                    break;
                }
                case -3: {
                    typeName = "VARBINARY(" + width + ")";
                    break;
                }
                case -4: {
                    typeName = "LONGVARBINARY";
                    break;
                }
                case 91: {
                    typeName = "DATE";
                    break;
                }
                case 92: {
                    typeName = "TIME";
                    break;
                }
                case 93: {
                    typeName = "TIMESTAMP";
                    break;
                }
                case 1111: {
                    typeName = "OTHER";
                    break;
                }
                default: {
                    typeName = "???";
                }
            }
            columnTypes.addElement(typeName);
        }
        rs.close();
        return columnTypes;
    }
}

