/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import com.runqian.base.tool.Section;
import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.Escape;
import com.runqian.base.util.SegmentSet;
import java.util.ArrayList;
import java.util.List;

public class DataSetConfig {
    private String sql;
    private int sqlType;
    private String beginRow;
    private String endRow;
    private String className;
    private ArrayList argList = new ArrayList(5);
    private ArrayList typeList = new ArrayList(5);
    private ArrayList fieldText = new ArrayList(5);
    private String dsName;
    private String dsn;
    private boolean cached;
    private ArrayList indexCols = new ArrayList(5);
    private boolean indexSorted;
    private boolean indexIsUnique;
    public static final int TYPE_NORMAL = 1;
    public static final int TYPE_COMPLEX = 2;
    public static final int TYPE_PROC = 3;
    public static final int TYPE_PAGE = 4;
    public static final int TYPE_TEXT = 5;
    public static final int TYPE_XML = 6;
    public static final int TYPE_SELF = 7;
    public static final int TYPE_BUILDIN = 8;
    public static final int TYPE_OLAP = 9;

    public DataSetConfig(String configString) {
        this.parseDSConfig(configString);
    }

    public DataSetConfig() {
    }

    public static String getSqlTypeName(int type) {
        switch (type) {
            case 2: {
                return "\u590d\u6742SQL";
            }
            case 3: {
                return "\u5b58\u50a8\u8fc7\u7a0b";
            }
            case 5: {
                return "TEXT\u6587\u4ef6";
            }
            case 6: {
                return "XML\u6587\u4ef6";
            }
            case 7: {
                return "\u81ea\u5b9a\u4e49";
            }
            case 8: {
                return "\u5185\u5efa\u6570\u636e\u96c6";
            }
            case 9: {
                return "OLAP\u6570\u636e\u96c6";
            }
        }
        return "\u5e38\u89c4SQL";
    }

    public static int getSqlType(String name) {
        if ("\u590d\u6742SQL".equalsIgnoreCase(name)) {
            return 2;
        }
        if ("\u5b58\u50a8\u8fc7\u7a0b".equalsIgnoreCase(name)) {
            return 3;
        }
        if ("TEXT\u6587\u4ef6".equalsIgnoreCase(name)) {
            return 5;
        }
        if ("XML\u6587\u4ef6".equalsIgnoreCase(name)) {
            return 6;
        }
        if ("\u81ea\u5b9a\u4e49".equalsIgnoreCase(name)) {
            return 7;
        }
        if ("\u5185\u5efa\u6570\u636e\u96c6".equalsIgnoreCase(name)) {
            return 8;
        }
        if ("OLAP\u6570\u636e\u96c6".equalsIgnoreCase(name)) {
            return 9;
        }
        return 1;
    }

    public void setDataSourceName(String dsn) {
        this.dsn = dsn;
    }

    public String getDataSourceName() {
        return this.dsn;
    }

    public void setName(String name) {
        this.dsName = name;
    }

    public String getName() {
        return this.dsName;
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public void clearArguments() {
        this.argList.clear();
        this.typeList.clear();
    }

    public String getSQL() {
        return this.sql;
    }

    public boolean ifNeedCached() {
        return this.cached;
    }

    public void setNeedCached(boolean needCached) {
        this.cached = needCached;
    }

    public void setSQLType(int sqlType) {
        this.sqlType = sqlType;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public void setBeginRow(String rowExp) {
        this.beginRow = rowExp;
    }

    public String getBeginRow() {
        return this.beginRow;
    }

    public void setEndRow(String rowExp) {
        this.endRow = rowExp;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getEndRow() {
        return this.endRow;
    }

    public String getClassName() {
        return this.className;
    }

    public void addSQLArgument(int index, String argExp, int dataType) {
        this.argList.add(index, argExp);
        this.typeList.add(index, String.valueOf(dataType));
    }

    public void setSQLArguments(String[] arg, int[] type) {
        this.setSQLArguments(arg);
        this.setArgumentTypes(type);
    }

    public void setSQLArguments(String[] arg) {
        this.argList.clear();
        int i = 0;
        while (i < arg.length) {
            this.argList.add(arg[i]);
            ++i;
        }
    }

    public void setArgumentTypes(int[] type) {
        this.typeList.clear();
        int i = 0;
        while (i < type.length) {
            this.typeList.add(String.valueOf(type[i]));
            ++i;
        }
    }

    public void addSQLArgument(String argExp, int dataType) {
        this.argList.add(argExp);
        this.typeList.add(String.valueOf(dataType));
    }

    public void removeSQLArgument(int index) {
        this.argList.remove(index);
        this.typeList.remove(index);
    }

    public String[] getSqlArguments() {
        Object[] object = this.argList.toArray();
        if (object == null) {
            return null;
        }
        String[] s = new String[object.length];
        int i = 0;
        while (i < object.length) {
            s[i] = object[i] != null ? object[i].toString() : "";
            ++i;
        }
        return s;
    }

    public String[] getIndexCols() {
        Object[] object = this.indexCols.toArray();
        if (object == null) {
            return null;
        }
        String[] s = new String[object.length];
        int i = 0;
        while (i < object.length) {
            s[i] = object[i] != null ? object[i].toString() : "";
            ++i;
        }
        return s;
    }

    public void setIndexCols(String[] cols) {
        this.indexCols.clear();
        int i = 0;
        while (i < cols.length) {
            this.indexCols.add(cols[i]);
            ++i;
        }
    }

    public boolean getIndexSorted() {
        return this.indexSorted;
    }

    public void setIndexSorted(boolean value) {
        this.indexSorted = value;
    }

    public boolean getIndexIsUnique() {
        return this.indexIsUnique;
    }

    public void setIndexIsUnique(boolean value) {
        this.indexIsUnique = value;
    }

    public int[] getArgumentTypes() {
        Object[] object = this.typeList.toArray();
        if (object == null) {
            return null;
        }
        int[] type = new int[object.length];
        int i = 0;
        while (i < object.length) {
            type[i] = object[i] != null && ((String)object[i]).trim().length() > 0 ? Integer.parseInt((String)object[i]) : 6;
            ++i;
        }
        return type;
    }

    public ArrayList getFieldTextList() {
        return this.fieldText;
    }

    public void setFieldTextList(List fieldTextList) {
        this.fieldText = new ArrayList(fieldTextList);
    }

    public static boolean isValid(Object str) {
        if (str == null) {
            return false;
        }
        if (!(str instanceof String)) {
            return false;
        }
        String s = (String)str;
        return s.trim().length() != 0;
    }

    public String toString() {
        String sTmp;
        StringBuffer sb = new StringBuffer(100);
        if (DataSetConfig.isValid(this.dsName)) {
            sb.append("name=").append(this.dsName).append(',');
        }
        if (DataSetConfig.isValid(this.sql)) {
            sb.append("sql=").append(Escape.addEscAndQuote(this.sql)).append(',');
        }
        sb.append("type=");
        String type = "normal";
        switch (this.sqlType) {
            case 2: {
                type = "complex";
                break;
            }
            case 4: {
                type = "page";
                break;
            }
            case 3: {
                type = "proc";
                break;
            }
            case 5: {
                type = "text";
                break;
            }
            case 6: {
                type = "xml";
                break;
            }
            case 7: {
                type = "self";
                break;
            }
            case 8: {
                type = "buildin";
                break;
            }
            case 9: {
                type = "olap";
                break;
            }
            default: {
                type = "normal";
            }
        }
        sb.append(type);
        if (this.argList.size() > 0) {
            sb.append(",param=");
            sb.append(this.getParamString());
        }
        sb.append(",");
        if (DataSetConfig.isValid(this.beginRow)) {
            sb.append("beginrow=").append(this.beginRow).append(",");
        }
        if (DataSetConfig.isValid(this.endRow)) {
            sb.append("endrow=").append(this.endRow).append(",");
        }
        if (DataSetConfig.isValid(this.className)) {
            sb.append("classname=").append(this.className).append(",");
        }
        if (DataSetConfig.isValid(this.dsn)) {
            sb.append("dsn=").append(this.dsn).append(",");
        }
        if (this.cached) {
            sb.append("cached=1,");
        } else {
            sb.append("cached=0,");
        }
        if (this.fieldText.size() > 0) {
            sb.append("fieldText=");
            int i = 0;
            while (i < this.fieldText.size()) {
                sb.append(this.fieldText.get(i)).append(":");
                ++i;
            }
            if (sb.charAt(sb.length() - 1) == ':') {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        if (this.indexCols.size() > 0) {
            sb.append(",indexCols=");
            String sTmp2 = new Section(this.getIndexCols()).toString();
            sb.append(Escape.addEscAndQuote(sTmp2));
        }
        if (DataSetConfig.isValid(sTmp = String.valueOf(this.indexSorted))) {
            sb.append(",indexSorted=" + sTmp);
        }
        if (DataSetConfig.isValid(sTmp = String.valueOf(this.indexIsUnique))) {
            sb.append(",indexIsUnique=" + sTmp);
        }
        return sb.toString();
    }

    private String getParamString() {
        StringBuffer sb = new StringBuffer(this.argList.size() * 10);
        int i = 0;
        while (i < this.argList.size()) {
            if (i > 0) {
                sb.append(';');
            }
            sb.append(this.argList.get(i)).append(":");
            if (this.typeList.size() >= i + 1) {
                sb.append(this.typeList.get(i));
            }
            ++i;
        }
        return Escape.addEscAndQuote(sb.toString());
    }

    private void parseDSConfig(String config) {
        SegmentSet seg = new SegmentSet(config, ',');
        this.dsn = seg.get("dsn");
        this.dsName = seg.get("name");
        this.dsName = DataSetConfig.getRealString(this.dsName);
        String colName = seg.get("fieldText");
        ArgumentTokenizer at = new ArgumentTokenizer(colName, ':');
        while (at.hasMoreTokens()) {
            this.fieldText.add(at.nextToken());
        }
        String cach = seg.get("cached");
        this.cached = "1".equals(cach);
        String type = seg.get("type");
        this.sqlType = (type = DataSetConfig.getRealString(type)) == null || type.length() == 0 ? 1 : ("complex".equalsIgnoreCase(type) ? 2 : ("page".equalsIgnoreCase(type) ? 4 : ("proc".equalsIgnoreCase(type) ? 3 : ("text".equalsIgnoreCase(type) ? 5 : ("xml".equalsIgnoreCase(type) ? 6 : ("self".equalsIgnoreCase(type) ? 7 : ("buildin".equalsIgnoreCase(type) ? 8 : ("olap".equalsIgnoreCase(type) ? 9 : 1))))))));
        this.sql = seg.get("sql");
        this.sql = DataSetConfig.getRealString(this.sql);
        String param = seg.get("param");
        param = DataSetConfig.getRealString(param);
        if (this.dsName != null && this.dsName.length() > 0 && this.sql != null && this.sql.length() > 0 && param != null && param.length() > 0) {
            ArgumentTokenizer arg = new ArgumentTokenizer(param, ';');
            while (arg.hasMoreTokens()) {
                ArgumentTokenizer tmp = new ArgumentTokenizer(arg.nextToken(), ':');
                this.argList.add(tmp.nextToken());
                if (tmp.hasMoreTokens()) {
                    this.typeList.add(tmp.nextToken());
                    continue;
                }
                this.typeList.add(String.valueOf(6));
            }
        }
        this.beginRow = seg.get("beginrow");
        this.endRow = seg.get("endrow");
        this.className = seg.get("className");
        String sTmp = DataSetConfig.getRealString(seg.get("indexCols"));
        this.indexCols.addAll(new Section(sTmp).toVector());
        sTmp = seg.get("indexSorted");
        this.indexSorted = Boolean.valueOf(sTmp);
        sTmp = seg.get("indexIsUnique");
        this.indexIsUnique = Boolean.valueOf(sTmp);
    }

    private static String getRealString(String str) {
        if (str != null) {
            str = str.trim();
        }
        if (str != null && str.length() >= 2 && str.charAt(0) == '\"') {
            str = Escape.removeEscAndQuote(str);
            str = str.trim();
        }
        return str;
    }
}

