/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import com.runqian.base.module.OLAPSessionFactory;
import com.runqian.base.module.RQConnection;
import com.runqian.base.tool.Segment;
import com.runqian.base.tool.Tools;
import com.runqian.base.util.OLAPSession;
import com.runqian.base.util.SegmentSet;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.Properties;

public class DataSource {
    private String id;
    private String sourceName;
    private String driverName;
    private String urlPath;
    private String userId;
    private String password;
    private String DBEncoding;
    private String extendProperties;
    private int dbType;
    private boolean encodeSQL;
    private RQConnection rqc = null;
    private static int cto = 0;

    public DataSource(DataSource ss) {
        if (ss == null) {
            return;
        }
        this.setID(ss.getID());
        this.setSourceName(ss.getSourceName());
        this.setDriverName(ss.getDriverName());
        this.setUrlPath(ss.getUrlPath());
        this.setUserID(ss.getUserID());
        this.setPassWord(ss.getPassWord());
        this.setDBType(ss.getDBType());
        this.setDBEncoding(ss.getDBEncoding());
        this.setEncodeSQL(ss.getEncodeSQL());
        this.setExtendProperties(ss.getExtendProperties());
    }

    public DataSource() {
    }

    public DataSource(String sourcename, int dbtype, String drivername, String urlpath, String userid, String pwd) {
        this.sourceName = sourcename;
        this.driverName = drivername;
        this.dbType = dbtype;
        this.urlPath = urlpath;
        this.userId = userid;
        this.password = pwd;
        this.DBEncoding = "GBK";
        this.encodeSQL = false;
    }

    public int getDBType() {
        return this.dbType;
    }

    public String getID() {
        return this.id;
    }

    public String getExtendProperties() {
        return this.extendProperties;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public String getUserID() {
        return this.userId;
    }

    public String getPassWord() {
        return this.password;
    }

    public String getDBEncoding() {
        return this.DBEncoding;
    }

    public boolean getEncodeSQL() {
        return this.encodeSQL;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setExtendProperties(String prop) {
        this.extendProperties = prop;
    }

    public void setDBEncoding(String dben) {
        this.DBEncoding = dben;
    }

    public void setSourceName(String sourcename) {
        this.sourceName = sourcename;
    }

    public void setDriverName(String drivername) {
        this.driverName = drivername;
    }

    public void setUrlPath(String urlpath) {
        this.urlPath = urlpath;
    }

    public void setUserID(String userid) {
        this.userId = userid;
    }

    public void setPassWord(String password) {
        this.password = password;
    }

    public void setDBType(int dbType) {
        this.dbType = dbType;
    }

    public void setEncodeSQL(boolean encodeSql) {
        this.encodeSQL = encodeSql;
    }

    public static void setConnectTimeOut(int t) {
        cto = t;
    }

    public RQConnection connect() throws Exception {
        try {
            if (this.dbType == 101) {
                Properties p = new Properties();
                p.setProperty("DBType", Integer.toString(this.dbType));
                Segment define = new Segment(this.driverName);
                String[] keys = OLAPSessionFactory.getParaKeys(101);
                int i = 0;
                while (i < keys.length) {
                    p.setProperty(keys[i], define.get(keys[i]));
                    ++i;
                }
                OLAPSessionFactory osf = new OLAPSessionFactory();
                osf.setProperties(p);
                OLAPSession os = osf.createSession();
                this.rqc = new RQConnection(os, this.dbType);
            } else {
                Connection conn;
                Driver driver = (Driver)Class.forName(this.driverName).newInstance();
                DriverManager.registerDriver(driver);
                DriverManager.setLoginTimeout(cto);
                if (Tools.isValidString(this.extendProperties)) {
                    Properties p = new Properties();
                    p.put("user", this.userId);
                    p.put("password", this.password);
                    SegmentSet s = new SegmentSet(this.extendProperties);
                    Iterator it = s.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        String val = s.get(key);
                        p.put(key, val);
                    }
                    conn = DriverManager.getConnection(this.urlPath, p);
                } else {
                    conn = DriverManager.getConnection(this.urlPath, this.userId, this.password);
                }
                this.rqc = new RQConnection(conn, this.dbType, this.DBEncoding, this.encodeSQL);
            }
            return this.rqc;
        }
        catch (Exception e) {
            try {
                DriverManager.registerDriver(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public RQConnection getRQConnection() {
        return this.rqc;
    }

    public void close() {
        try {
            this.rqc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object clone() {
        DataSource ds = new DataSource(this);
        return ds;
    }

    public boolean isClosed() {
        try {
            return this.rqc.isClosed();
        }
        catch (Exception e) {
            return true;
        }
    }
}

