/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import com.runqian.base.module.DataSource;
import com.runqian.base.module.RQConnection;
import com.runqian.base.tool.Section;
import com.runqian.base.tool.XMLFile;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;

public class DataSourceListModel
extends DefaultListModel {
    private static DataSource ads = null;
    public static String sPath = null;
    public static String sFile = null;
    public static JLabel textShow = null;
    HashMap connectionPool = new HashMap();

    public DataSourceListModel(String file, String path) throws Throwable {
        if (file != null) {
            sFile = file;
        }
        if (path != null) {
            sPath = path;
        }
        this.load();
    }

    public DataSourceListModel() throws Throwable {
        this(null, null);
    }

    public void setActiveDS(DataSource activeDS) {
        DataSourceListModel.setActiveDS2(activeDS);
        if (textShow == null) {
            return;
        }
        if (ads != null) {
            textShow.setText("\u5f53\u524d\u6570\u636e\u6e90\uff1a  " + ads.getSourceName());
        } else {
            textShow.setText("\u8fde\u63a5\u5df2\u5173\u95ed\u3002");
        }
    }

    public static void setActiveDS2(DataSource activeDS) {
        ads = activeDS;
    }

    public static DataSource getActiveDS() {
        return ads;
    }

    public RQConnection getActiveConnection() throws Throwable {
        String name = ads.getSourceName();
        return this.getRQConnection(name);
    }

    public boolean sameName(String id, String name) {
        Enumeration dd = this.elements();
        DataSource ss = new DataSource();
        while (dd.hasMoreElements()) {
            String tmpName;
            ss = (DataSource)dd.nextElement();
            String tmpId = ss.getID();
            if (id != null && id.equals(tmpId) || !(tmpName = ss.getSourceName()).equals(name)) continue;
            return true;
        }
        return false;
    }

    public DataSource getDataSource(String name) throws Exception {
        Enumeration dd = this.elements();
        while (dd.hasMoreElements()) {
            DataSource ss = (DataSource)dd.nextElement();
            String tmpName = ss.getSourceName();
            if (!name.equalsIgnoreCase(tmpName)) continue;
            return ss;
        }
        throw new Exception("\u6570\u636e\u6e90 " + name + " \u6ca1\u6709\u5b9a\u4e49\u3002");
    }

    public RQConnection getRQConnection(String name) throws Exception {
        RQConnection tmpConnection = (RQConnection)this.connectionPool.get(name);
        if (tmpConnection == null) {
            DataSource ds = this.getDataSource(name);
            tmpConnection = ds.connect();
            this.connectionPool.put(name, tmpConnection);
        }
        return tmpConnection;
    }

    public DataSource[] listDataSources() {
        Enumeration dd = this.elements();
        Vector v = new Vector();
        while (dd.hasMoreElements()) {
            v.addElement(dd.nextElement());
        }
        DataSource[] ss = null;
        if (v.size() > 0) {
            ss = new DataSource[v.size()];
            int i = 0;
            while (i < v.size()) {
                ss[i] = (DataSource)v.get(i);
                ++i;
            }
        }
        return ss;
    }

    public void load() throws Throwable {
        XMLFile file = new XMLFile(sFile);
        Section ss = new Section();
        ss = file.listElement(sPath);
        int iElement = ss.countSection();
        String id = "";
        String value = "";
        int i = 0;
        while (i < iElement) {
            id = ss.getSection(i);
            DataSource tempDataSource = new DataSource();
            tempDataSource.setID(id);
            value = file.getAttribute(String.valueOf(sPath) + "/" + id + "/name");
            tempDataSource.setSourceName(value);
            value = file.getAttribute(String.valueOf(sPath) + "/" + id + "/dbtype");
            tempDataSource.setDBType(Integer.valueOf(value));
            value = file.getAttribute(String.valueOf(sPath) + "/" + id + "/drivername");
            tempDataSource.setDriverName(value);
            value = file.getAttribute(String.valueOf(sPath) + "/" + id + "/urlpath");
            tempDataSource.setUrlPath(value);
            value = file.getAttribute(String.valueOf(sPath) + "/" + id + "/userid");
            tempDataSource.setUserID(value);
            value = file.getAttribute(String.valueOf(sPath) + "/" + id + "/password");
            tempDataSource.setPassWord(value);
            value = file.getAttribute(String.valueOf(sPath) + "/" + id + "/dbencoding");
            tempDataSource.setDBEncoding(value);
            value = file.getAttribute(String.valueOf(sPath) + "/" + id + "/encodeSQL");
            tempDataSource.setEncodeSQL(new Boolean(value));
            value = file.getAttribute(String.valueOf(sPath) + "/" + id + "/extendproperties");
            tempDataSource.setExtendProperties(value);
            this.addElement(tempDataSource);
            ++i;
        }
    }

    public void save() throws Throwable {
        String id;
        Enumeration dd = this.elements();
        XMLFile file = new XMLFile(sFile);
        Section ss = new Section();
        ss = file.listElement(sPath);
        int iElement = ss.countSection();
        int i = 0;
        while (i < iElement) {
            id = ss.getSection(i);
            file.deleteElement(String.valueOf(sPath) + "/" + id);
            ++i;
        }
        i = 0;
        while (dd.hasMoreElements()) {
            DataSource tempDataSource = new DataSource((DataSource)dd.nextElement());
            id = "DS" + i++;
            String name = tempDataSource.getSourceName();
            file.newElement(sPath, id);
            file.setAttribute(String.valueOf(sPath) + "/" + id + "/name", tempDataSource.getSourceName());
            file.setAttribute(String.valueOf(sPath) + "/" + id + "/dbtype", Integer.toString(tempDataSource.getDBType()));
            file.setAttribute(String.valueOf(sPath) + "/" + id + "/drivername", tempDataSource.getDriverName());
            file.setAttribute(String.valueOf(sPath) + "/" + id + "/urlpath", tempDataSource.getUrlPath());
            file.setAttribute(String.valueOf(sPath) + "/" + id + "/userid", tempDataSource.getUserID());
            file.setAttribute(String.valueOf(sPath) + "/" + id + "/password", tempDataSource.getPassWord());
            file.setAttribute(String.valueOf(sPath) + "/" + id + "/dbencoding", tempDataSource.getDBEncoding());
            file.setAttribute(String.valueOf(sPath) + "/" + id + "/encodeSQL", Boolean.toString(tempDataSource.getEncodeSQL()));
            file.setAttribute(String.valueOf(sPath) + "/" + id + "/extendproperties", tempDataSource.getExtendProperties());
        }
        file.save();
    }
}

