/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import com.runqian.base.module.DataSource;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class DataSourceRenderer
extends JLabel
implements ListCellRenderer {
    protected static Border m_noFocusBorder;
    protected FontMetrics m_fm = null;
    protected Insets m_insets = new Insets(0, 0, 0, 0);
    protected int m_defaultTab = 50;
    protected int[] m_tabs = null;

    public DataSourceRenderer() {
        m_noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        this.setOpaque(true);
        this.setBorder(m_noFocusBorder);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        DataSource source = (DataSource)value;
        String dispText = source.getSourceName();
        if (source.isClosed()) {
            this.setForeground(Color.black);
            this.setText(String.valueOf(dispText) + " [\u672a\u8fde\u63a5]");
        } else {
            this.setForeground(Color.magenta);
            this.setText(String.valueOf(dispText) + " [\u5df2\u8fde\u63a5]");
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setBackground(list.getBackground());
        }
        this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : m_noFocusBorder);
        return this;
    }

    public void setDefaultTab(int defaultTab) {
        this.m_defaultTab = defaultTab;
    }

    public int getDefaultTab() {
        return this.m_defaultTab;
    }

    public void setTabs(int[] tabs) {
        this.m_tabs = tabs;
    }

    public int[] getTabs() {
        return this.m_tabs;
    }

    public int getTab(int index) {
        if (this.m_tabs == null) {
            return this.m_defaultTab * index;
        }
        int len = this.m_tabs.length;
        if (index >= 0 && index < len) {
            return this.m_tabs[index];
        }
        return this.m_tabs[len - 1] + this.m_defaultTab * (index - len + 1);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color colorRetainer = g.getColor();
        this.m_fm = g.getFontMetrics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.getBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        this.m_insets = this.getInsets();
        int x = this.m_insets.left;
        int y = this.m_insets.top + this.m_fm.getAscent();
        StringTokenizer st = new StringTokenizer(this.getText(), "\t");
        while (st.hasMoreTokens()) {
            String sNext = st.nextToken();
            g.drawString(sNext, x, y);
            x += this.m_fm.stringWidth(sNext);
            if (!st.hasMoreTokens()) break;
            int index = 0;
            while (x >= this.getTab(index)) {
                ++index;
            }
            x = this.getTab(index);
        }
        g.setColor(colorRetainer);
    }
}

