/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import com.runqian.base.util.Macros;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class DialogMacro
extends JDialog
implements FocusListener,
ActionListener {
    private JTable macroTable;
    private String macroString;
    private JButton addButton;
    private JButton delButton;
    private JButton okButton;
    private JButton cancelButton;
    private int m_option = 2;

    public DialogMacro(String macroString, JFrame owner) {
        super(owner);
        Object[][] data;
        this.setTitle("\u62a5\u8868\u5b8f\u7f16\u8f91");
        this.setModal(true);
        this.setSize(450, 300);
        Dimension size = this.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int newX = (screenSize.width - size.width) / 2;
        int newY = (screenSize.height - size.height) / 2;
        this.setLocation(newX, newY);
        this.macroString = macroString;
        if (macroString == null || macroString.trim().length() == 0) {
            data = new String[0][3];
        } else {
            Macros macros = new Macros(macroString);
            int count = macros.size();
            data = new String[count][3];
            int i = 0;
            while (i < count) {
                data[i][0] = macros.getName(i);
                data[i][1] = macros.getTitle(i);
                data[i][2] = macros.getValue(i);
                ++i;
            }
        }
        Object[] columnNames = new String[]{"\u5b8f\u540d\u79f0", "\u5b8f\u4e2d\u6587\u540d", "\u5b8f\u5b9a\u4e49"};
        this.macroTable = new JTable(new DefaultTableModel(data, columnNames));
        this.macroTable.addFocusListener(this);
        this.macroTable.setRowHeight(22);
        Container pane = this.getContentPane();
        pane.add(new JScrollPane(this.macroTable));
        this.setClickCount();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel panel1 = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel(new BorderLayout());
        panel.add((Component)panel1, "North");
        panel.add((Component)panel2, "South");
        this.addButton = new JButton("\u6dfb\u52a0(A)");
        this.addButton.setMnemonic('A');
        this.initButton(this.addButton);
        panel1.add((Component)this.addButton, "North");
        this.delButton = new JButton("\u5220\u9664(D)");
        this.delButton.setMnemonic('D');
        this.initButton(this.delButton);
        panel1.add((Component)this.delButton, "South");
        JPanel p1 = new JPanel();
        p1.setSize(1, 10);
        panel1.add(p1);
        this.okButton = new JButton("\u786e\u5b9a(O)");
        this.okButton.setMnemonic('O');
        this.initButton(this.okButton);
        panel2.add((Component)this.okButton, "North");
        this.cancelButton = new JButton("\u53d6\u6d88(C)");
        this.cancelButton.setMnemonic('C');
        this.initButton(this.cancelButton);
        panel2.add((Component)this.cancelButton, "South");
        JPanel p2 = new JPanel();
        p2.setSize(1, 10);
        panel2.add(p2);
        pane.add((Component)panel, "East");
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.requestFocus();
    }

    public void actionPerformed(ActionEvent e) {
        JComponent jc = (JComponent)e.getSource();
        if (jc.equals(this.okButton)) {
            this.m_option = 0;
            this.dispose();
        } else if (jc.equals(this.cancelButton)) {
            this.m_option = 2;
            this.dispose();
        } else if (jc.equals(this.addButton)) {
            ((DefaultTableModel)this.macroTable.getModel()).addRow(new Object[]{"", "", ""});
            this.setClickCount();
        } else if (jc.equals(this.delButton)) {
            int currRow = this.macroTable.getSelectedRow();
            if (currRow < 0) {
                JOptionPane.showMessageDialog(this, "\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5b8f!");
                return;
            }
            ((DefaultTableModel)this.macroTable.getModel()).removeRow(currRow);
        }
        TableCellEditor editor = this.macroTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    private void setClickCount() {
        int rows = this.macroTable.getRowCount();
        int cols = this.macroTable.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                TableCellEditor editor = this.macroTable.getCellEditor(row, col);
                if (editor != null && editor instanceof DefaultCellEditor) {
                    ((DefaultCellEditor)editor).setClickCountToStart(1);
                }
                ++col;
            }
            ++row;
        }
    }

    private void initButton(JButton button) {
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setPreferredSize(new Dimension(60, 22));
        button.addActionListener(this);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public int getOption() {
        return this.m_option;
    }

    public String getMacroString() {
        Macros macros = new Macros();
        TableModel model = this.macroTable.getModel();
        int rows = this.macroTable.getRowCount();
        int row = 0;
        while (row < rows) {
            String en = (String)model.getValueAt(row, 0);
            String ch = (String)model.getValueAt(row, 1);
            String def = (String)model.getValueAt(row, 2);
            if (en != null && en.trim().length() != 0) {
                macros.add(en, ch, def);
            }
            ++row;
        }
        return macros.toString();
    }
}

