/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import com.runqian.base.module.DialogTableImport_jBClose_actionAdapter;
import com.runqian.base.module.DialogTableImport_jBImport_actionAdapter;
import com.runqian.base.module.DialogTableImport_jBsfile_actionAdapter;
import com.runqian.base.module.DialogTableImport_this_windowAdapter;
import com.runqian.base.swing.JListEx;
import com.runqian.base.swing.VFlowLayout;
import com.runqian.base.tool.AppTools;
import com.runqian.base.tool.Tools;
import com.runqian.base.tool.XMLFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogTableImport
extends JDialog {
    JFrame parentWin;
    BorderLayout borderLayout1 = new BorderLayout();
    Vector vtDSItem = new Vector();
    JPanel jPanel1 = new JPanel();
    VFlowLayout vFlowLayout1 = new VFlowLayout();
    JButton jBClose = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    protected int m_option = -1;
    JButton jBImport = new JButton();
    JListEx jList1 = new JListEx();
    XMLFile file = null;
    XMLFile srcFile = null;
    JButton jBsfile = new JButton();
    String currentDirectory = System.getProperty("user.dir");

    public int getOption() {
        return this.m_option;
    }

    public DialogTableImport(JFrame parentWin) {
        super((Frame)parentWin, true);
        try {
            this.parentWin = parentWin;
            this.jbInit();
            this.setSize(500, 400);
            Tools.centerWindow(this);
        }
        catch (Throwable e) {
            Tools.showException(e);
        }
    }

    private void loadTables(File srcfile) throws Throwable {
        this.file = new XMLFile(AppTools.CONFIG_FILE);
        this.srcFile = new XMLFile(srcfile.getAbsolutePath());
        this.jList1.setListData(this.srcFile.listElement("RUNQIAN/TABLES").toString());
    }

    private void jbInit() throws Exception {
        this.setTitle("\u5bfc\u5165\u6570\u636e\u8868\u5b9a\u4e49");
        this.getContentPane().setLayout(this.borderLayout1);
        this.setModal(true);
        this.jPanel1.setLayout(this.vFlowLayout1);
        this.jBClose.setText("\u5173\u95ed(C)");
        this.jBClose.addActionListener(new DialogTableImport_jBClose_actionAdapter(this));
        this.jBClose.setMnemonic('C');
        this.jBImport.setMnemonic('I');
        this.jBImport.setText("\u5bfc\u5165(I)");
        this.jBImport.addActionListener(new DialogTableImport_jBImport_actionAdapter(this));
        this.jBsfile.setSelectedIcon(null);
        this.jBsfile.setText("\u6e90\u6587\u4ef6");
        this.jBsfile.addActionListener(new DialogTableImport_jBsfile_actionAdapter(this));
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jBsfile, null);
        this.jPanel1.add((Component)this.jBImport, null);
        this.jPanel1.add((Component)this.jBClose, null);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jList1, null);
        this.addWindowListener(new DialogTableImport_this_windowAdapter(this));
        this.getRootPane().setDefaultButton(this.jBClose);
        this.jBClose.requestFocus();
    }

    void jBImport_actionPerformed(ActionEvent e) {
        Object[] items = this.jList1.getSelectedValues();
        try {
            if (items.length < 1) {
                JOptionPane.showMessageDialog(this.parentWin, "\u8bf7\u9009\u62e9\u8981\u5bfc\u5165\u7684\u8868\u3002");
            } else {
                if (!this.file.isPathExists("RUNQIAN/TABLES")) {
                    this.file.newElement("RUNQIAN", "TABLES");
                }
                int i = 0;
                while (i < items.length) {
                    this.importTable((String)items[i]);
                    ++i;
                }
                this.file.save();
                JOptionPane.showMessageDialog(this.parentWin, "\u5bfc\u5165\u6570\u636e\u8868\u5b8c\u6210\u3002");
            }
        }
        catch (Exception e1) {
            Tools.showException(e1);
        }
    }

    void importTable(String table) throws Exception {
        String tmpPath = "RUNQIAN/TABLES/" + table;
        Vector cols = this.srcFile.listAttribute(tmpPath).toVector();
        Vector txts = AppTools.getFieldTitle(this.srcFile, table, cols, true);
        if (this.file.isPathExists(tmpPath)) {
            int k = JOptionPane.showConfirmDialog(this, "\u5b58\u5728\u540c\u540d\u7684\u6570\u636e\u8868" + table + ",\u8986\u76d6\u5417\uff1f", "\u63d0\u793a", 2);
            if (k == 0) {
                this.file.deleteElement(tmpPath);
            } else {
                return;
            }
        }
        this.file.newElement("RUNQIAN/TABLES", table);
        int i = 0;
        while (i < cols.size()) {
            String tmpTxt = (String)txts.get(i);
            if (!Tools.isValidString(tmpTxt)) {
                tmpTxt = "";
            }
            this.file.setAttribute(String.valueOf(tmpPath) + '/' + (String)cols.get(i), tmpTxt);
            ++i;
        }
    }

    void jBClose_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void jBsfile_actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser(this.currentDirectory);
        chooser.setFileFilter(Tools.getFileFilter(".xml", "*.xml"));
        if (chooser.showOpenDialog(this.parentWin) != 0) {
            return;
        }
        this.currentDirectory = chooser.getSelectedFile().getParent();
        File file = chooser.getSelectedFile();
        try {
            this.loadTables(file);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, "\u60a8\u6253\u5f00\u7684\u6587\u4ef6\u6ca1\u6709\u8981\u767b\u8bb0\u7684\u8868\u3002");
        }
    }
}

