/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import com.essbase.api.datasource.IEssOlapServer;
import com.essbase.api.domain.IEssDomain;
import com.essbase.api.session.IEssbase;
import com.runqian.base.tool.Segment;
import com.runqian.base.tool.Tools;
import com.runqian.base.util.OLAPSession;
import java.util.Properties;

public class OLAPSessionFactory {
    private Properties prop;
    public static String DB_TYPE = "DBType";
    public static String ESSBASE_IP = "IP";
    public static String ESSBASE_DOMAIN = "Domain";
    public static String ESSBASE_PLUGINTYPE = "PluginType";
    public static String ESSBASE_PORT = "Port";
    public static String ESSBASE_OLAPSVR = "OlapSvr";
    public static String ESSBASE_USER = "User";
    public static String ESSBASE_PASSWORD = "Password";
    public static String ESSBASE_TYPE_CUBE_RETRIEVE = "CUBE_RETRIEVE";
    public static String ESSBASE_TYPE_DIM_VIEW = "DIM_VIEW";

    public static String[] getParaKeys(int dbType) {
        if (dbType == 101) {
            return new String[]{ESSBASE_IP, ESSBASE_DOMAIN, ESSBASE_PLUGINTYPE, ESSBASE_PORT, ESSBASE_OLAPSVR, ESSBASE_USER, ESSBASE_PASSWORD};
        }
        return new String[0];
    }

    public void setProperties(Properties props) {
        this.prop = props;
    }

    public static String convert2EssbaseCmd(String strDefine) {
        Segment olap = new Segment(strDefine);
        String sRow = "";
        String sTmp = olap.get("colcount");
        int cc = 0;
        if (Tools.isValidString(sTmp)) {
            cc = Integer.parseInt(sTmp);
            int i = 0;
            while (i < cc) {
                sTmp = olap.get(Integer.toString(i));
                sRow = String.valueOf(sRow) + " " + sTmp;
                ++i;
            }
        }
        String dims = olap.get("dims");
        if (cc > 0) {
            return "{INDENT 0} {INDENTGEN 0} {ROWREPEAT} <ROW(" + dims + ") " + sRow + " !";
        }
        return "";
    }

    public OLAPSession createSession() {
        IEssOlapServer session = null;
        String sValue = this.prop.getProperty(DB_TYPE);
        int DBType = Integer.parseInt(sValue);
        try {
            if (DBType == 101) {
                session = this.createEssBase();
            }
            if (session == null) {
                return null;
            }
            return new OLAPSession(DBType, session);
        }
        catch (Exception x) {
            Tools.showException(x);
            return null;
        }
    }

    private IEssOlapServer createEssBase() throws Exception {
        IEssbase ess = null;
        IEssOlapServer olapSvr = null;
        ess = IEssbase.Home.create((String)"6.5.1");
        String s_userName = this.prop.getProperty(ESSBASE_USER);
        String s_password = this.prop.getProperty(ESSBASE_PASSWORD);
        String s_domainName = this.prop.getProperty(ESSBASE_DOMAIN);
        String s_prefEesSvrName = this.prop.getProperty(ESSBASE_OLAPSVR);
        String s_tmp = this.prop.getProperty(ESSBASE_PLUGINTYPE);
        IEssbase.EEssOrbPluginType ess_orbType = IEssbase.EEssOrbPluginType.sm_fromString((String)s_tmp);
        s_tmp = this.prop.getProperty(ESSBASE_PORT);
        int i_port = Integer.parseInt(s_tmp);
        IEssDomain dom = ess.signOn(s_userName, s_password, s_domainName, s_prefEesSvrName, ess_orbType, i_port);
        String s_olapSvr = this.prop.getProperty(ESSBASE_OLAPSVR);
        olapSvr = dom.getOlapServer(s_olapSvr);
        olapSvr.connect();
        return olapSvr;
    }
}

