/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import com.essbase.api.datasource.IEssCube;
import com.essbase.api.datasource.IEssOlapApplication;
import com.essbase.api.metadata.IEssCubeOutline;
import com.essbase.api.metadata.IEssDimension;
import com.essbase.api.metadata.IEssMember;
import com.runqian.base.tool.Tools;
import javax.swing.Icon;
import javax.swing.ImageIcon;

class OlapTreeNode {
    String name;
    int type;
    Object data;
    public static final int T_OLAPSERVER = 0;
    public static final int T_APPLICATION = 1;
    public static final int T_CUBE = 2;
    public static final int T_DIMENSION = 3;
    public static final int T_MEMBER = 4;
    public String appName;
    public String cubeName;
    public String dimName;
    public String mbrName;

    public OlapTreeNode(String name, int type, Object data) throws Exception {
        this.name = name;
        this.type = type;
        this.data = data;
        this.extractParentName();
    }

    public Icon getDispIcon(boolean isLeaf) {
        String url = "/com/runqian/base/module/img/tree";
        ImageIcon icon = isLeaf ? Tools.getImageIcon(String.valueOf(url) + "leaf.gif") : Tools.getImageIcon(String.valueOf(url) + Integer.toString(this.type) + ".gif");
        return icon;
    }

    private void extractParentName() throws Exception {
        switch (this.type) {
            case 3: 
            case 4: {
                IEssMember em = (IEssMember)this.data;
                this.mbrName = em.getName();
                while (em.getParentBase() instanceof IEssMember) {
                    em = (IEssMember)em.getParentBase();
                }
                IEssDimension ed = (IEssDimension)em.getParentBase();
                this.dimName = ed.getName();
                IEssCubeOutline eco = (IEssCubeOutline)ed.getParentBase();
                IEssCube ec = (IEssCube)eco.getParentBase();
                this.cubeName = ec.getName();
                IEssOlapApplication ea = (IEssOlapApplication)ec.getParentBase();
                this.appName = ea.getName();
                break;
            }
        }
    }

    public String getToolTip() {
        String sTip = "";
        switch (this.type) {
            case 0: {
                sTip = "OLAP\u670d\u52a1\u5668\u540d\u79f0";
                break;
            }
            case 1: {
                sTip = "\u5e94\u7528\u540d\u79f0";
                break;
            }
            case 2: {
                sTip = "\u6570\u636e\u5e93Cube";
                break;
            }
            case 3: {
                sTip = "\u7ef4";
                break;
            }
            case 4: {
                sTip = "\u6210\u5458";
            }
        }
        return String.valueOf(sTip) + " " + this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public Object getData() {
        return this.data;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        return this.name;
    }
}

