/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import com.runqian.base.tool.Tools;
import com.runqian.base.util.OLAPSession;
import java.sql.Connection;

public class RQConnection {
    private Connection cnn;
    private OLAPSession olapSvr = null;
    private int DBType;
    private String DBEncoding;
    private boolean encodeSQL = false;

    public RQConnection() {
    }

    public RQConnection(Connection cnn, int dbtype, String dbencoding) {
        this(cnn, dbtype, dbencoding, false);
    }

    public RQConnection(Connection cnn, int dbtype, String dbencoding, boolean encodeSql) {
        this.cnn = cnn;
        this.DBType = dbtype;
        this.DBEncoding = dbencoding;
        this.encodeSQL = encodeSql;
    }

    public RQConnection(OLAPSession olapSvr, int dbtype) {
        this.olapSvr = olapSvr;
        this.DBType = dbtype;
    }

    public OLAPSession getOlapServer() {
        return this.olapSvr;
    }

    public Connection getConnection() {
        return this.cnn;
    }

    public void setConnection(Connection connection) {
        this.cnn = connection;
    }

    public void setOlapSession(OLAPSession olapServer) {
        this.olapSvr = olapServer;
    }

    public void close() throws Exception {
        if (this.DBType > 100) {
            this.olapSvr.close();
        } else {
            this.cnn.close();
        }
    }

    public boolean getEncodeSQL() {
        return this.encodeSQL;
    }

    public void setEncodeSQL(boolean encodeSql) {
        this.encodeSQL = encodeSql;
    }

    public int getDBType() {
        return this.DBType;
    }

    public void setDBType(int dbtype) {
        this.DBType = dbtype;
    }

    public String getDBEncoding() {
        return this.DBEncoding;
    }

    public boolean isClosed() throws Exception {
        if (this.DBType > 100) {
            return this.olapSvr.isClosed();
        }
        return this.cnn.isClosed();
    }

    public void setDBEncoding(String dbencoding) {
        this.DBEncoding = !Tools.isValidString(dbencoding) ? "GBK" : dbencoding;
    }
}

