/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XMLRoutines {
    XMLRoutines() {
    }

    public static void write(Document doc, Writer out) throws Exception {
        XMLRoutines.write(doc.getDocumentElement(), out);
    }

    public static void write(Node node, Writer out) throws Exception {
        if (node == null || out == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                XMLRoutines.write(((Document)node).getDocumentElement(), out);
                out.flush();
                break;
            }
            case 1: {
                out.write(60);
                out.write(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                int k = 0;
                while (k < attrs.getLength()) {
                    Node attr = attrs.item(k);
                    out.write(32);
                    out.write(attr.getNodeName());
                    out.write("=\"");
                    out.write(attr.getNodeValue());
                    out.write(34);
                    ++k;
                }
                out.write(62);
                break;
            }
            case 5: {
                out.write(38);
                out.write(node.getNodeName());
                out.write(59);
                break;
            }
            case 4: {
                out.write("<![CDATA[");
                out.write(node.getNodeValue());
                out.write("]]>");
                break;
            }
            case 3: {
                out.write(node.getNodeValue());
                break;
            }
            case 7: {
                out.write("<?");
                out.write(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.write(32);
                    out.write(data);
                }
                out.write("?>");
                break;
            }
            default: {
                out.write("<TYPE=" + type);
                out.write(node.getNodeName());
                out.write("?>");
            }
        }
        NodeList children = node.getChildNodes();
        if (children != null) {
            int k = 0;
            while (k < children.getLength()) {
                XMLRoutines.write(children.item(k), out);
                ++k;
            }
        }
        if (node.getNodeType() == 1) {
            out.write("</");
            out.write(node.getNodeName());
            out.write(62);
        }
        out.flush();
    }
}

