/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import com.runqian.base.module.XMLRoutines;
import com.runqian.base.module.XmlEditorNode;
import com.runqian.base.tool.Tools;
import com.sun.xml.util.XmlNames;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlEditor
extends JFrame {
    public static final String APP_NAME = "XML\u6587\u4ef6\u7f16\u8f91\u5668";
    protected Document m_doc;
    protected boolean m_isModified;
    protected JTree m_tree;
    protected JScrollPane m_treeScrollPane;
    protected DefaultTreeModel m_model;
    protected DefaultTreeCellEditor m_treeEditor;
    protected Node m_editingNode = null;
    protected JTable m_table;
    protected AttrTableModel m_tableModel;
    protected JFileChooser m_chooser;
    protected File m_currentFile;
    protected JFileChooser m_saver;
    protected JButton m_saveBtn;
    protected JButton m_saveAsBtn;
    protected JButton m_addNodeBtn;
    protected JButton m_editNodeBtn;
    protected JButton m_delNodeBtn;
    protected JButton m_addAttrBtn;
    protected JButton m_editAttrBtn;
    protected JButton m_delAttrBtn;
    protected Cursor m_dragCursor;
    protected Cursor m_nodropCursor;
    protected XmlEditorNode m_draggingTreeNode;
    protected XmlEditorNode m_draggingOverNode;
    String IMG_PATH = "/com/runqian/base/module/img/";

    public XmlEditor() {
        super(APP_NAME);
        this.setSize(800, 600);
        this.getContentPane().setLayout(new BorderLayout());
        this.setIconImage(Tools.getImageIcon(String.valueOf(this.IMG_PATH) + "APP_ICON.gif").getImage());
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        JButton bt = new JButton(Tools.getImageIcon(String.valueOf(this.IMG_PATH) + "New24.gif"));
        bt.setToolTipText("\u65b0\u5efa");
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!XmlEditor.this.canContinue()) {
                    return;
                }
                XmlEditor.this.newXml();
            }
        };
        bt.addActionListener(lst);
        tb.add(bt);
        bt = new JButton(Tools.getImageIcon(String.valueOf(this.IMG_PATH) + "Open24.gif"));
        bt.setToolTipText("\u6253\u5f00");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!XmlEditor.this.canContinue()) {
                    return;
                }
                if (XmlEditor.this.m_chooser == null) {
                    XmlEditor.this.m_chooser = new JFileChooser();
                    XmlEditor.this.m_chooser.setCurrentDirectory(new File("."));
                    XmlEditor.this.m_chooser.setDialogTitle("\u6253\u5f00 XML \u6587\u4ef6");
                    XmlEditor.this.m_chooser.setFileSelectionMode(0);
                }
                if (XmlEditor.this.m_chooser.showOpenDialog(XmlEditor.this) != 0) {
                    return;
                }
                File f = XmlEditor.this.m_chooser.getSelectedFile();
                if (f != null && f.isFile()) {
                    XmlEditor.this.m_currentFile = f;
                    XmlEditor.this.readXml(f.getAbsolutePath());
                }
            }
        };
        bt.addActionListener(lst);
        tb.add(bt);
        this.m_saveBtn = new JButton(Tools.getImageIcon(String.valueOf(this.IMG_PATH) + "Save24.gif"));
        this.m_saveBtn.setToolTipText("\u4fdd\u5b58");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XmlEditor.this.saveXml(XmlEditor.this.m_currentFile);
            }
        };
        this.m_saveBtn.addActionListener(lst);
        this.m_saveBtn.setEnabled(false);
        tb.add(this.m_saveBtn);
        this.m_saveAsBtn = new JButton(Tools.getImageIcon(String.valueOf(this.IMG_PATH) + "SaveAs24.gif"));
        this.m_saveAsBtn.setToolTipText("\u53e6\u5b58\u4e3a");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XmlEditor.this.saveXml(null);
            }
        };
        this.m_saveAsBtn.addActionListener(lst);
        this.m_saveAsBtn.setEnabled(false);
        tb.add(this.m_saveAsBtn);
        tb.addSeparator();
        JLabel tmpLabel = new JLabel("\u5143\u7d20:");
        tb.add(tmpLabel);
        this.m_addNodeBtn = new JButton(Tools.getImageIcon(String.valueOf(this.IMG_PATH) + "Add24.gif"));
        this.m_addNodeBtn.setToolTipText("\u6dfb\u52a0");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XmlEditor.this.addNewNode();
            }
        };
        this.m_addNodeBtn.addActionListener(lst);
        tb.add(this.m_addNodeBtn);
        this.m_editNodeBtn = new JButton(Tools.getImageIcon(String.valueOf(this.IMG_PATH) + "Edit24.gif"));
        this.m_editNodeBtn.setToolTipText("\u7f16\u8f91");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XmlEditor.this.editNode();
            }
        };
        this.m_editNodeBtn.addActionListener(lst);
        tb.add(this.m_editNodeBtn);
        this.m_delNodeBtn = new JButton(Tools.getImageIcon(String.valueOf(this.IMG_PATH) + "Delete24.gif"));
        this.m_delNodeBtn.setToolTipText("\u5220\u9664");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XmlEditor.this.deleteNode();
            }
        };
        this.m_delNodeBtn.addActionListener(lst);
        tb.add(this.m_delNodeBtn);
        tb.addSeparator();
        tmpLabel = new JLabel("\u5c5e\u6027:");
        tb.add(tmpLabel);
        this.m_addAttrBtn = new JButton(Tools.getImageIcon(String.valueOf(this.IMG_PATH) + "Add24.gif"));
        this.m_addAttrBtn.setToolTipText("\u6dfb\u52a0");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XmlEditor.this.addNewAttribute();
            }
        };
        this.m_addAttrBtn.addActionListener(lst);
        tb.add(this.m_addAttrBtn);
        this.m_editAttrBtn = new JButton(Tools.getImageIcon(String.valueOf(this.IMG_PATH) + "Edit24.gif"));
        this.m_editAttrBtn.setToolTipText("\u7f16\u8f91");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XmlEditor.this.editAttribute();
            }
        };
        this.m_editAttrBtn.addActionListener(lst);
        tb.add(this.m_editAttrBtn);
        this.m_delAttrBtn = new JButton(Tools.getImageIcon(String.valueOf(this.IMG_PATH) + "Delete24.gif"));
        this.m_delAttrBtn.setToolTipText("\u5220\u9664");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XmlEditor.this.deleteAttribute();
            }
        };
        this.m_delAttrBtn.addActionListener(lst);
        tb.add(this.m_delAttrBtn);
        this.getContentPane().add((Component)tb, "North");
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("\u7a7a\u767d\u8282\u70b9");
        this.m_model = new DefaultTreeModel(top);
        this.m_tree = new JTree(this.m_model);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setShowsRootHandles(true);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){
            Color m_draggingBackground = new Color(0, 0, 128);
            Color m_draggingForeground = Color.white;
            Color m_standardBackground = this.getBackgroundNonSelectionColor();
            Color m_standardForeground = this.getTextNonSelectionColor();

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value == XmlEditor.this.m_draggingOverNode) {
                    this.setBackgroundNonSelectionColor(this.m_draggingBackground);
                    this.setTextNonSelectionColor(this.m_draggingForeground);
                    sel = false;
                } else {
                    this.setBackgroundNonSelectionColor(this.m_standardBackground);
                    this.setTextNonSelectionColor(this.m_standardForeground);
                }
                Component res = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof XmlEditorNode) {
                    Node node = ((XmlEditorNode)value).getXmlNode();
                    if (node instanceof Element) {
                        this.setIcon(expanded ? this.openIcon : this.closedIcon);
                    } else {
                        this.setIcon(this.leafIcon);
                    }
                }
                return res;
            }
        };
        this.m_tree.setCellRenderer(renderer);
        this.m_treeEditor = new DefaultTreeCellEditor(this.m_tree, renderer){

            public boolean isCellEditable(EventObject event) {
                Node node = XmlEditor.this.getSelectedNode();
                if (node != null && node.getNodeType() == 3) {
                    return super.isCellEditable(event);
                }
                return false;
            }

            public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
                if (value instanceof XmlEditorNode) {
                    XmlEditor.this.m_editingNode = ((XmlEditorNode)value).getXmlNode();
                }
                return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
            }
        };
        this.m_treeEditor.addCellEditorListener(new XmlEditorListener());
        this.m_tree.setCellEditor(this.m_treeEditor);
        this.m_tree.setEditable(true);
        this.m_tree.setInvokesStopCellEditing(true);
        this.m_tableModel = new AttrTableModel();
        this.m_table = new JTable(this.m_tableModel);
        this.m_treeScrollPane = new JScrollPane(this.m_tree);
        JScrollPane s2 = new JScrollPane(this.m_table);
        s2.getViewport().setBackground(this.m_table.getBackground());
        JSplitPane sp = new JSplitPane(1, this.m_treeScrollPane, s2);
        sp.setDividerLocation(400);
        sp.setDividerSize(5);
        this.getContentPane().add((Component)sp, "Center");
        TreeSelectionListener lSel = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                Node node = XmlEditor.this.getSelectedNode();
                XmlEditor.this.setNodeToTable(node);
                XmlEditor.this.enableNodeButtons();
                XmlEditor.this.enableAttrButtons();
            }
        };
        this.m_tree.addTreeSelectionListener(lSel);
        ListSelectionListener lTbl = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                XmlEditor.this.enableAttrButtons();
            }
        };
        this.m_table.getSelectionModel().addListSelectionListener(lTbl);
        this.enableNodeButtons();
        this.enableAttrButtons();
        try {
            ImageIcon icon = new ImageIcon("dnd-cursor.gif");
            this.m_dragCursor = Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), new Point(5, 5), "D&D Cursor");
            icon = new ImageIcon("dnd-nodrop.gif");
            this.m_nodropCursor = Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), new Point(15, 15), "NoDrop Cursor");
        }
        catch (Exception ex) {
            System.out.println("Loading cursor: " + ex);
            this.m_nodropCursor = this.m_dragCursor = Cursor.getPredefinedCursor(12);
        }
        TreeMouseListener dnd = new TreeMouseListener();
        this.m_tree.addMouseListener(dnd);
        this.m_tree.addMouseMotionListener(dnd);
        this.setDefaultCloseOperation(0);
        WindowAdapter wndCloser = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (XmlEditor.this.canContinue()) {
                    XmlEditor.this.dispose();
                }
            }
        };
        this.addWindowListener(wndCloser);
        this.setVisible(true);
    }

    public void newXml() {
        String input = (String)JOptionPane.showInputDialog(this, "\u8bf7\u8f93\u5165\u65b0\u7684XML\u6587\u4ef6\u7684\u6839\u5143\u7d20\u540d\u79f0", APP_NAME, -1, null, null, "");
        if (!this.isLegalXmlName(input)) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.m_doc = docBuilder.newDocument();
            Element root = this.m_doc.createElement(input);
            root.normalize();
            this.m_doc.appendChild(root);
            DefaultMutableTreeNode top = this.createTreeNode(root);
            this.m_model.setRoot(top);
            this.m_tree.treeDidChange();
            XmlEditor.expandTree(this.m_tree);
            this.setNodeToTable(null);
            this.setTitle("XML\u6587\u4ef6\u7f16\u8f91\u5668 [untitled]");
            this.m_currentFile = null;
            this.m_saveBtn.setEnabled(true);
            this.m_saveAsBtn.setEnabled(true);
            this.m_isModified = true;
        }
        catch (Exception ex) {
            this.showError(ex, "\u521b\u5efa\u65b0 XML \u6587\u4ef6\u51fa\u9519\u3002");
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void readXml(String fileName) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            File f = new File(fileName);
            this.m_doc = docBuilder.parse(f);
            Element root = this.m_doc.getDocumentElement();
            root.normalize();
            DefaultMutableTreeNode top = this.createTreeNode(root);
            this.m_model.setRoot(top);
            this.m_tree.treeDidChange();
            XmlEditor.expandTree(this.m_tree);
            this.setNodeToTable(null);
            this.setTitle("XML\u6587\u4ef6\u7f16\u8f91\u5668 [" + f.getName() + "]");
            this.m_saveBtn.setEnabled(true);
            this.m_saveAsBtn.setEnabled(true);
            this.m_isModified = false;
        }
        catch (Exception ex) {
            this.showError(ex, "\u65e0\u6548\u683c\u5f0f\u7684 XML \u6587\u4ef6\u3002");
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void saveXml(File f) {
        if (this.m_doc == null) {
            return;
        }
        if (f == null) {
            if (this.m_saver == null) {
                this.m_saver = new JFileChooser();
                this.m_saver.setDialogType(1);
                this.m_saver.setCurrentDirectory(new File("."));
                this.m_saver.setDialogTitle("\u53e6\u5b58\u4e3a\uff1a");
                this.m_saver.setFileSelectionMode(0);
            }
            if (this.m_saver.showOpenDialog(this) != 0) {
                return;
            }
            this.m_currentFile = f = this.m_saver.getSelectedFile();
            this.setTitle("XML\u6587\u4ef6\u7f16\u8f91\u5668 [" + f.getName() + "]");
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            FileWriter out = new FileWriter(f);
            XMLRoutines.write(this.m_doc, (Writer)out);
            out.close();
            this.m_isModified = false;
        }
        catch (Exception ex) {
            this.showError(ex, "\u4fdd\u5b58\u5931\u8d25\u3002");
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean canContinue() {
        if (!this.m_isModified) {
            return true;
        }
        int result = JOptionPane.showConfirmDialog(this, "\u8981\u4fdd\u5b58\u5f53\u524d\u7684\u6587\u4ef6\u5417 ?", APP_NAME, 1);
        switch (result) {
            case 0: {
                this.saveXml(this.m_currentFile);
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public boolean hasDocument() {
        return this.m_doc != null;
    }

    protected void enableNodeButtons() {
        boolean b1 = this.getSelectedNode() instanceof Element;
        boolean b2 = this.getSelectedNode() != null;
        this.m_addNodeBtn.setEnabled(b1);
        this.m_editNodeBtn.setEnabled(b2);
        this.m_delNodeBtn.setEnabled(b2);
    }

    protected void enableAttrButtons() {
        boolean b1 = this.m_tableModel.getNode() instanceof Element;
        boolean b2 = this.m_table.getSelectedRowCount() > 0;
        this.m_addAttrBtn.setEnabled(b1);
        this.m_editAttrBtn.setEnabled(b2);
        this.m_delAttrBtn.setEnabled(b2);
    }

    protected void addNewNode() {
        if (this.m_doc == null) {
            return;
        }
        XmlEditorNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        Node parent = treeNode.getXmlNode();
        if (parent == null) {
            return;
        }
        String input = (String)JOptionPane.showInputDialog(this, "\u8bf7\u8f93\u5165 XML \u5143\u7d20\u7684\u540d\u79f0", APP_NAME, -1, null, null, "");
        if (!this.isLegalXmlName(input)) {
            return;
        }
        try {
            Element newElement = this.m_doc.createElement(input);
            XmlEditorNode nodeElement = new XmlEditorNode(newElement);
            treeNode.addXmlNode(nodeElement);
            this.m_model.nodeStructureChanged(treeNode);
            TreePath path = this.m_tree.getSelectionPath();
            if (path != null) {
                path = path.pathByAddingChild(nodeElement);
                this.m_tree.setSelectionPath(path);
                this.m_tree.scrollPathToVisible(path);
            }
            this.m_isModified = true;
        }
        catch (Exception ex) {
            this.showError(ex, "\u6dfb\u52a0\u5143\u7d20\u51fa\u9519\u3002");
        }
    }

    protected void addNewAttribute() {
        Node node = this.m_tableModel.getNode();
        if (!(node instanceof Element)) {
            return;
        }
        String input = (String)JOptionPane.showInputDialog(this, "\u8bf7\u8f93\u5165\u5c5e\u6027\u7684\u540d\u79f0", APP_NAME, -1, null, null, "");
        if (!this.isLegalXmlName(input)) {
            return;
        }
        try {
            ((Element)node).setAttribute(input, "");
            this.setNodeToTable(node);
            int k = 0;
            while (k < this.m_tableModel.getRowCount()) {
                if (this.m_tableModel.getValueAt(k, 0).equals(input)) {
                    this.m_table.editCellAt(k, 1);
                    break;
                }
                ++k;
            }
            this.m_isModified = true;
        }
        catch (Exception ex) {
            this.showError(ex, "\u6dfb\u52a0\u5c5e\u6027\u51fa\u9519");
        }
    }

    protected void editNode() {
        TreePath path = this.m_tree.getSelectionPath();
        XmlEditorNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        Node node = treeNode.getXmlNode();
        if (node == null) {
            return;
        }
        try {
            switch (node.getNodeType()) {
                case 1: {
                    int k = 0;
                    while (k < treeNode.getChildCount()) {
                        XmlEditorNode childNode = (XmlEditorNode)treeNode.getChildAt(k);
                        Node nd = childNode.getXmlNode();
                        if (nd instanceof Text) {
                            path = path.pathByAddingChild(childNode);
                            this.m_tree.setSelectionPath(path);
                            this.m_tree.scrollPathToVisible(path);
                            this.m_tree.startEditingAtPath(path);
                            return;
                        }
                        ++k;
                    }
                    Text text = this.m_doc.createTextNode("");
                    XmlEditorNode nodeText = new XmlEditorNode(text);
                    treeNode.addXmlNode(nodeText);
                    this.m_model.nodeStructureChanged(treeNode);
                    path = path.pathByAddingChild(nodeText);
                    this.m_tree.setSelectionPath(path);
                    this.m_tree.scrollPathToVisible(path);
                    this.m_tree.startEditingAtPath(path);
                    return;
                }
                case 3: {
                    this.m_tree.startEditingAtPath(path);
                    return;
                }
            }
        }
        catch (Exception ex) {
            this.showError(ex, "\u7f16\u8f91\u5143\u7d20\u51fa\u9519\u3002");
        }
    }

    protected void editAttribute() {
        int row = this.m_table.getSelectedRow();
        if (row >= 0) {
            this.m_table.editCellAt(row, 1);
        }
    }

    protected void deleteNode() {
        TreePath path = this.m_tree.getSelectionPath();
        XmlEditorNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        Node node = treeNode.getXmlNode();
        if (node == null) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(this, "\u786e\u5b9e\u8981\u5220\u9664\u5143\u7d20 " + node.getNodeName() + " ?", APP_NAME, 0);
        if (result != 0) {
            return;
        }
        try {
            TreeNode treeParent = treeNode.getParent();
            treeNode.remove();
            this.m_model.nodeStructureChanged(treeParent);
            this.m_isModified = true;
        }
        catch (Exception ex) {
            this.showError(ex, "\u5220\u9664\u5143\u7d20\u51fa\u9519\u3002");
        }
    }

    protected void deleteAttribute() {
        int row = this.m_table.getSelectedRow();
        if (row < 0) {
            return;
        }
        Node node = this.getSelectedNode();
        if (!(node instanceof Element)) {
            return;
        }
        String name = (String)this.m_tableModel.getValueAt(row, 0);
        int result = JOptionPane.showConfirmDialog(this, "\u786e\u5b9e\u8981\u5220\u9664\u5c5e\u6027 " + name + " ?", APP_NAME, 0);
        if (result != 0) {
            return;
        }
        try {
            ((Element)node).removeAttribute(name);
            this.setNodeToTable(node);
            this.m_isModified = true;
        }
        catch (Exception ex) {
            this.showError(ex, "\u5220\u9664\u5143\u7d20\u51fa\u9519");
        }
    }

    protected DefaultMutableTreeNode createTreeNode(Node root) {
        if (!this.canDisplayNode(root)) {
            return null;
        }
        XmlEditorNode treeNode = new XmlEditorNode(root);
        NodeList list = root.getChildNodes();
        int k = 0;
        while (k < list.getLength()) {
            Node nd = list.item(k);
            DefaultMutableTreeNode child = this.createTreeNode(nd);
            if (child != null) {
                treeNode.add(child);
            }
            ++k;
        }
        return treeNode;
    }

    protected boolean canDisplayNode(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return true;
            }
            case 3: {
                String text = node.getNodeValue().trim();
                return !text.equals("") && !text.equals("\n") && !text.equals("\r\n");
            }
        }
        return false;
    }

    protected boolean dragNodeOverTree(int screenX, int screenY) {
        Point pt = this.m_treeScrollPane.getLocationOnScreen();
        int x = screenX - pt.x;
        int y = screenY - pt.y;
        if (!this.m_treeScrollPane.contains(x, y)) {
            JViewport viewPort = this.m_treeScrollPane.getViewport();
            int maxHeight = viewPort.getView().getHeight() - viewPort.getHeight();
            if (x > 0 && x < this.m_treeScrollPane.getWidth() && y < 0) {
                pt = viewPort.getViewPosition();
                pt.y -= 3;
                pt.y = Math.max(0, pt.y);
                pt.y = Math.min(maxHeight, pt.y);
                viewPort.setViewPosition(pt);
            }
            if (x > 0 && x < this.m_treeScrollPane.getWidth() && y > this.m_treeScrollPane.getHeight()) {
                pt = viewPort.getViewPosition();
                pt.y += 3;
                pt.y = Math.max(0, pt.y);
                pt.y = Math.min(maxHeight, pt.y);
                viewPort.setViewPosition(pt);
            }
            this.m_draggingOverNode = null;
            this.m_tree.repaint();
            return false;
        }
        pt = this.m_tree.getLocationOnScreen();
        x = screenX - pt.x;
        y = screenY - pt.y;
        TreePath path = this.m_tree.getPathForLocation(x, y);
        if (path == null) {
            this.m_draggingOverNode = null;
            this.m_tree.repaint();
            return false;
        }
        Object obj = path.getLastPathComponent();
        if (obj instanceof XmlEditorNode && ((XmlEditorNode)obj).getXmlNode() instanceof Element) {
            this.m_draggingOverNode = (XmlEditorNode)obj;
            this.m_tree.scrollPathToVisible(path);
            this.m_tree.repaint();
            return true;
        }
        this.m_draggingOverNode = null;
        this.m_tree.repaint();
        return false;
    }

    protected void moveNode(XmlEditorNode source, XmlEditorNode target) {
        if (source == null || target == null) {
            return;
        }
        if (XmlEditor.isChildNode(source, target)) {
            return;
        }
        try {
            TreeNode srcParent = source.getParent();
            source.remove();
            this.m_model.nodeStructureChanged(srcParent);
            target.addXmlNode(source);
            this.m_model.nodeStructureChanged(target);
            TreePath path = XmlEditor.getTreePathForNode(source);
            this.m_tree.setSelectionPath(path);
            this.m_tree.scrollPathToVisible(path);
            this.m_isModified = true;
        }
        catch (Exception ex) {
            this.showError(ex, "\u79fb\u52a8\u5143\u7d20\u51fa\u9519\u3002");
        }
    }

    public XmlEditorNode getSelectedTreeNode() {
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof XmlEditorNode)) {
            return null;
        }
        return (XmlEditorNode)obj;
    }

    public Node getSelectedNode() {
        XmlEditorNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return null;
        }
        return treeNode.getXmlNode();
    }

    public void setNodeToTable(Node node) {
        this.m_tableModel.setNode(node);
        this.m_table.tableChanged(new TableModelEvent(this.m_tableModel));
    }

    public boolean isLegalXmlName(String input) {
        if (input == null || input.length() == 0) {
            return false;
        }
        char ch = input.charAt(0);
        if (!XmlNames.isName((String)input)) {
            JOptionPane.showMessageDialog(this, "\u65e0\u6548\u7684 XML \u540d\u79f0", APP_NAME, 2);
            return false;
        }
        return true;
    }

    public void showError(Exception ex, String message) {
        ex.printStackTrace();
        JOptionPane.showMessageDialog(this, message, APP_NAME, 2);
    }

    public static void expandTree(JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        TreePath path = new TreePath(root);
        int k = 0;
        while (k < root.getChildCount()) {
            TreeNode child = root.getChildAt(k);
            XmlEditor.expandTree(tree, path, child);
            ++k;
        }
    }

    public static void expandTree(JTree tree, TreePath path, TreeNode node) {
        if (path == null || node == null) {
            return;
        }
        tree.expandPath(path);
        TreePath newPath = path.pathByAddingChild(node);
        int k = 0;
        while (k < node.getChildCount()) {
            TreeNode child = node.getChildAt(k);
            if (child != null) {
                XmlEditor.expandTree(tree, newPath, child);
            }
            ++k;
        }
    }

    public static TreePath getTreePathForNode(TreeNode node) {
        Vector<TreeNode> v = new Vector<TreeNode>();
        while (node != null) {
            v.insertElementAt(node, 0);
            node = node.getParent();
        }
        return new TreePath(v.toArray());
    }

    public static boolean isChildNode(TreeNode parent, TreeNode node) {
        if (parent == null || node == null) {
            return false;
        }
        if (parent.equals(node)) {
            return true;
        }
        int k = 0;
        while (k < parent.getChildCount()) {
            TreeNode child = parent.getChildAt(k);
            if (XmlEditor.isChildNode(child, node)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static void main(String[] argv) {
        new XmlEditor();
    }

    class XmlEditorListener
    implements CellEditorListener {
        XmlEditorListener() {
        }

        public void editingStopped(ChangeEvent e) {
            TreePath path;
            String value = XmlEditor.this.m_treeEditor.getCellEditorValue().toString();
            if (XmlEditor.this.m_editingNode != null) {
                XmlEditor.this.m_editingNode.setNodeValue(value);
            }
            if ((path = XmlEditor.this.m_tree.getSelectionPath()) != null) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                treeNode.setUserObject(XmlEditor.this.m_editingNode);
                XmlEditor.this.m_model.nodeStructureChanged(treeNode);
            }
            XmlEditor.this.m_isModified = true;
            XmlEditor.this.m_editingNode = null;
        }

        public void editingCanceled(ChangeEvent e) {
            XmlEditor.this.m_editingNode = null;
        }
    }

    class AttrTableModel
    extends AbstractTableModel {
        public static final int NAME_COLUMN = 0;
        public static final int VALUE_COLUMN = 1;
        protected Node m_node;
        protected NamedNodeMap m_attrs;

        AttrTableModel() {
        }

        public void setNode(Node node) {
            this.m_node = node;
            this.m_attrs = node == null ? null : node.getAttributes();
        }

        public Node getNode() {
            return this.m_node;
        }

        public int getRowCount() {
            if (this.m_attrs == null) {
                return 0;
            }
            return this.m_attrs.getLength();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int nCol) {
            return nCol == 0 ? "Attribute" : "Value";
        }

        public Object getValueAt(int nRow, int nCol) {
            if (this.m_attrs == null || nRow < 0 || nRow >= this.getRowCount()) {
                return "";
            }
            Attr attr = (Attr)this.m_attrs.item(nRow);
            if (attr == null) {
                return "";
            }
            switch (nCol) {
                case 0: {
                    return attr.getName();
                }
                case 1: {
                    return attr.getValue();
                }
            }
            return "";
        }

        public boolean isCellEditable(int nRow, int nCol) {
            return nCol == 1;
        }

        public void setValueAt(Object value, int nRow, int nCol) {
            if (nRow < 0 || nRow >= this.getRowCount()) {
                return;
            }
            if (!(this.m_node instanceof Element)) {
                return;
            }
            String name = this.getValueAt(nRow, 0).toString();
            ((Element)this.m_node).setAttribute(name, value.toString());
            XmlEditor.this.m_isModified = true;
        }
    }

    class TreeMouseListener
    extends MouseInputAdapter {
        private boolean m_isDragging = false;

        TreeMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            XmlEditorNode treeNode = XmlEditor.this.getSelectedTreeNode();
            if (treeNode != null && treeNode.getXmlNode() instanceof Element) {
                XmlEditor.this.m_draggingTreeNode = treeNode;
            }
            XmlEditor.this.m_draggingOverNode = null;
        }

        public void mouseReleased(MouseEvent evt) {
            if (XmlEditor.this.m_draggingTreeNode == null) {
                return;
            }
            XmlEditor.this.m_tree.setCursor(Cursor.getDefaultCursor());
            XmlEditor.this.moveNode(XmlEditor.this.m_draggingTreeNode, XmlEditor.this.m_draggingOverNode);
            this.m_isDragging = false;
            XmlEditor.this.m_draggingTreeNode = null;
            XmlEditor.this.m_draggingOverNode = null;
            XmlEditor.this.m_tree.repaint();
        }

        public void mouseDragged(MouseEvent evt) {
            int y;
            if (XmlEditor.this.m_draggingTreeNode == null) {
                return;
            }
            if (!this.m_isDragging) {
                this.m_isDragging = true;
                XmlEditor.this.m_tree.setCursor(XmlEditor.this.m_dragCursor);
            }
            Component src = (Component)evt.getSource();
            Point p1 = src.getLocationOnScreen();
            int x = p1.x + evt.getX();
            if (XmlEditor.this.dragNodeOverTree(x, y = p1.y + evt.getY())) {
                XmlEditor.this.m_tree.setCursor(XmlEditor.this.m_dragCursor);
            } else {
                XmlEditor.this.m_tree.setCursor(XmlEditor.this.m_nodropCursor);
            }
        }
    }
}

