/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.module;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Node;

class XmlEditorNode
extends DefaultMutableTreeNode {
    public XmlEditorNode(Node node) {
        super(node);
    }

    public Node getXmlNode() {
        Object obj = this.getUserObject();
        if (obj instanceof Node) {
            return (Node)obj;
        }
        return null;
    }

    public void addXmlNode(XmlEditorNode child) throws Exception {
        Node node = this.getXmlNode();
        if (node == null) {
            throw new Exception("Corrupted XML node");
        }
        node.appendChild(child.getXmlNode());
        this.add(child);
    }

    public void remove() throws Exception {
        Node node = this.getXmlNode();
        if (node == null) {
            throw new Exception("Corrupted XML node");
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            throw new Exception("Cannot remove root node");
        }
        TreeNode treeParent = this.getParent();
        if (!(treeParent instanceof DefaultMutableTreeNode)) {
            throw new Exception("Cannot remove tree node");
        }
        parent.removeChild(node);
        ((DefaultMutableTreeNode)treeParent).remove(this);
    }

    public String toString() {
        Node node = this.getXmlNode();
        if (node == null) {
            return this.getUserObject().toString();
        }
        StringBuffer sb = new StringBuffer();
        switch (node.getNodeType()) {
            case 1: {
                sb.append('<');
                sb.append(node.getNodeName());
                sb.append('>');
                break;
            }
            case 3: {
                sb.append(node.getNodeValue());
            }
        }
        return sb.toString();
    }
}

