/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.swing;

import com.runqian.base.swing.ColorComboBox;
import com.runqian.base.swing.ColorEditor;
import com.runqian.base.swing.JTableEx;
import com.runqian.base.tool.Constants;
import com.runqian.base.tool.Tools;
import com.runqian.base.util.PrinterCodeManager;
import com.runqian.report.cellset.CellPropertyDefine;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class EachRowEditor
implements TableCellEditor {
    int currentRow;
    public static final int COL_TXT = 0;
    public static final int COL_VAL = 1;
    public static final int COL_EXP = 2;
    public static final int COL_ID = 3;
    public static final int COL_EDT = 4;
    private TableCellEditor editor;
    private TableCellEditor defaultEditor;
    private JTableEx table;
    private DefaultCellEditor checkEditor;
    private DefaultCellEditor colorEditor;
    private DefaultCellEditor integerEditor;
    private DefaultCellEditor doubleEditor;
    private DefaultCellEditor reportType;
    private DefaultCellEditor pageSize;
    private DefaultCellEditor pageOrientation;
    private DefaultCellEditor rowType;
    private DefaultCellEditor colType;
    private DefaultCellEditor dataType;
    private DefaultCellEditor align;
    private DefaultCellEditor valign;
    private DefaultCellEditor extensible;
    private DefaultCellEditor textSize;
    private DefaultCellEditor textFace;
    private DefaultCellEditor leanLine;
    private DefaultCellEditor cellSizeUnit;
    private DefaultCellEditor pagerStyle;
    private DefaultCellEditor printLayoutIndex;
    private DefaultCellEditor scaledPrint;
    private DefaultCellEditor headerFooterSetup;
    private DefaultCellEditor cellAdjustSize;
    private DefaultCellEditor cellEditStyle;
    private DefaultCellEditor cellVirtualPrinter;
    private DefaultCellEditor cellInputDataType;

    public EachRowEditor(JTableEx table) {
        this.table = table;
        this.defaultEditor = Tools.getTextEditor(table);
        this.integerEditor = Tools.getTextEditor(table);
        this.doubleEditor = Tools.getTextEditor(table);
        JCheckBox checkBox = new JCheckBox();
        checkBox.setHorizontalAlignment(0);
        this.checkEditor = new DefaultCellEditor(checkBox);
        this.colorEditor = new ColorEditor((JComboBox)new ColorComboBox());
        JComboBox<Object> comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(1101, true));
        comboBox.setEnabled(false);
        this.reportType = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(4414, true));
        this.leanLine = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(1209, true));
        this.cellSizeUnit = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(1201, true));
        this.pageSize = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(1202, true));
        this.pageOrientation = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(3103, true));
        this.rowType = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(2102, true));
        this.colType = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(4101, true));
        comboBox.setEnabled(false);
        this.dataType = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(4201, true));
        this.align = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(4202, true));
        this.valign = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(4501, true));
        this.extensible = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(1210, true));
        this.pagerStyle = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(1214, true));
        this.printLayoutIndex = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(1217, true));
        this.scaledPrint = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(4109, true));
        this.cellAdjustSize = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(1215, true));
        this.headerFooterSetup = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(4805, true));
        this.cellEditStyle = new DefaultCellEditor(comboBox);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object[] fontNames = ge.getAvailableFontFamilyNames();
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, Tools.getVector(fontNames));
        this.textFace = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox<String>(Constants.fontSizeCode);
        this.textSize = new DefaultCellEditor(comboBox);
        comboBox = new JComboBox();
        Tools.setComboBoxData(comboBox, CellPropertyDefine.getValues(4810, true));
        this.cellInputDataType = new DefaultCellEditor(comboBox);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public Object getCellEditorValue() {
        Object value = this.editor.getCellEditorValue();
        try {
            if (this.editor == this.integerEditor) {
                return new Integer((String)value);
            }
            if (this.editor == this.doubleEditor) {
                return new Double((String)value);
            }
            return this.editor.getCellEditorValue();
        }
        catch (Exception e) {
            value = this.table.getModel().getValueAt(this.currentRow, 1);
            if (value instanceof Integer) {
                return value;
            }
            this.table.getModel().setValueAt("0", this.currentRow, 1);
            return new Integer(0);
        }
    }

    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    public boolean isCellEditable(EventObject anEvent) {
        this.selectEditor((MouseEvent)anEvent);
        return this.editor.isCellEditable(anEvent);
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.editor.addCellEditorListener(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.editor.removeCellEditorListener(l);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return this.editor.shouldSelectCell(anEvent);
    }

    protected void selectEditor(MouseEvent e) {
        this.currentRow = e == null ? this.table.getSelectionModel().getAnchorSelectionIndex() : this.table.rowAtPoint(e.getPoint());
        this.editor = null;
        int propertyName = 0;
        try {
            Object tmp = this.table.getModel().getValueAt(this.currentRow, 3);
            if (!(tmp instanceof Integer)) {
                return;
            }
            propertyName = (Integer)tmp;
        }
        catch (ArrayIndexOutOfBoundsException ee) {
            Tools.showException(ee);
        }
        switch (propertyName) {
            case 1101: {
                this.editor = this.reportType;
                break;
            }
            case 4414: {
                this.editor = this.leanLine;
                break;
            }
            case 1201: {
                this.editor = this.pageSize;
                break;
            }
            case 1202: {
                this.editor = this.pageOrientation;
                break;
            }
            case 3103: {
                this.editor = this.rowType;
                break;
            }
            case 2102: {
                this.editor = this.colType;
                break;
            }
            case 4101: {
                this.editor = this.dataType;
                break;
            }
            case 4201: {
                this.editor = this.align;
                break;
            }
            case 4202: {
                this.editor = this.valign;
                break;
            }
            case 4501: {
                this.editor = this.extensible;
                break;
            }
            case 4301: {
                this.editor = this.textFace;
                break;
            }
            case 4302: {
                this.editor = this.textSize;
                break;
            }
            case 4303: 
            case 4413: 
            case 4415: {
                this.editor = this.colorEditor;
                break;
            }
            case 1109: 
            case 1218: 
            case 2103: 
            case 3102: 
            case 3104: 
            case 4106: 
            case 4107: 
            case 4108: 
            case 4111: 
            case 4304: 
            case 4305: 
            case 4306: 
            case 4601: 
            case 4602: 
            case 4804: {
                this.editor = this.checkEditor;
                break;
            }
            case 1106: 
            case 1203: 
            case 1204: 
            case 1205: 
            case 1206: 
            case 1207: 
            case 1208: 
            case 1211: 
            case 1212: 
            case 1213: 
            case 4203: {
                this.editor = this.integerEditor;
                break;
            }
            case 2101: 
            case 3101: {
                this.editor = this.doubleEditor;
                break;
            }
            case 1209: {
                this.editor = this.cellSizeUnit;
                break;
            }
            case 1210: {
                this.editor = this.pagerStyle;
                break;
            }
            case 1215: {
                this.editor = this.headerFooterSetup;
                break;
            }
            case 4109: {
                this.editor = this.cellAdjustSize;
                break;
            }
            case 4805: {
                this.editor = this.cellEditStyle;
                break;
            }
            case 1214: {
                this.editor = this.printLayoutIndex;
                break;
            }
            case 4810: {
                this.editor = this.cellInputDataType;
                break;
            }
            case 1217: {
                this.editor = this.scaledPrint;
                break;
            }
            case 4110: {
                JComboBox<Object> comboBox;
                try {
                    PrinterCodeManager.reloadPrinterCode();
                    comboBox = new JComboBox<Object>(PrinterCodeManager.getPrinterNames().toArray());
                    comboBox.setEditable(true);
                }
                catch (Exception ex) {
                    comboBox = new JComboBox();
                    Tools.showException(ex);
                }
                this.cellVirtualPrinter = new DefaultCellEditor(comboBox);
                this.editor = this.cellVirtualPrinter;
                break;
            }
            default: {
                this.editor = this.defaultEditor;
            }
        }
    }
}

