/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.swing;

import com.runqian.base.swing.JListExHandler;
import com.runqian.base.util.ArgumentTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;

public class JListEx
extends JList {
    public DefaultListModel data = new DefaultListModel();
    private Vector codeData = new Vector();

    public JListEx() {
        super.setModel(this.data);
        this.setTransferHandler(new JListExHandler(this));
    }

    public JListEx(String items, char delim) {
        this();
        this.setListData(items, delim);
    }

    public JListEx(String items) {
        this();
        this.setListData(items, ',');
    }

    public JListEx(Object[] items) {
        this();
        this.setListData(items);
    }

    public JListEx(Vector items) {
        this();
        this.setListData(items);
    }

    public JListEx(DefaultListModel model) {
        this();
        if (model == null) {
            return;
        }
        this.setModel(model);
    }

    public boolean moveDropTarget(String moveData, JComponent dropedControl) {
        return false;
    }

    public void setListData(String items, char delim) {
        if (items == null) {
            return;
        }
        this.data.removeAllElements();
        if (items == null) {
            return;
        }
        ArgumentTokenizer at = new ArgumentTokenizer(items, delim);
        while (at.hasMoreTokens()) {
            this.data.addElement(at.nextToken());
        }
    }

    public void setListData(String items) {
        this.setListData(items, ',');
    }

    public void setListData(Object[] listData) {
        if (listData == null) {
            return;
        }
        int i = 0;
        while (i < listData.length) {
            this.data.addElement(listData[i]);
            ++i;
        }
    }

    public void setListData(Vector listData) {
        if (listData == null) {
            return;
        }
        this.setListData(listData.toArray());
    }

    public void setModel(DefaultListModel model) {
        if (model == null) {
            return;
        }
        this.data = model;
        super.setModel(model);
    }

    public void removeSelectedItems() {
        int[] iSelects = this.getSelectedIndices();
        int i = iSelects.length - 1;
        while (i >= 0) {
            this.data.removeElementAt(iSelects[i]);
            --i;
        }
    }

    public String totalItems() {
        if (this.data.getSize() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.data.getSize()) {
            sb.append(this.data.get(i) + ",");
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public String selectedItems() {
        StringBuffer sb = new StringBuffer();
        Object[] sItems = this.getSelectedValues();
        if (sItems.length == 0) {
            return "";
        }
        int i = 0;
        while (i < sItems.length) {
            sb.append(sItems[i] + ",");
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public boolean sort(boolean ascend) {
        int i = 0;
        while (i < this.data.size()) {
            if (!(this.data.get(i) instanceof Comparable)) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.data.size() - 1) {
            int j = i + 1;
            while (j < this.data.size()) {
                boolean lb_exchange;
                Comparable ci = (Comparable)this.data.get(i);
                Comparable cj = (Comparable)this.data.get(j);
                if (ascend) {
                    lb_exchange = ci.compareTo(cj) > 0;
                } else {
                    boolean bl = lb_exchange = ci.compareTo(cj) < 0;
                }
                if (lb_exchange) {
                    this.data.setElementAt(cj, i);
                    this.data.setElementAt(ci, j);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void x_setData(Vector codeData, Vector dispData) {
        this.data.removeAllElements();
        this.setListData(dispData);
        this.codeData.removeAllElements();
        this.codeData.addAll(codeData);
    }

    public boolean x_sort(boolean sortByDisp, boolean ascend) {
        int i;
        if (sortByDisp) {
            i = 0;
            while (i < this.data.size()) {
                if (!(this.data.get(i) instanceof Comparable)) {
                    return false;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.data.size()) {
                if (!(this.codeData.get(i) instanceof Comparable)) {
                    return false;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.data.size() - 1) {
            int j = i + 1;
            while (j < this.data.size()) {
                boolean lb_exchange;
                Comparable cj;
                Comparable ci;
                if (sortByDisp) {
                    ci = (Comparable)this.data.get(i);
                    cj = (Comparable)this.data.get(j);
                } else {
                    ci = (Comparable)this.codeData.get(i);
                    cj = (Comparable)this.codeData.get(j);
                }
                if (ascend) {
                    lb_exchange = ci.compareTo(cj) > 0;
                } else {
                    boolean bl = lb_exchange = ci.compareTo(cj) < 0;
                }
                if (lb_exchange) {
                    Object o = this.data.get(i);
                    Object o2 = this.data.get(j);
                    this.data.setElementAt(o2, i);
                    this.data.setElementAt(o, j);
                    o = this.codeData.get(i);
                    o2 = this.codeData.get(j);
                    this.codeData.setElementAt(o2, i);
                    this.codeData.setElementAt(o, j);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public String x_getCodeItem(String dispItem) {
        if (this.codeData == null || this.data == null) {
            return dispItem;
        }
        int i = 0;
        i = 0;
        while (i < this.data.size()) {
            String disp = (String)this.data.get(i);
            if (disp.equalsIgnoreCase(dispItem)) break;
            ++i;
        }
        if (i >= this.codeData.size()) {
            return dispItem;
        }
        return (String)this.codeData.get(i);
    }

    public String x_getDispItem(String codeItem) {
        if (this.codeData == null || this.data == null) {
            return codeItem;
        }
        int i = 0;
        i = 0;
        while (i < this.codeData.size()) {
            String code = (String)this.codeData.get(i);
            if (code.equalsIgnoreCase(codeItem)) break;
            ++i;
        }
        if (i >= this.data.size()) {
            return codeItem;
        }
        return (String)this.data.get(i);
    }

    public String x_SelectedItems() {
        StringBuffer sb = new StringBuffer();
        Object[] sItems = this.getSelectedValues();
        if (sItems.length == 0) {
            return "";
        }
        int i = 0;
        while (i < sItems.length) {
            sb.append(String.valueOf(this.x_getCodeItem((String)sItems[i])) + ",");
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public void x_setModel(Vector codeData, DefaultListModel dispModel) {
        this.data = dispModel;
        super.setModel(dispModel);
        this.codeData = codeData;
    }

    public void x_removeAllElements() {
        this.data.removeAllElements();
        this.codeData.removeAllElements();
    }

    public void x_removeElement(int i) {
        this.data.removeElementAt(i);
        this.codeData.removeElementAt(i);
    }

    public void x_removeSelectedItems() {
        int[] ii = this.getSelectedIndices();
        int i = ii.length - 1;
        while (i > 0) {
            this.x_removeElement(i);
            --i;
        }
    }

    public Object[] x_getSelectedValues() {
        Object[] d = this.getSelectedValues();
        Object[] c = new String[d.length];
        int i = 0;
        while (i < d.length) {
            c[i] = this.x_getCodeItem((String)d[i]);
            ++i;
        }
        return c;
    }

    public void x_addElement(String code, String disp) {
        this.codeData.addElement(code);
        this.data.addElement(disp);
    }

    public String x_totalItems() {
        if (this.codeData.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.codeData.size()) {
            sb.append(String.valueOf((String)this.codeData.get(i)) + ",");
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

