/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.swing;

import com.runqian.base.swing.JListEx;
import com.runqian.base.tool.Section;
import com.runqian.base.tool.Tools;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;

class JListExHandler
extends TransferHandler {
    JListEx home;

    public JListExHandler(JListEx home) {
        this.home = home;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return c instanceof JListEx || c instanceof JTextArea || c instanceof JList || c instanceof JTextPane;
    }

    public boolean importData(JComponent c, Transferable t) {
        try {
            String items = (String)t.getTransferData(DataFlavor.stringFlavor);
            if (this.home.moveDropTarget(items, c)) {
                return true;
            }
            Section sItems = new Section(items);
            if (c instanceof JListEx) {
                JListEx tList = (JListEx)c;
                int i = 0;
                while (i < sItems.size()) {
                    if (Tools.getItemIndex(tList.data, sItems.get(i)) == -1) {
                        tList.data.addElement(sItems.get(i));
                    }
                    ++i;
                }
            } else if (c instanceof JList) {
                JList list = (JList)c;
                DefaultListModel lm = (DefaultListModel)list.getModel();
                int i = 0;
                while (i < sItems.size()) {
                    if (Tools.getItemIndex(lm, sItems.get(i)) == -1) {
                        lm.addElement(sItems.get(i));
                    }
                    ++i;
                }
            } else if (c instanceof JTextArea) {
                JTextArea tta = (JTextArea)c;
                tta.setText(String.valueOf(tta.getText()) + " " + items);
            } else if (c instanceof JTextPane) {
                JTextPane ttp = (JTextPane)c;
                ttp.setText(String.valueOf(ttp.getText()) + " " + items);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception x) {
            Tools.showException(x);
            return false;
        }
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    public int getSourceActions(JComponent c) {
        return 3;
    }

    protected Transferable createTransferable(JComponent c) {
        JListEx list = (JListEx)c;
        Object[] items = list.getSelectedValues();
        Section sItems = new Section(items);
        return new StringSelection(sItems.toString());
    }
}

