/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.swing;

import com.runqian.base.swing.JTableExListener;
import com.runqian.base.tool.Section;
import com.runqian.base.util.Sentence;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTableEx
extends JTable
implements MouseListener,
JTableExListener {
    public DefaultTableModel data = new DefaultTableModel();
    private HashMap columnKeeper = new HashMap();
    private boolean ifFireRowfocusChangedEvent = true;
    public HashSet clickedListener = new HashSet();
    public static int ALIGN_LEFT = 2;
    public static int ALIGN_CENTER = 0;
    public static int ALIGN_RIGHT = 4;
    private int o = -1;
    private int n;

    public void rightClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
    }

    public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
    }

    public void clicked(int xpos, int ypos, int row, int col, MouseEvent e) {
    }

    public void rowfocusChanged(int oldRow, int newRow) {
    }

    public void mouseClicked(MouseEvent e) {
        Container p = this.getParent();
        Container ct = this.getTopLevelAncestor();
        int absoluteX = e.getX();
        int absoluteY = e.getY();
        while (p != ct) {
            absoluteX += p.getX();
            absoluteY += p.getY();
            p = p.getParent();
        }
        this.fireClicked(absoluteX, absoluteY, e);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public JTableEx() {
        this.setModel(this.data);
        this.addTableExListener(this);
    }

    public JTableEx(String columnNames) {
        this();
        this.addMouseListener(this);
        Section sTmp = new Section(columnNames);
        int i = 0;
        while (i < sTmp.size()) {
            this.addColumn(sTmp.getSection(i));
            ++i;
        }
        this.holdColumnNames();
    }

    void holdColumnNames() {
        if (this.columnKeeper == null) {
            return;
        }
        this.columnKeeper.clear();
        TableColumnModel cm = this.getColumnModel();
        Enumeration<TableColumn> cols = cm.getColumns();
        while (cols.hasMoreElements()) {
            TableColumn tmpCol = cols.nextElement();
            tmpCol.setCellEditor(new SimpleEditor(new JTextField(), this));
            Object tmpName = tmpCol.getIdentifier();
            this.columnKeeper.put(tmpName, tmpCol);
        }
    }

    public boolean exportData(boolean exportTitle, FileWriter fw, boolean dosFormat) throws Exception {
        int c;
        String sRow = "";
        String sTmp = "";
        int cc = this.getColumnCount();
        int rc = this.getRowCount();
        String rowSep = dosFormat ? "\r\n" : "\r";
        if (exportTitle) {
            if (cc == 0) {
                return false;
            }
            c = 0;
            while (c < cc) {
                sTmp = String.valueOf(sTmp) + "\t" + this.getColumnName(c);
                ++c;
            }
            sRow = String.valueOf(rowSep) + sTmp.substring(1);
        }
        int r = 0;
        while (r < rc) {
            sTmp = "";
            c = 0;
            while (c < cc) {
                sTmp = String.valueOf(sTmp) + "\t" + this.data.getValueAt(r, c);
                ++c;
            }
            sRow = String.valueOf(sRow) + rowSep + sTmp.substring(1);
            ++r;
        }
        fw.write(sRow.substring(rowSep.length()));
        return true;
    }

    public void setModel(TableModel dataModel) {
        this.data = (DefaultTableModel)dataModel;
        super.setModel(this.data);
        this.holdColumnNames();
    }

    public void resetColumns(ArrayList newColNames) {
        this.data.setColumnCount(0);
        int i = 0;
        while (i < newColNames.size()) {
            this.data.addColumn(newColNames.get(i));
            ++i;
        }
        this.holdColumnNames();
    }

    public void acceptText() {
        if (this.getCellEditor() != null && this.getRowCount() > 0) {
            int r = this.getSelectedRow();
            int c = this.getRowCount();
            int e = this.getEditingRow();
            if (e >= c) {
                return;
            }
            this.getCellEditor().stopCellEditing();
        }
    }

    public void addTableExListener(JTableExListener jcl) {
        this.clickedListener.add(jcl);
    }

    public void removeClickedListener(JTableExListener jcl) {
        this.clickedListener.remove(jcl);
    }

    public void fireClicked(int xpos, int ypos, MouseEvent e) {
        Iterator it = this.clickedListener.iterator();
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1) {
            row = this.rowAtPoint(new Point(e.getX(), e.getY()));
        }
        if (col == -1) {
            col = this.columnAtPoint(new Point(e.getX(), e.getY()));
        }
        while (it.hasNext()) {
            JTableExListener lis = (JTableExListener)it.next();
            if (e.getButton() == 3) {
                lis.rightClicked(xpos, ypos, row, col, e);
                continue;
            }
            if (e.getButton() != 1) continue;
            switch (e.getClickCount()) {
                case 1: {
                    lis.clicked(xpos, ypos, row, col, e);
                    break;
                }
                case 2: {
                    lis.doubleClicked(xpos, ypos, row, col, e);
                    break;
                }
            }
        }
    }

    public void addColumn(String colName) {
        this.data.addColumn(colName);
    }

    public void deleteColumn(TableColumn aColumn) {
        String colName = (String)aColumn.getIdentifier();
        int cc = this.data.getColumnCount();
        DefaultTableModel dataModel = new DefaultTableModel();
        int i = 0;
        while (i < cc) {
            String tmpName = this.data.getColumnName(i);
            if (!tmpName.equalsIgnoreCase(colName)) {
                Vector cData = this.getColumnData(i);
                dataModel.addColumn((Object)tmpName, cData);
            }
            ++i;
        }
        this.setModel(dataModel);
    }

    public Vector getColumnData(int colIndex) {
        Vector<Object> cData = new Vector<Object>();
        int r = 0;
        while (r < this.data.getRowCount()) {
            cData.add(this.data.getValueAt(r, colIndex));
            ++r;
        }
        return cData;
    }

    public void hideColumn(String columnName) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        Object id = col.getIdentifier();
        this.columnKeeper.put(id, col);
        this.removeColumn(col);
    }

    public void setColumnEnable(String columnName, boolean enable) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        JTextField jtf = new JTextField();
        if (enable) {
            col.setCellEditor(new DefaultCellEditor(jtf));
            DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
            col.setCellRenderer(dtcr);
        } else {
            col.setCellEditor(new DisabledEditor(jtf));
            DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
            dtcr.setHorizontalAlignment(0);
            dtcr.setBackground(Color.LIGHT_GRAY);
            col.setCellRenderer(dtcr);
        }
    }

    public void setColumnEditable(String columnName, boolean ifEdit) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        JTextField jtf = new JTextField();
        jtf.setEditable(ifEdit);
        col.setCellEditor(new DefaultCellEditor(jtf));
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        col.setCellRenderer(dtcr);
    }

    public void setColumnWidth(String columnName, int width) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        col.setPreferredWidth(width);
    }

    public void setColumnAlign(String columnName, int alignment) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        DefaultTableCellRenderer cbRender = new DefaultTableCellRenderer();
        cbRender.setHorizontalAlignment(alignment);
        col.setCellRenderer(cbRender);
    }

    public String getRowData(int row) {
        if (row < 0) {
            return "";
        }
        int rowCount = this.data.getRowCount();
        if (row >= rowCount) {
            return "";
        }
        int colCount = this.data.getColumnCount();
        StringBuffer rowData = new StringBuffer(1024);
        int i = 0;
        while (i < colCount) {
            Object item = this.data.getValueAt(row, i);
            rowData.append(item.toString());
            if (i < colCount - 1) {
                rowData.append("\t");
            }
            ++i;
        }
        return rowData.toString();
    }

    public String getBlockData() {
        StringBuffer sb = new StringBuffer(1024);
        this.acceptText();
        int cr = -1;
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.isRowSelected(i)) {
                String row = this.getRowData(i);
                sb.append(row);
                if (i < this.getRowCount() - 1) {
                    sb.append("\n");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public int setBlockData(String ls_data) {
        int r = 0;
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row < 0) {
            row = this.getRowCount() + 1;
        }
        if (col < 0) {
            col = 0;
        }
        ls_data = Sentence.replace(ls_data, "\r\n", "\r", 1);
        ls_data = Sentence.replace(ls_data, "\n", "\r", 1);
        StringTokenizer rows = new StringTokenizer(ls_data, "\r");
        while (rows.hasMoreTokens()) {
            if (row >= this.getRowCount()) {
                row = this.addRow();
            }
            String ls_row = rows.nextToken();
            int li_col = col;
            StringTokenizer items = new StringTokenizer(ls_row, "\t");
            while (items.hasMoreTokens()) {
                String item = items.nextToken();
                this.data.setValueAt(item, row, li_col);
                ++li_col;
            }
            ++row;
            ++r;
        }
        return r;
    }

    public void showColumn(String columnName) {
        if (this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = (TableColumn)this.columnKeeper.get(columnName);
        if (col == null) {
            return;
        }
        this.addColumn(col);
    }

    public void deleteSelectedRows() {
        this.acceptText();
        this.removeCurrentRow();
        int r = this.getRowCount() - 1;
        this.clearSelection();
        this.o = -1;
        this.selectRow(r);
    }

    public int removeCurrentRow() {
        this.acceptText();
        int cr = -1;
        int i = this.getRowCount();
        while (i >= 0) {
            if (this.isRowSelected(i)) {
                this.data.removeRow(i);
            }
            --i;
        }
        return cr;
    }

    public int removeRow(int row) {
        if (row < 0) {
            return -1;
        }
        int c = this.data.getRowCount();
        if (row >= c) {
            return -1;
        }
        this.data.removeRow(row);
        int t = this.getRowCount();
        if (t == row) {
            --row;
        }
        this.selectRow(row);
        this.setEditingRow(row);
        return row;
    }

    public void selectRow(int row) {
        if (row < 0) {
            return;
        }
        DefaultListSelectionModel selectModel = new DefaultListSelectionModel();
        selectModel.addSelectionInterval(row, row);
        this.setSelectionModel(selectModel);
        this.setEditingRow(row);
        int n = row;
        if (n == this.o) {
            return;
        }
        this.fireRowfocusChanged(this.o, row);
        this.o = n;
    }

    public int addRow(Vector v) {
        this.acceptText();
        this.data.addRow(v);
        int r = this.data.getRowCount() - 1;
        this.setEditingRow(r);
        this.selectRow(r);
        return r;
    }

    public int addRow(Object[] oa) {
        this.acceptText();
        this.data.addRow(oa);
        int r = this.data.getRowCount() - 1;
        this.setEditingRow(r);
        this.selectRow(r);
        return r;
    }

    public int addRow() {
        return this.addRow(new Vector());
    }

    public boolean isColumnVisible(Object column) {
        TableColumnModel cm = this.getColumnModel();
        int i = 0;
        while (i < cm.getColumnCount()) {
            TableColumn tc = cm.getColumn(i);
            if (tc.getIdentifier().equals(column)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void fireRowfocusChanged(int oldRow, int newRow) {
        if (!this.ifFireRowfocusChangedEvent) {
            return;
        }
        Iterator it = this.clickedListener.iterator();
        while (it.hasNext()) {
            JTableExListener lis = (JTableExListener)it.next();
            lis.rowfocusChanged(oldRow, newRow);
        }
        this.resizeAndRepaint();
    }

    public void disableRowfocusChanged() {
        this.ifFireRowfocusChangedEvent = false;
    }

    public void enableRowfocusChanged() {
        this.ifFireRowfocusChangedEvent = true;
    }

    public void valueChanged(ListSelectionEvent e) {
        int r = this.getSelectedRow();
        if (r < 0) {
            return;
        }
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.n = r;
        if (this.n == this.o) {
            return;
        }
        this.fireRowfocusChanged(this.o, r);
        this.o = this.n;
    }

    class DisabledEditor
    extends DefaultCellEditor {
        public DisabledEditor(JTextField jTxt) {
            super(jTxt);
            jTxt.setBackground(Color.GRAY);
            jTxt.setEditable(false);
            jTxt.setHorizontalAlignment(0);
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }
    }

    class SimpleEditor
    extends DefaultCellEditor
    implements MouseListener {
        JTableEx parent;

        public SimpleEditor(JTextField tf, JTableEx parent) {
            super(tf);
            tf.addMouseListener(this);
            tf.setBorder(BorderFactory.createEmptyBorder());
            this.parent = parent;
            this.setClickCountToStart(1);
        }

        public void mouseClicked(MouseEvent e) {
            JComponent editor = (JComponent)e.getSource();
            Container ct = editor.getTopLevelAncestor();
            int absoluteX = e.getX() + editor.getX();
            int absoluteY = e.getY() + editor.getY();
            Container p = editor.getParent();
            while (p != ct) {
                absoluteX += p.getX();
                absoluteY += p.getY();
                p = p.getParent();
            }
            this.parent.fireClicked(absoluteX, absoluteY, e);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

