/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.swing;

import com.runqian.base.swing.JTableEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class JTextAreaEditor
extends DefaultCellEditor
implements MouseListener {
    JScrollPane jsp;
    JTableEx parent;
    boolean ifSimple;
    JTextField simpleEditor = null;
    JTextPane tp = null;

    public JTextAreaEditor(JTableEx parent, boolean ifSimple) {
        super(new JTextField(""));
        this.ifSimple = ifSimple;
        this.parent = parent;
        if (ifSimple) {
            this.simpleEditor = new JTextField("");
            this.simpleEditor.addMouseListener(this);
            this.simpleEditor.setBorder(BorderFactory.createEmptyBorder());
        } else {
            this.tp = new JTextPane();
            this.tp.addMouseListener(this);
            this.jsp = new JScrollPane(this.tp);
        }
        this.setClickCountToStart(1);
    }

    public Object getCellEditorValue() {
        if (this.ifSimple) {
            return this.simpleEditor.getText();
        }
        return this.tp.getText();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.ifSimple) {
            if (value == null) {
                this.simpleEditor.setText("");
            } else {
                this.simpleEditor.setText(value.toString());
            }
            return this.simpleEditor;
        }
        if (value == null) {
            this.tp.setText("");
        } else {
            this.tp.setText(value.toString());
        }
        return this.jsp;
    }

    public void mouseClicked(MouseEvent e) {
        JComponent editor = (JComponent)e.getSource();
        Container ct = editor.getTopLevelAncestor();
        int absoluteX = e.getX() + editor.getX();
        int absoluteY = e.getY() + editor.getY();
        Container p = editor.getParent();
        while (p != ct) {
            absoluteX += p.getX();
            absoluteY += p.getY();
            p = p.getParent();
        }
        this.parent.fireClicked(absoluteX, absoluteY, e);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

