/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.tool;

import com.runqian.base.tool.Constants;
import com.runqian.base.tool.Section;
import com.runqian.base.tool.Tools;
import com.runqian.base.tool.XMLFile;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class AppTools {
    public static final String CONFIG_FILENAME = "runqianreportconfig.xml";
    public static final String CONFIG_FILE = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "runqianreportconfig.xml";
    public static final String CONFIG_FILE_DATASOURCES = "RUNQIAN/DATASOURCES";
    public static final String CONFIG_FILE_TABLES = "RUNQIAN/TABLES";
    public static final String CONFIG_FILE_OPTION = "RUNQIAN/OPTION";
    public static final String CONFIG_FILE_DBEXPLORER = "RUNQIAN/DBEXPLORER";
    static final short MENU_BYNAME = 0;
    static final short MENU_BYTEXT = 1;
    static final short MENU_BYLABLE = 1;
    static JFrame mainFrame = null;
    static String logFile = null;
    static Connection ct = null;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static Object extractMenuObject(Object menu, String str, short type) {
        Accessible tmpItem;
        Accessible sItem;
        int i;
        int c;
        Accessible pMenu;
        String sTmp = "";
        if (menu instanceof Menu) {
            pMenu = (Menu)menu;
            c = ((Menu)pMenu).getItemCount();
            i = 0;
            while (i < c) {
                sItem = ((Menu)pMenu).getItem(i);
                if (sItem != null) {
                    if (sItem instanceof Menu && (tmpItem = (MenuItem)AppTools.extractMenuObject(sItem, str, type)) != null) {
                        return tmpItem;
                    }
                    if (type == 0) {
                        sTmp = ((MenuComponent)((Object)sItem)).getName();
                    } else if (type == 1) {
                        sTmp = ((MenuItem)sItem).getLabel();
                    }
                    if (sTmp != null && sTmp.equalsIgnoreCase(str)) {
                        return sItem;
                    }
                }
                ++i;
            }
        }
        if (menu instanceof JMenu) {
            pMenu = (JMenu)menu;
            c = ((JMenu)pMenu).getItemCount();
            i = 0;
            while (i < c) {
                sItem = ((JMenu)pMenu).getItem(i);
                if (sItem != null) {
                    if (sItem instanceof JMenu && (tmpItem = (JMenuItem)AppTools.extractMenuObject(sItem, str, type)) != null) {
                        return tmpItem;
                    }
                    if (type == 0) {
                        sTmp = ((Component)((Object)sItem)).getName();
                    } else if (type == 1) {
                        sTmp = ((AbstractButton)((Object)sItem)).getText();
                    }
                    if (sTmp != null && sTmp.equalsIgnoreCase(str)) {
                        return sItem;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static Vector listColumns(ResultSet rs, boolean ifName, String tables) throws SQLException {
        return AppTools.listColumns(rs.getMetaData(), ifName, tables);
    }

    public static Vector listColumns(ResultSetMetaData rsmd, boolean ifName, String tables) throws SQLException {
        Vector<String> v = new Vector<String>();
        int i = 1;
        while (i <= rsmd.getColumnCount()) {
            String s;
            if (ifName) {
                s = rsmd.getColumnName(i);
                if (!Tools.isValidString(s)) {
                    s = "#" + i;
                }
            } else {
                s = tables == null ? rsmd.getColumnLabel(i) : (!Tools.isValidString(s = rsmd.getColumnName(i)) ? "\u8ba1\u7b97\u5217" + i : AppTools.getFieldTitle(tables, s));
            }
            v.add(s);
            ++i;
        }
        return v;
    }

    public static Section listRegistTables() {
        Section ss = new Section();
        try {
            XMLFile file = new XMLFile(CONFIG_FILE);
            String p = CONFIG_FILE_TABLES;
            if (!file.isPathExists(p)) {
                return ss;
            }
            ss = file.listElement(p);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ss;
    }

    public static Section listRegistColumns(String table) {
        Section ss = new Section();
        try {
            XMLFile file = new XMLFile(CONFIG_FILE);
            String p = "RUNQIAN/TABLES/" + table;
            if (!file.isPathExists(p)) {
                return ss;
            }
            ss = file.listElement(p);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ss;
    }

    public static Vector listColumns(ResultSet rs, boolean ifName) throws SQLException {
        return AppTools.listColumns(rs.getMetaData(), ifName, null);
    }

    public static Vector listColumns(ResultSetMetaData rsmd, boolean ifName) throws SQLException {
        return AppTools.listColumns(rsmd, ifName, null);
    }

    private static String getLogFile() {
        return Constants.LOGFILE;
    }

    public static Vector getTableTitle(XMLFile file, Vector tables) {
        Vector<String> v = new Vector<String>();
        try {
            if (file == null) {
                file = new XMLFile(CONFIG_FILE);
            }
            int i = 0;
            while (i < tables.size()) {
                String item = (String)tables.get(i);
                String text = file.getAttribute("RUNQIAN/TABLES/" + item + "/text");
                if (!Tools.isValidString(text)) {
                    text = item;
                }
                v.addElement(text);
                ++i;
            }
            return v;
        }
        catch (Throwable e) {
            return tables;
        }
    }

    public static Vector getFieldTitle(XMLFile file, String table, Vector fields, boolean noTitleIsEmpty) {
        Vector<String> v = new Vector<String>();
        try {
            if (file == null) {
                file = new XMLFile(CONFIG_FILE);
            }
            int i = 0;
            while (i < fields.size()) {
                String item = (String)fields.get(i);
                String text = file.getAttribute("RUNQIAN/TABLES/" + table + "/" + item + "/text");
                if (!Tools.isValidString(text)) {
                    text = noTitleIsEmpty ? "" : item;
                }
                v.addElement(text);
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return v;
    }

    public static String getFieldTitle(String tables, String field) {
        return AppTools.getFieldTitle(null, tables, field, false);
    }

    public static String getFieldAppr(String tables, String field) {
        String appr = "";
        StringTokenizer st = new StringTokenizer(tables, ",");
        try {
            XMLFile file = new XMLFile(CONFIG_FILE);
            while (st.hasMoreTokens()) {
                String table = st.nextToken();
                appr = file.getAttribute("RUNQIAN/TABLES/" + table + "/" + field + "/appr");
                if (!Tools.isValidString(appr)) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return appr;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFieldTitle(XMLFile file, String tables, String field, boolean noTitleIsEmpty) {
        String text = "";
        StringTokenizer st = new StringTokenizer(tables, ",");
        try {
            try {
                String table;
                if (file == null) {
                    file = new XMLFile(CONFIG_FILE);
                }
                while (st.hasMoreTokens() && !Tools.isValidString(text = file.getAttribute("RUNQIAN/TABLES/" + (table = st.nextToken()) + "/" + field + "/text"))) {
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (Tools.isValidString(text)) {
                return text;
            }
            if (noTitleIsEmpty) {
                text = "";
                throw throwable;
            }
            text = field;
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        if (Tools.isValidString(text)) {
            return text;
        }
        if (!noTitleIsEmpty) return field;
        return "";
    }

    public static void loadTmpDirectory() {
        try {
            File f = new File(CONFIG_FILE);
            if (!f.isFile()) {
                return;
            }
            XMLFile file = new XMLFile(CONFIG_FILE);
            String value = file.getAttribute("RUNQIAN/OTHER/fileDirectory");
            if (Tools.isValidString(value)) {
                Tools.tmpDirectory = value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void saveTmpDirectory() {
        try {
            File f = new File(CONFIG_FILE);
            if (!f.isFile()) {
                return;
            }
            XMLFile file = new XMLFile(CONFIG_FILE);
            if (!file.isPathExists("RUNQIAN/OTHER")) {
                file.newElement("RUNQIAN", "OTHER");
            }
            file.setAttribute("RUNQIAN/OTHER/fileDirectory", Tools.tmpDirectory);
            file.setAttribute("RUNQIAN/OTHER/ActivateOpenFile", "");
            file.save();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        try {
            String testFile = "  ";
            System.out.println(Tools.isValidString(testFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

