/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.tool;

import com.runqian.base.tool.Tools;
import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.Escape;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Section {
    public static final short POS_UP = 1;
    public static final short POS_DOWN = 2;
    public static final short POS_TOP = 3;
    public static final short POS_BOTTOM = 4;
    public Vector sections = new Vector();
    private boolean allowSame = false;

    public Section() {
        this(false);
    }

    public Section(boolean allowSameSection) {
        this.allowSame = allowSameSection;
    }

    public Section(Vector items) {
        this(items, false);
    }

    public Section(Vector items, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        this.sections = (Vector)items.clone();
    }

    public Section(Set items) {
        this(items, false);
    }

    public Section(Set items, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        Iterator all = items.iterator();
        while (all.hasNext()) {
            this.sections.add(all.next());
        }
    }

    public Section(Object[] items) {
        this(items, false);
    }

    public Section(Object[] items, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            this.sections.add(items[i]);
            ++i;
        }
    }

    public Section(String items) {
        this(items, false);
    }

    public Section(String items, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        this.unionSection(items);
    }

    public Section(String items, char delim) {
        this(items, delim, false);
    }

    public Section(String items, char delim, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        this.unionSection(items, delim);
    }

    public void unionSection(String items) {
        this.unionSection(items, ',');
    }

    public void unionSection(String items, char delim) {
        if (items == null) {
            return;
        }
        ArgumentTokenizer st = new ArgumentTokenizer(items, delim);
        while (st.hasMoreTokens()) {
            String s = Escape.removeEscAndQuote(st.nextToken());
            this.addSection(s);
        }
    }

    public void addSection(String item) {
        if (!Tools.isValidString(item)) {
            return;
        }
        if (this.allowSame || !this.sections.contains(item)) {
            this.sections.add(item);
        }
    }

    public void removeSection(String items) {
        if (items == null) {
            return;
        }
        ArgumentTokenizer st = new ArgumentTokenizer(items, ',');
        while (st.hasMoreTokens()) {
            this.sections.remove(st.nextToken());
        }
    }

    public void unionSection(Section items) {
        this.unionSection(items.toString());
    }

    public String toSectionString() {
        StringBuffer buf = new StringBuffer(1024);
        int i = 0;
        while (i < this.sections.size()) {
            buf.append(',');
            buf.append(Escape.addEscAndQuote((String)this.sections.get(i)));
            ++i;
        }
        if (buf.length() == 0) {
            return "";
        }
        return buf.substring(1);
    }

    public String toString() {
        return this.toString(',');
    }

    public String toString(char delim) {
        StringBuffer buf = new StringBuffer(1024);
        int i = 0;
        while (i < this.sections.size()) {
            buf.append(delim);
            buf.append(this.sections.get(i));
            ++i;
        }
        if (buf.length() == 0) {
            return "";
        }
        return buf.substring(1);
    }

    public String getSection(int i) {
        if (this.sections.size() == 0) {
            return "";
        }
        if (i < 0 || i > this.sections.size()) {
            return "";
        }
        return this.sections.get(i).toString();
    }

    public String get(int i) {
        return this.getSection(i);
    }

    public int indexOf(String section) {
        return this.sections.indexOf(section);
    }

    public Section extractSubSection(int[] indexes) {
        Section sRtn = new Section();
        int i = 0;
        while (i < indexes.length) {
            if (indexes[i] < this.sections.size()) {
                sRtn.unionSection((String)this.sections.get(indexes[i]));
            }
            ++i;
        }
        return sRtn;
    }

    public void replaceSection(int index, String newItem) {
    }

    public int rePositionSection(int index, short posCMD) {
        return 1;
    }

    public boolean containsSection(String item) {
        return this.sections.contains(item);
    }

    public int countSection() {
        return this.sections.size();
    }

    public int size() {
        return this.sections.size();
    }

    public int clear() {
        this.sections.clear();
        return 1;
    }

    public Vector toVector() {
        return this.sections;
    }

    public String[] toStringArray() {
        Object[] oa = this.sections.toArray();
        String[] sa = new String[oa.length];
        int i = 0;
        while (i < oa.length) {
            sa[i] = (String)oa[i];
            ++i;
        }
        return sa;
    }
}

