/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.tool;

import com.runqian.base.util.Escape;
import com.runqian.base.util.SegmentSet;
import java.util.Iterator;
import java.util.Set;

public class Segment {
    public SegmentSet ss = new SegmentSet();

    public Segment() {
        this("");
    }

    public Segment(String str) {
        this.ss = new SegmentSet(str);
    }

    public String put(String key, String val) {
        return this.ss.put(key, Escape.addEscAndQuote(val, true, "()[]{}", '\\'));
    }

    public String remove(String key) {
        return this.ss.remove(key);
    }

    public String get(String key) {
        String tmp = this.ss.get(key);
        return Escape.removeEscAndQuote(tmp);
    }

    public void union(Segment other) {
        Iterator otherKeys = other.keySet().iterator();
        while (otherKeys.hasNext()) {
            String key = otherKeys.next().toString();
            String val = other.get(key);
            this.put(key, val);
        }
    }

    public Set keySet() {
        return this.ss.keySet();
    }

    public String toString() {
        return this.ss.toString();
    }

    public static void main(String[] args) {
        Segment st = new Segment();
        st.put("a", "1(");
        st.put("b", "");
        st.put("c", "3]");
        Iterator it = st.ss.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            System.out.println(key);
            System.out.println(st.get(key));
        }
    }
}

