/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.tool;

import com.runqian.base.swing.JComboBoxEx;
import com.runqian.base.swing.JListEx;
import com.runqian.base.swing.JTableEx;
import com.runqian.base.swing.JTextAreaEditor;
import com.runqian.base.tool.Constants;
import com.runqian.base.tool.DialogInputText;
import com.runqian.base.tool.Section;
import com.runqian.base.util.ArgumentDataType;
import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.Escape;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;

public class Tools {
    static final short MENU_BYNAME = 0;
    static final short MENU_BYTEXT = 1;
    static final short MENU_BYLABLE = 1;
    static JFrame mainFrame = null;
    static String logFile = null;
    public static String tmpDirectory = System.getProperty("user.dir");
    static Connection ct = null;
    public static boolean ifLog = false;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static /* synthetic */ Class class$0;

    public static Component findComponent(Container parent, String name) {
        Component[] subObjects = parent.getComponents();
        int i = 0;
        while (i < subObjects.length) {
            Component tmpObject = subObjects[i];
            if (tmpObject != null) {
                String sTmp = tmpObject.getName();
                if (sTmp != null && sTmp.equalsIgnoreCase(name)) {
                    return tmpObject;
                }
                if (tmpObject instanceof Container && (tmpObject = Tools.findComponent((Container)tmpObject, name)) != null) {
                    return tmpObject;
                }
            }
            ++i;
        }
        return null;
    }

    public static File getFile(String fileExts) {
        JFileChooser chooser = new JFileChooser(tmpDirectory);
        Section st = new Section(fileExts);
        int i = 0;
        while (i < st.size()) {
            chooser.setFileFilter(Tools.getFileFilter("." + st.get(i), "*." + st.get(i)));
            ++i;
        }
        if (chooser.showOpenDialog(mainFrame) == 0) {
            tmpDirectory = chooser.getSelectedFile().getParent();
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static String getDirectory() {
        JFileChooser chooser = new JFileChooser();
        FileFilter dirFilter = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }

            public String getDescription() {
                return "";
            }
        };
        chooser.setFileFilter(dirFilter);
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(mainFrame) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return "";
    }

    public static int[] getIntArray(String[] sa) {
        int[] ia = new int[sa.length];
        int i = 0;
        while (i < sa.length) {
            ia[i] = Integer.parseInt(sa[i]);
            ++i;
        }
        return ia;
    }

    public static String[] getStringArray(int[] ia) {
        String[] sa = new String[ia.length];
        int i = 0;
        while (i < ia.length) {
            sa[i] = Integer.toString(ia[i]);
            ++i;
        }
        return sa;
    }

    public static void setClipboardString(String data) {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(data);
        clip.setContents(ss, null);
    }

    public static String getClipboardString() {
        try {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable tf = clip.getContents(null);
            String str = (String)tf.getTransferData(DataFlavor.stringFlavor);
            return str;
        }
        catch (Exception ex) {
            Tools.showException(ex);
            return "";
        }
    }

    public static String getLegalColName(JTableEx table, int colIndex, String prefix) {
        int m;
        int r = 0;
        int t = table.getRowCount();
        block0: do {
            ++r;
            m = 0;
            while (m < t) {
                String tmpName = (String)table.data.getValueAt(m, colIndex);
                if (tmpName != null && tmpName.equalsIgnoreCase(String.valueOf(prefix) + Integer.toString(r))) continue block0;
                ++m;
            }
        } while (m < t);
        return String.valueOf(prefix) + Integer.toString(r);
    }

    public static void arrangeWindow(int cmd, JDesktopPane desk) throws Throwable {
        JInternalFrame[] frames = desk.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        int x = 0;
        int y = 0;
        int w = 450;
        int h = 280;
        switch (cmd) {
            case 20001: {
                int i = 0;
                while (i < frames.length) {
                    if (!frames[i].isIcon()) {
                        frames[i].setMaximum(false);
                        frames[i].setBounds(x, y, w, h);
                        frames[i].setSelected(true);
                        x += 20;
                        y += 20;
                    }
                    ++i;
                }
                break;
            }
            case 20002: {
                int deskWidth = desk.getWidth();
                w = deskWidth / frames.length;
                h = desk.getHeight();
                int i = 0;
                while (i < frames.length) {
                    x = i * w;
                    if (!frames[i].isIcon()) {
                        frames[i].setMaximum(false);
                        frames[i].setBounds(x, y, w, h);
                    }
                    ++i;
                }
                break;
            }
            case 20003: {
                int deskHeight = desk.getHeight();
                h = deskHeight / frames.length;
                w = desk.getWidth();
                int i = 0;
                while (i < frames.length) {
                    y = i * h;
                    if (!frames[i].isIcon()) {
                        frames[i].setMaximum(false);
                        frames[i].setBounds(x, y, w, h);
                    }
                    ++i;
                }
                break;
            }
            case 20004: {
                JInternalFrame f = desk.getSelectedFrame();
                if (f == null) break;
                f.setMaximum(true);
                f.setBounds(0, 0, desk.getWidth(), desk.getHeight());
            }
        }
        desk.validate();
    }

    public static JMenuItem findMenuItemByName(JMenuBar menuBar, String name) {
        return Tools.findMenuItem(menuBar, name, (short)0);
    }

    public static JMenuItem findMenuItemByText(JMenuBar menuBar, String text) {
        return Tools.findMenuItem(menuBar, text, (short)1);
    }

    public static void copySelectedValue(JList src, JTableEx tar) {
        Tools.copySelectedValue(null, src, tar);
    }

    public static int copySelectedValue(String preStr, JList src, JTableEx tar) {
        return Tools.copySelectedValue(preStr, src, tar, 0);
    }

    public static ImageIcon getImageIcon(String filePath) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.runqian.base.tool.Tools");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream is = clazz.getResourceAsStream(filePath.toLowerCase());
            byte[] bt = Tools.getStreamBytes(is);
            is.close();
            ImageIcon ii = new ImageIcon(bt);
            return ii;
        }
        catch (Exception e) {
            Tools.showException(e);
            return null;
        }
    }

    public static byte[] getStreamBytes(InputStream is) throws Exception {
        ArrayList<byte[]> al = new ArrayList<byte[]>();
        int totalBytes = 0;
        byte[] b = new byte[102400];
        int readBytes = 0;
        while ((readBytes = is.read(b)) > 0) {
            byte[] bb = new byte[readBytes];
            System.arraycopy(b, 0, bb, 0, readBytes);
            al.add(bb);
            totalBytes += readBytes;
        }
        b = new byte[totalBytes];
        int pos = 0;
        int i = 0;
        while (i < al.size()) {
            byte[] bb = (byte[])al.get(i);
            System.arraycopy(bb, 0, b, pos, bb.length);
            pos += bb.length;
            ++i;
        }
        return b;
    }

    public static int copySelectedValue(String preStr, JList src, JTableEx tar, int tarColIndex) {
        String sCol = (String)src.getSelectedValue();
        if (sCol == null) {
            return -1;
        }
        if (Tools.isValidString(preStr)) {
            sCol = String.valueOf(preStr) + sCol;
        }
        tar.acceptText();
        String val = "";
        int r = tar.getSelectedRow();
        if (r < 0) {
            r = tar.addRow();
        } else {
            val = (String)tar.getValueAt(r, tarColIndex);
            if (val == null) {
                val = "";
            }
        }
        tar.setValueAt(String.valueOf(val) + sCol, r, tarColIndex);
        tar.requestFocus();
        tar.selectRow(r);
        return r;
    }

    public static void addTableRow(JTableEx tab) {
        tab.acceptText();
        int r = tab.addRow();
        tab.selectRow(r);
        tab.requestFocus();
    }

    public static void delTableRow(JTableEx tab) {
        int r = tab.getSelectedRow();
        if (r < 0) {
            return;
        }
        r = tab.removeRow(r);
        tab.selectRow(r);
    }

    private static JMenuItem findMenuItem(JMenuBar menuBar, String str, short searchType) {
        int c = menuBar.getMenuCount();
        int i = 0;
        while (i < c) {
            JMenuItem sItem = (JMenuItem)Tools.extractMenuObject(menuBar.getMenu(i), str, searchType);
            if (sItem != null) {
                return sItem;
            }
            ++i;
        }
        return null;
    }

    public static MenuItem findMenuItemByName(MenuBar menuBar, String name) {
        return Tools.findMenuItem(menuBar, name, (short)0);
    }

    public static MenuItem findMenuItemByText(MenuBar menuBar, String text) {
        return Tools.findMenuItem(menuBar, text, (short)1);
    }

    private static MenuItem findMenuItem(MenuBar menuBar, String str, short searchType) {
        int c = menuBar.getMenuCount();
        int i = 0;
        while (i < c) {
            MenuItem sItem = (MenuItem)Tools.extractMenuObject(menuBar.getMenu(i), str, searchType);
            if (sItem != null) {
                return sItem;
            }
            ++i;
        }
        return null;
    }

    private static Object extractMenuObject(Object menu, String str, short type) {
        Accessible tmpItem;
        Accessible sItem;
        int i;
        int c;
        Accessible pMenu;
        String sTmp = "";
        if (menu instanceof Menu) {
            pMenu = (Menu)menu;
            c = ((Menu)pMenu).getItemCount();
            i = 0;
            while (i < c) {
                sItem = ((Menu)pMenu).getItem(i);
                if (sItem != null) {
                    if (sItem instanceof Menu && (tmpItem = (MenuItem)Tools.extractMenuObject(sItem, str, type)) != null) {
                        return tmpItem;
                    }
                    if (type == 0) {
                        sTmp = ((MenuComponent)((Object)sItem)).getName();
                    } else if (type == 1) {
                        sTmp = ((MenuItem)sItem).getLabel();
                    }
                    if (sTmp != null && sTmp.equalsIgnoreCase(str)) {
                        return sItem;
                    }
                }
                ++i;
            }
        }
        if (menu instanceof JMenu) {
            pMenu = (JMenu)menu;
            c = ((JMenu)pMenu).getItemCount();
            i = 0;
            while (i < c) {
                sItem = ((JMenu)pMenu).getItem(i);
                if (sItem != null) {
                    if (sItem instanceof JMenu && (tmpItem = (JMenuItem)Tools.extractMenuObject(sItem, str, type)) != null) {
                        return tmpItem;
                    }
                    if (type == 0) {
                        sTmp = ((Component)((Object)sItem)).getName();
                    } else if (type == 1) {
                        sTmp = ((AbstractButton)((Object)sItem)).getText();
                    }
                    if (sTmp != null && sTmp.equalsIgnoreCase(str)) {
                        return sItem;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean isValidString(Object str) {
        if (str == null) {
            return false;
        }
        if (!(str instanceof String)) {
            return false;
        }
        String s = (String)str;
        return s.trim().length() != 0;
    }

    public static void setLogFile(String file) {
        logFile = file;
    }

    public static String produceChar(char c, int n) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < n) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static void setConnection(Connection c) {
        ct = c;
    }

    public static boolean isComputeColumn(String column) {
        try {
            int len = column.length();
            int i = 0;
            while (i < len) {
                if (column.regionMatches(false, i, "as ", 0, 3)) {
                    return true;
                }
                char ch = column.charAt(i);
                if (ch == '(' || ch == '+' || ch == '-' || ch == '*' || ch == '/' || ch == '\'' || ch == '\"') {
                    return true;
                }
                ++i;
            }
            return Double.parseDouble(column) > 0.0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ResultSetMetaData getSqlRSMD(String sql) throws SQLException {
        if (sql == null || ct == null) {
            return null;
        }
        try {
            PreparedStatement pst = ct.prepareStatement(sql);
            ResultSetMetaData rsmd = pst.getMetaData();
            return rsmd;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static ResultSet executeSql(String sql) throws SQLException {
        Tools.logDebugMessage("Tools will execute sql:" + sql);
        if (sql == null || ct == null) {
            return null;
        }
        ResultSet res = null;
        Statement stmt = ct.createStatement();
        res = stmt.executeQuery(sql);
        Tools.logDebugMessage("Tools execute sql finished");
        return res;
    }

    public static ResultSet executeProcedure(String define) throws SQLException {
        if (define == null || ct == null) {
            return null;
        }
        ResultSet res = null;
        CallableStatement pst = ct.prepareCall(define);
        res = pst.executeQuery();
        return res;
    }

    private static String getLogFile() {
        return Constants.LOGFILE;
    }

    public static int logDebugMessage(String msg) {
        Tools.log("\u8c03\u8bd5\u4fe1\u606f: \u3010" + msg + "\u3011");
        return 1;
    }

    public static int log(String msg) {
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(Tools.getLogFile(), true), true);
            pw.println();
            pw.print('<');
            pw.print(sdf.format(new Date()));
            pw.println(">");
            pw.println(msg);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e);
        }
        return 1;
    }

    public static void setMainFrame(JFrame jf) {
        mainFrame = jf;
    }

    public static int showException(Throwable e, boolean log) {
        String msg = !Tools.isValidString(e.getMessage()) ? e.toString() : e.getMessage();
        DialogInputText dit = new DialogInputText((Frame)mainFrame, "\u5f02\u5e38\u6d88\u606f");
        dit.setText(msg);
        dit.show();
        if (log) {
            Tools.log(e);
        }
        e.printStackTrace();
        return 1;
    }

    public static int showException(Throwable e) {
        return Tools.showException(e, ifLog);
    }

    public static int log(Throwable e) {
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(Tools.getLogFile(), true), true);
            pw.println();
            pw.print('<');
            pw.print(sdf.format(new Date()));
            pw.println(">");
            e.printStackTrace(pw);
            pw.flush();
            pw.close();
        }
        catch (Throwable ee) {
            JOptionPane.showMessageDialog(null, ee);
        }
        return 1;
    }

    public static void resetListItems(Object list, Object[] items) {
        block3: {
            block2: {
                if (!(list instanceof JListEx)) break block2;
                JListEx jle = (JListEx)list;
                jle.data.removeAllElements();
                int i = 0;
                while (i < items.length) {
                    jle.data.addElement(items[i]);
                    ++i;
                }
                break block3;
            }
            if (!(list instanceof JComboBoxEx)) break block3;
            JComboBoxEx jcb = (JComboBoxEx)list;
            jcb.data.removeAllElements();
            int i = 0;
            while (i < items.length) {
                jcb.data.addElement(items[i]);
                ++i;
            }
        }
    }

    public static int getItemIndex(ListModel listData, String item) {
        int c = listData.getSize();
        int i = 0;
        while (i < c) {
            if (item.equalsIgnoreCase(listData.getElementAt(i).toString())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int[] getItemsIndex(ListModel listData, String items) {
        Section srcItems = new Section();
        int i = 0;
        while (i < listData.getSize()) {
            srcItems.unionSection((String)listData.getElementAt(i));
            ++i;
        }
        return Tools.getItemsIndex(srcItems, items);
    }

    public static int[] getItemsIndex(Section listData, String items) {
        int i;
        Section secItems = new Section(items);
        int c = 0;
        int k = 0;
        while (k < secItems.size()) {
            i = listData.indexOf(secItems.getSection(k));
            if (i != -1) {
                ++c;
            }
            ++k;
        }
        int[] index = new int[c];
        c = 0;
        int k2 = 0;
        while (k2 < secItems.size()) {
            i = listData.indexOf(secItems.getSection(k2));
            if (i != -1) {
                index[c] = i;
                ++c;
            }
            ++k2;
        }
        return index;
    }

    public static String toString(Object[] items) {
        Section ss = new Section();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                ss.unionSection(items[i].toString());
            }
            ++i;
        }
        return ss.toString();
    }

    public static Vector getVector(Object[] items) {
        Vector<Object> v = new Vector<Object>();
        int i = 0;
        while (i < items.length) {
            v.addElement(items[i]);
            ++i;
        }
        return v;
    }

    public static Vector getVector(String str, char delim) {
        return Tools.getVector(str, delim, false);
    }

    public static Vector getVector(String str, char delim, boolean removeEsc) {
        Vector<String> v = new Vector<String>();
        if (str == null) {
            return v;
        }
        ArgumentTokenizer st = new ArgumentTokenizer(str, delim);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (removeEsc) {
                s = Escape.removeEscAndQuote(s);
            }
            if (!Tools.isValidString(s)) {
                v.add("");
                continue;
            }
            v.add(s);
        }
        return v;
    }

    public static void setComboBoxData(JComboBox box, Vector items) {
        box.removeAllItems();
        int s = items.size();
        int i = 0;
        while (i < s) {
            box.addItem(items.get(i));
            ++i;
        }
    }

    public static int findValueInTable(JTable table, Object value, int searchColumn) {
        int i = 0;
        while (i < table.getRowCount()) {
            Object o = table.getValueAt(i, searchColumn);
            if (value.equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void centerWindow(Window w) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension winSize = w.getSize();
        if (winSize.height > screenSize.height) {
            winSize.height = screenSize.height;
        }
        if (winSize.width > screenSize.width) {
            winSize.width = screenSize.width;
        }
        w.setLocation((screenSize.width - winSize.width) / 2, (screenSize.height - winSize.height) / 2);
    }

    public static DefaultCellEditor getTextEditor(JTableEx parent) {
        return new JTextAreaEditor(parent, true);
    }

    public static void main(String[] args) {
        try {
            String testFile = "  ";
            System.out.println(Tools.isValidString(testFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static FileFilter getFileFilter(final String extName, final String desc) {
        FileFilter ff = new FileFilter(){

            public boolean accept(File f) {
                String s = f.getName().toLowerCase();
                return f.isDirectory() || s.endsWith(extName);
            }

            public String getDescription() {
                return desc;
            }
        };
        return ff;
    }

    public static JComboBox getDataTypeComboBox() {
        JComboBox<String> combo = new JComboBox<String>();
        String[] typeNames = ArgumentDataType.getTypeNames();
        int i = 0;
        while (i < ArgumentDataType.getTotalType()) {
            combo.addItem(typeNames[i]);
            ++i;
        }
        return combo;
    }

    public static String[] listDataTypes() {
        return ArgumentDataType.getTypeNames();
    }

    public static int getDataType(String chName) {
        return ArgumentDataType.getTypeId(chName);
    }

    public static String getDataType(int typeId) {
        return ArgumentDataType.getTypeName(typeId);
    }
}

