/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.tool;

import com.runqian.base.tool.Section;
import com.runqian.base.tool.Tools;
import com.sun.xml.util.XmlNames;
import java.io.File;
import java.io.FileWriter;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLFile {
    public static final short POS_UP = 1;
    public static final short POS_DOWN = 2;
    public static final short POS_TOP = 3;
    public static final short POS_BOTTOM = 4;
    public static final short INIT_ITEMS = 5;
    public String xmlFile = null;
    private Document xmlDocument = null;

    public XMLFile(String file) throws Throwable {
        try {
            File f = null;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.xmlFile = file;
            f = new File(this.xmlFile);
            if (!f.isFile()) {
                XMLFile.newXML(this.xmlFile, "root");
                f = new File(this.xmlFile);
            }
            this.xmlDocument = docBuilder.parse(f);
        }
        catch (Throwable t) {
            Tools.showException(new Exception("\u521d\u59cb\u5316XML\u6587\u4ef6\uff1a\r\n" + file + "\r\n\u5931\u8d25\u3002\u9519\u8bef\u539f\u56e0\u4e3a\uff1a\r\n" + t.getMessage()));
        }
    }

    public XMLFile(File file) throws Throwable {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        this.xmlFile = file.getAbsolutePath();
        if (file.exists() && file.isFile()) {
            this.xmlDocument = docBuilder.parse(file);
        } else {
            XMLFile.newXML(this.xmlFile, "root");
        }
    }

    public static XMLFile newConfigFile(String fileName) {
        XMLFile ff;
        try {
            ff = XMLFile.newXML(fileName, "RUNQIAN");
            ff.newElement("RUNQIAN", "DATASOURCES");
            ff.newElement("RUNQIAN", "RECENTFILE");
            ff.newElement("RUNQIAN", "RECENTCONN");
            ff.newElement("RUNQIAN", "RECENTFILE_QUERY");
            ff.newElement("RUNQIAN", "RECENTCONN_QUERY");
            int i = 0;
            while (i < 5) {
                String sTmp = "rq" + Integer.toString(i);
                ff.newElement("RUNQIAN//RECENTFILE", sTmp);
                ff.newAttribute("RUNQIAN//RECENTFILE//" + sTmp, "filename");
                ff.newElement("RUNQIAN//RECENTCONN", sTmp);
                ff.newAttribute("RUNQIAN//RECENTCONN//" + sTmp, "sourcename");
                ff.newElement("RUNQIAN//RECENTFILE_QUERY", sTmp);
                ff.newAttribute("RUNQIAN//RECENTFILE_QUERY//" + sTmp, "filename");
                ff.newElement("RUNQIAN//RECENTCONN_QUERY", sTmp);
                ff.newAttribute("RUNQIAN//RECENTCONN_QUERY//" + sTmp, "sourcename");
                ++i;
            }
            ff.newElement("RUNQIAN", "PARAM");
            ff.newElement("RUNQIAN", "FUNCTIONS");
            ff.newElement("RUNQIAN//FUNCTIONS", "DataSet");
            ff.newElement("RUNQIAN//FUNCTIONS", "Normal");
            ff.save();
        }
        catch (Throwable err) {
            err.printStackTrace();
            return null;
        }
        return ff;
    }

    public static XMLFile newXML(String file, String root) throws Throwable {
        if (!XMLFile.isLegalXmlName(root)) {
            throw new Exception("\u65e0\u6548\u7684XML\u8282\u70b9\u540d\u79f0\u3002");
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document sxmlDocument = docBuilder.newDocument();
        Element eRoot = sxmlDocument.createElement(root);
        eRoot.normalize();
        sxmlDocument.appendChild(eRoot);
        XMLFile.writeNodeToFile(sxmlDocument, file);
        return new XMLFile(file);
    }

    public Section listAll(String path) throws Exception {
        Section ss = new Section();
        Node tmpNode = this.getTerminalNode(path, (short)1);
        ss.unionSection(this.getNodesName(tmpNode.getChildNodes()));
        ss.unionSection(this.getNodesName(tmpNode.getAttributes()));
        return ss;
    }

    public Section listElement(String path) throws Exception {
        Node tmpNode = this.getTerminalNode(path, (short)1);
        return this.getNodesName(tmpNode.getChildNodes());
    }

    public Section listAttribute(String path) throws Exception {
        Node tmpNode = this.getTerminalNode(path, (short)1);
        return this.getNodesName(tmpNode.getAttributes());
    }

    public String getAttribute(String path) {
        try {
            Node tmpNode = this.getTerminalNode(path, (short)2);
            return tmpNode.getNodeValue();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String newElement(String path, String element) throws Exception {
        Element newElement = null;
        if (!XMLFile.isLegalXmlName(element)) {
            throw new Exception("\u65e0\u6548\u7684\u5143\u7d20\u8282\u70b9\u540d\u79f0\u3002");
        }
        Node parent = this.getTerminalNode(path, (short)1);
        NodeList nl = parent.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase(element)) break;
            ++i;
        }
        if (i >= nl.getLength()) {
            newElement = this.xmlDocument.createElement(element);
            parent.appendChild(newElement);
        }
        return String.valueOf(path) + "/" + element;
    }

    public int newAttribute(String path, String attr) throws Exception {
        if (!XMLFile.isLegalXmlName(attr)) {
            throw new Exception("\u65e0\u6548\u7684\u5c5e\u6027\u8282\u70b9\u540d\u79f0\u3002");
        }
        Node parent = this.getTerminalNode(path, (short)1);
        NamedNodeMap nl = parent.getAttributes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase(attr)) break;
            ++i;
        }
        if (i < nl.getLength()) {
            return -1;
        }
        ((Element)parent).setAttribute(attr, "");
        return 1;
    }

    public void delete(String path) throws Exception {
        this.deleteAttribute(path);
        this.deleteElement(path);
    }

    public void deleteElement(String path) throws Exception {
        Node nd = this.getTerminalNode(path, (short)1);
        Node parent = nd.getParentNode();
        parent.removeChild(nd);
    }

    public boolean isPathExists(String path) {
        try {
            Node nd = this.getTerminalNode(path, (short)1);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteAttribute(String path) throws Exception {
        void var3_4;
        int i = path.lastIndexOf(47);
        if (i <= 0) {
            return;
        }
        String p = path.substring(0, i);
        Node parent = this.getTerminalNode(p, (short)1);
        ((Element)var3_4).removeAttribute(path.substring(i + 1));
    }

    public void renameAttribute(String path, String newName) throws Exception {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            throw new Exception("\u65e0\u6548\u7684\u5c5e\u6027\u8def\u5f84\u3002");
        }
        String value = this.getAttribute(path);
        this.deleteAttribute(path);
        this.setAttribute(String.valueOf(path.substring(0, i)) + "/" + newName, value);
    }

    public void renameElement(String path, String newName) throws Exception {
        NamedNodeMap childAttr;
        int i;
        if (path.lastIndexOf(47) == -1) {
            throw new Exception("\u4e0d\u5141\u8bb8\u66f4\u6539\u6839\u8282\u70b9\u7684\u540d\u5b57\u3002");
        }
        Node nd = this.getTerminalNode(path, (short)1);
        Node pp = nd.getParentNode();
        NodeList childNodes = pp.getChildNodes();
        if (childNodes != null) {
            i = 0;
            while (i < childNodes.getLength()) {
                if (newName.equalsIgnoreCase(childNodes.item(i).getNodeName())) {
                    throw new Exception("\u5df2\u7ecf\u5b58\u5728\u4e86\u540c\u540d\u7684\u8282\u70b9\u3002");
                }
                ++i;
            }
        }
        Element newNode = this.xmlDocument.createElement(newName);
        childNodes = nd.getChildNodes();
        if (childNodes != null) {
            i = 0;
            while (i < childNodes.getLength()) {
                newNode.appendChild(childNodes.item(i));
                ++i;
            }
        }
        if ((childAttr = nd.getAttributes()) != null) {
            i = 0;
            while (i < childAttr.getLength()) {
                Node tmpNode = childAttr.item(i);
                newNode.setAttribute(tmpNode.getNodeName(), tmpNode.getNodeValue());
                ++i;
            }
        }
        pp.replaceChild(newNode, nd);
    }

    public void setAttribute(String path, String value) throws Exception {
        if (path == null) {
            throw new Exception("Null object of path.");
        }
        if (path.trim().length() == 0) {
            throw new Exception("\u65e0\u6548\u7684\u8def\u5f84.");
        }
        if (value == null) {
            this.deleteAttribute(path);
            return;
        }
        int i = path.lastIndexOf(47);
        if (i > 0) {
            String p = path.substring(0, i);
            String v = path.substring(i + 1);
            this.newAttribute(p, v);
        }
        Node nd = this.getTerminalNode(path, (short)2);
        nd.setNodeValue(value);
    }

    public int setPosition(String path, int posCmd) throws Exception {
        Node nd = this.getTerminalNode(path, (short)1);
        block0 : switch (nd.getNodeType()) {
            case 1: {
                Node parent = nd.getParentNode();
                if (parent == null) {
                    throw new Exception("\u6839\u8282\u70b9\u4e0d\u80fd\u79fb\u52a8\u3002");
                }
                switch (posCmd) {
                    case 3: {
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        break block0;
                    }
                }
                throw new Exception("\u4e0d\u8ba4\u8bc6\u7684\u8282\u70b9\u64cd\u4f5c\u547d\u4ee4\u3002");
            }
            case 2: {
                break;
            }
            default: {
                throw new Exception("\u9047\u5230\u4e86\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u7684\u8282\u70b9\u7c7b\u578b\u3002");
            }
        }
        return 1;
    }

    public void save() throws Exception {
        XMLFile.writeNodeToFile(this.xmlDocument, this.xmlFile);
    }

    public static void writeNodeToFile(Document node, String file) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("encoding", "gb2312");
        DOMSource source = new DOMSource(node);
        FileWriter out = new FileWriter(file);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
        out.close();
    }

    private Section getNodesName(Object obj) throws Exception {
        int i;
        Section ss = new Section();
        if (obj == null) {
            return ss;
        }
        Node nd = null;
        if (obj instanceof NodeList) {
            NodeList nl = (NodeList)obj;
            i = 0;
            while (i < nl.getLength()) {
                nd = nl.item(i);
                if (nd.getNodeType() == 1) {
                    ss.unionSection(nd.getNodeName());
                }
                ++i;
            }
        }
        if (obj instanceof NamedNodeMap) {
            NamedNodeMap nnm = (NamedNodeMap)obj;
            i = 0;
            while (i < nnm.getLength()) {
                nd = nnm.item(i);
                ss.unionSection(nd.getNodeName());
                ++i;
            }
        }
        return ss;
    }

    private Node locateNode(Object obj, String nodeName) throws Exception {
        String sTmp;
        int i = 0;
        int j = 0;
        Node tmpNode = null;
        if (obj instanceof NodeList) {
            NodeList nl = (NodeList)obj;
            i = nl.getLength();
            j = 0;
            while (j < i) {
                tmpNode = nl.item(j);
                sTmp = tmpNode.getNodeName();
                if (sTmp.equalsIgnoreCase(nodeName)) break;
                ++j;
            }
        }
        if (obj instanceof NamedNodeMap) {
            NamedNodeMap nnm = (NamedNodeMap)obj;
            i = nnm.getLength();
            j = 0;
            while (j < i) {
                tmpNode = nnm.item(j);
                sTmp = tmpNode.getNodeName();
                if (sTmp.equalsIgnoreCase(nodeName)) break;
                ++j;
            }
        }
        if (j == i) {
            throw new Exception("\u65e0\u6548\u7684\u8def\u5f84\u3002" + nodeName);
        }
        return tmpNode;
    }

    private Node getTerminalNode(String path, short type) throws Exception {
        Node tmpNode = null;
        if (path == null) {
            throw new Exception("\u6240\u7ed9\u7684\u8def\u5f84\u4e3anull\u3002");
        }
        int i = path.lastIndexOf(47);
        if (i == -1) {
            if (path.length() == 0) {
                return this.xmlDocument;
            }
            String sNode = path;
            if (type == 1) {
                tmpNode = this.locateNode(this.xmlDocument.getChildNodes(), sNode);
            }
        } else {
            String sLast = path.substring(i + 1);
            path = path.substring(0, i);
            StringTokenizer st = new StringTokenizer(path, "/");
            NodeList childNodes = this.xmlDocument.getChildNodes();
            while (st.hasMoreTokens()) {
                String sNode = st.nextToken();
                tmpNode = this.locateNode(childNodes, sNode);
                if (tmpNode == null) {
                    throw new Exception("\u6307\u5b9a\u7684\u8def\u5f84\u4e0d\u5b58\u5728\u3002");
                }
                childNodes = tmpNode.getChildNodes();
            }
            tmpNode = type == 1 ? this.locateNode(tmpNode.getChildNodes(), sLast) : this.locateNode(tmpNode.getAttributes(), sLast);
        }
        if (tmpNode == null) {
            throw new Exception("\u6307\u5b9a\u7684\u8def\u5f84\u4e0d\u5b58\u5728\u3002");
        }
        return tmpNode;
    }

    private static boolean isLegalXmlName(String input) {
        if (input == null || input.length() == 0) {
            return false;
        }
        return XmlNames.isName((String)input);
    }
}

