/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.Escape;

public class Argument {
    public String enName;
    public String chName;
    public String type;
    public String width;
    public String fmt;
    public String value;

    public static String getPrompt() {
        return "\u82f1\u6587\u540d\u79f0,\u4e2d\u6587\u540d\u79f0,\u7c7b\u578b,\u6700\u5927\u5bbd\u5ea6,\u8f93\u5165\u683c\u5f0f,\u53c2\u6570\u503c";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("en=");
        if (this.enName != null) {
            sb.append(Escape.addEscAndQuote(this.enName));
        }
        sb.append(",ch=");
        if (this.chName != null) {
            sb.append(Escape.addEscAndQuote(this.chName));
        }
        sb.append(",tp=");
        if (this.type != null) {
            sb.append(this.type);
        }
        sb.append(",w=");
        if (this.width != null) {
            sb.append(this.width);
        }
        sb.append(",fmt=");
        if (this.fmt != null) {
            sb.append(Escape.addEscAndQuote(this.fmt));
        }
        sb.append(",val=");
        if (this.value != null) {
            sb.append(Escape.addEscAndQuote(this.value));
        }
        return sb.toString();
    }

    public Argument() {
    }

    public Argument(String segStr) {
        ArgumentTokenizer at = new ArgumentTokenizer(segStr, ',');
        while (at.hasNext()) {
            String one = at.next();
            if (one.startsWith("en=")) {
                this.enName = Escape.removeEscAndQuote(one.substring(3));
                continue;
            }
            if (one.startsWith("ch=")) {
                this.chName = Escape.removeEscAndQuote(one.substring(3));
                continue;
            }
            if (one.startsWith("tp=")) {
                this.type = one.substring(3);
                continue;
            }
            if (one.startsWith("w=")) {
                this.width = one.substring(2);
                continue;
            }
            if (one.startsWith("fmt=")) {
                this.fmt = Escape.removeEscAndQuote(one.substring(4));
                continue;
            }
            if (!one.startsWith("val=")) continue;
            this.value = Escape.removeEscAndQuote(one.substring(4));
        }
    }

    public Argument(String enName, String chName, String type, String width, String fmt) {
        this.enName = enName;
        this.chName = chName;
        this.type = type;
        this.width = width;
        this.fmt = fmt;
        this.value = null;
    }

    public Argument(String enName, String chName, String type, String width, String fmt, String value) {
        this.enName = enName;
        this.chName = chName;
        this.type = type;
        this.width = width;
        this.fmt = fmt;
        this.value = value;
    }
}

