/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import com.runqian.base.tool.Tools;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;

public class ArgumentDataType {
    public static final int INTEGER = 17;
    public static final int DOUBLE = 19;
    public static final int STRING = 6;
    public static final int DATE = 2;
    public static final int TIME = 3;
    public static final int TIMESTAMP = 4;
    public static final int BOOLEAN = 5;
    public static final int DEFAULT = 9;
    public static final int ARR_INTEGER = 273;
    public static final int ARR_DOUBLE = 275;
    public static final int ARR_STRING = 262;
    private static final int[] types = new int[]{17, 19, 6, 2, 3, 4, 5, 273, 275, 262, 9};
    private static final String[] names = new String[]{"\u6574\u6570", "\u5b9e\u6570", "\u5b57\u7b26\u4e32", "\u65e5\u671f", "\u65f6\u95f4", "\u65e5\u671f\u65f6\u95f4", "\u5e03\u5c14", "\u6574\u6570\u7ec4", "\u5b9e\u6570\u7ec4", "\u5b57\u7b26\u4e32\u7ec4", "\u9ed8\u8ba4"};

    public static int getTotalType() {
        return types.length;
    }

    public static int[] getTypeIds() {
        return types;
    }

    public static String[] getTypeNames() {
        return names;
    }

    public static String getTypeName(int type) {
        int i = 0;
        while (i < ArgumentDataType.getTotalType()) {
            if (type == types[i]) {
                return names[i];
            }
            ++i;
        }
        return "";
    }

    public static int getTypeId(String name) {
        int i = 0;
        while (i < ArgumentDataType.getTotalType()) {
            if (names[i].equalsIgnoreCase(name)) {
                return types[i];
            }
            ++i;
        }
        return -1;
    }

    public static Object getProperData(int type, String val) {
        if (!Tools.isValidString(val)) {
            return null;
        }
        switch (type) {
            case 17: {
                return Integer.valueOf(val.trim());
            }
            case 19: {
                return Double.valueOf(val.trim());
            }
            case 6: {
                return val;
            }
            case 2: {
                return Date.valueOf(val.trim());
            }
            case 3: {
                return Time.valueOf(val.trim());
            }
            case 4: {
                return Timestamp.valueOf(val.trim());
            }
            case 5: {
                return Boolean.valueOf(val.trim());
            }
            case 273: {
                Vector v = Tools.getVector(val, ',');
                ArrayList<Integer> ls = new ArrayList<Integer>();
                int i = 0;
                while (i < v.size()) {
                    ls.add(Integer.valueOf((String)v.get(i)));
                    ++i;
                }
                return ls;
            }
            case 275: {
                Vector v = Tools.getVector(val, ',');
                ArrayList<Double> ls = new ArrayList<Double>();
                int i = 0;
                while (i < v.size()) {
                    ls.add(Double.valueOf((String)v.get(i)));
                    ++i;
                }
                return ls;
            }
            case 262: {
                Vector v = Tools.getVector(val, ',');
                ArrayList ls = new ArrayList();
                int i = 0;
                while (i < v.size()) {
                    ls.add(v.get(i));
                    ++i;
                }
                return ls;
            }
        }
        return null;
    }
}

