/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import com.runqian.base.util.Argument;
import com.runqian.base.util.ArgumentTokenizer;

public class Arguments {
    Argument[] args = new Argument[8];
    int count = 0;

    private boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        int l = s.length();
        int i = 0;
        while (i < l) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Arguments() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    void expandTo(int size) {
        if (size > this.args.length) {
            Argument[] tmp = this.args;
            this.args = new Argument[size + 8];
            if (tmp != null) {
                System.arraycopy(tmp, 0, this.args, 0, this.count);
            }
        }
    }

    public Arguments(String segStr) {
        int i = 0;
        ArgumentTokenizer at = new ArgumentTokenizer(segStr.trim(), ';');
        while (at.hasNext()) {
            String one = at.next();
            Argument a = new Argument(one);
            if (!this.isValid(a.enName) || !this.isValid(a.type)) continue;
            this.expandTo(i + 1);
            this.args[i] = a;
            ++i;
            ++this.count;
        }
    }

    public Argument get(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException("index" + index + " out of arguments' number");
        }
        return this.args[index];
    }

    public Argument get(String argName) {
        if (argName == null) {
            return null;
        }
        int i = 0;
        while (i < this.count) {
            if (argName.equals(this.args[i].enName)) {
                return this.args[i];
            }
            ++i;
        }
        return null;
    }

    public void set(int index, Argument arg) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("index" + index + " out of arguments' number");
        }
        if (index >= this.count) {
            this.expandTo(index + 1);
        }
        if (arg == null) {
            return;
        }
        if (!this.isValid(arg.enName) || !this.isValid(arg.type)) {
            return;
        }
        this.args[index] = arg;
        if (index >= this.count) {
            this.count = index + 1;
        }
    }

    public void add(Argument arg) {
        this.set(this.count, arg);
    }

    public String[] getArgumentNames() {
        String[] ss = new String[this.count];
        int i = 0;
        while (i < this.count) {
            ss[i] = this.args[i].enName;
            ++i;
        }
        return ss;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128 * this.count);
        int i = 0;
        while (i < this.count) {
            if (this.args[i] != null) {
                sb.append(this.args[i].toString()).append(';');
            }
            ++i;
        }
        return sb.toString();
    }
}

