/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import com.runqian.base.tool.Tools;
import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.DBTypes;
import com.runqian.base.util.ReportError;
import com.runqian.base.util.SegmentSet;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;

public class ConnectionConfig {
    private String name;
    private String driver;
    private String url;
    private String userId;
    private String pwd;
    private String dbType;
    private String encode;
    private boolean sqlEncode;
    private String extendProperties;

    public ConnectionConfig(String cfg) {
        int pos = cfg.indexOf("=");
        this.name = cfg.substring(0, pos);
        String tmp = cfg.substring(pos + 1);
        ArgumentTokenizer at = new ArgumentTokenizer(tmp, ',');
        this.driver = at.nextToken().trim();
        this.url = at.nextToken().trim();
        this.userId = at.nextToken().trim();
        this.pwd = at.nextToken().trim();
        this.dbType = at.nextToken().trim();
        this.encode = at.nextToken().trim();
        if (at.hasMoreTokens()) {
            tmp = at.nextToken();
            this.sqlEncode = tmp.equals("1");
        }
    }

    public ConnectionConfig(String name, String driver, String url, String userId, String pwd, String dbType, String encode) {
        this(name, driver, url, userId, pwd, dbType, encode, null);
    }

    public ConnectionConfig(String name, String driver, String url, String userId, String pwd, String dbType, String encode, String extendProperties) {
        this.name = name;
        this.driver = driver;
        this.url = url;
        this.userId = userId;
        this.pwd = pwd;
        this.dbType = dbType;
        this.encode = encode;
        this.extendProperties = extendProperties;
    }

    public Connection getConnection() {
        Connection conn = null;
        try {
            Driver d = (Driver)Class.forName(this.driver).newInstance();
            DriverManager.registerDriver(d);
            if (Tools.isValidString(this.extendProperties)) {
                Properties p = new Properties();
                p.put("user", this.userId);
                p.put("password", this.pwd);
                SegmentSet s = new SegmentSet(this.extendProperties);
                Iterator it = s.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String val = s.get(key);
                    p.put(key, val);
                }
                conn = DriverManager.getConnection(this.url, p);
            } else {
                conn = DriverManager.getConnection(this.url, this.userId, this.pwd);
            }
            return conn;
        }
        catch (Exception e) {
            throw new ReportError(e.getMessage(), e);
        }
    }

    public static void close(Connection con) {
        if (con != null) {
            try {
                if (!con.isClosed()) {
                    con.close();
                }
            }
            catch (SQLException e) {
                throw new ReportError(e.getMessage(), e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPass() {
        return this.pwd;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getEncode() {
        return this.encode;
    }

    public int getIntDBType() {
        return DBTypes.getDBType(this.dbType);
    }

    public boolean getSqlEncode() {
        return this.sqlEncode;
    }
}

