/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;

public class DBTypes {
    public static final int UNKNOWN = 0;
    public static final int ORACLE = 1;
    public static final int SQLSVR = 2;
    public static final int SYBASE = 3;
    public static final int SQLANY = 4;
    public static final int INFMIX = 5;
    public static final int FOXPRO = 6;
    public static final int ACCESS = 7;
    public static final int FOXBAS = 8;
    public static final int DB2 = 9;
    public static final int MYSQL = 10;
    public static final int KINGBASE = 11;
    public static final int OLAP = 100;
    public static final int ESSBASE = 101;
    private static final int[] dbTypes;
    private static final String[] dbNames;
    private static final int[] mdbTypes;
    private static final String[] mdbNames;

    static {
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        dbTypes = nArray;
        dbNames = new String[]{"UNKNOWN", "ORACLE", "SQLSVR", "SYBASE", "SQLANY", "INFMIX", "FOXPRO", "ACCESS", "FOXBAS", "DB2", "MYSQL", "KINGBASE"};
        mdbTypes = new int[]{101};
        mdbNames = new String[]{"ESSBASE"};
    }

    public static int getDBType(String dbTypeName) {
        if (dbTypeName == null) {
            return 0;
        }
        String dtn = dbTypeName.trim();
        int i = 0;
        while (i < dbNames.length) {
            if (dbNames[i].equalsIgnoreCase(dtn)) {
                return dbTypes[i];
            }
            ++i;
        }
        i = 0;
        while (i < mdbNames.length) {
            if (mdbNames[i].equalsIgnoreCase(dtn)) {
                return mdbTypes[i];
            }
            ++i;
        }
        return 0;
    }

    public static String getDBTypeName(int dbType) {
        int i = 0;
        while (i < dbTypes.length) {
            if (dbType == dbTypes[i]) {
                return dbNames[i];
            }
            ++i;
        }
        i = 0;
        while (i < mdbTypes.length) {
            if (dbType == mdbTypes[i]) {
                return mdbNames[i];
            }
            ++i;
        }
        return dbNames[0];
    }

    public static char getQuotation(int dbType) {
        return (char)(dbType == 5 || dbType == 6 || dbType == 7 || dbType == 8 ? 34 : 39);
    }

    public static String addQuotation(int dbType, String value) {
        if (value == null || value.length() == 0) {
            return "null";
        }
        char quote = '\'';
        if (dbType == 5 || dbType == 6 || dbType == 7 || dbType == 8) {
            quote = '\"';
        }
        int len = value.length();
        StringBuffer sb = new StringBuffer(len + 10);
        sb.append(quote);
        int i = 0;
        while (i < len) {
            char ch = value.charAt(i);
            if (ch == quote) {
                sb.append(ch);
            }
            sb.append(ch);
            ++i;
        }
        sb.append(quote);
        return sb.toString();
    }

    public static String getCharConst(int dbType, String value) {
        return DBTypes.addQuotation(dbType, value);
    }

    public static String getDateConst(int dbType, String value) {
        if (value == null || value.length() == 0) {
            return "null";
        }
        switch (dbType) {
            case 1: {
                return "to_date('" + value + "','yyyy-mm-dd')";
            }
        }
        return "'" + value + "'";
    }

    public static String getTimeConst(int dbType, String value) {
        if (value == null || value.length() == 0) {
            return "null";
        }
        switch (dbType) {
            case 1: {
                return "to_date('" + value + "','hh24:mi:ss')";
            }
        }
        return "'" + value + "'";
    }

    public static String getTimestampConst(int dbType, String value) {
        if (value == null || value.length() == 0) {
            return "null";
        }
        switch (dbType) {
            case 1: {
                return "to_date('" + value + "','yyyy-mm-dd hh24:mi:ss')";
            }
        }
        return "'" + value + "'";
    }

    public static String getDBConst(int dbType, Object value, int datatype) {
        if (value == null) {
            return "null";
        }
        switch (datatype) {
            case -1: 
            case 1: 
            case 12: {
                return DBTypes.getCharConst(dbType, value.toString());
            }
            case 91: {
                return DBTypes.getDateConst(dbType, value.toString());
            }
            case 92: {
                if (value instanceof Time) {
                    DateFormat df = DateFormat.getTimeInstance(2);
                    value = df.format(value);
                }
                return DBTypes.getTimeConst(dbType, value.toString());
            }
            case 93: {
                if (value instanceof Timestamp) {
                    DateFormat df = DateFormat.getDateTimeInstance(2, 2);
                    value = df.format(value);
                }
                return DBTypes.getTimestampConst(dbType, value.toString());
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                String s = value.toString();
                return s.length() == 0 ? "null" : s;
            }
        }
        throw new IllegalArgumentException();
    }
}

