/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import com.runqian.base.util.ObjectCache;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;

public final class DateTool {
    private static DateFormat df = null;
    private static DateFormat tf = null;
    private static DateFormat dtf = null;

    static {
        df = ObjectCache.getDateFormat("yyyy-MM-dd");
        df.getCalendar().setLenient(false);
        tf = ObjectCache.getDateFormat("HH:mm:ss");
        tf.getCalendar().setLenient(false);
        dtf = ObjectCache.getDateFormat("yyyy-MM-dd HH:mm:ss");
        dtf.getCalendar().setLenient(false);
    }

    public static String formatDate(Date date) {
        return df.format(date);
    }

    public static String formatTime(Date date) {
        return tf.format(date);
    }

    public static String formatTimestamp(Date date) {
        return dtf.format(date);
    }

    public static Date parseDate(String data, int beginIndex) throws ParseException {
        if (data == null) {
            return null;
        }
        return df.parse(data, new ParsePosition(beginIndex));
    }

    public static Date parseDate(String data) throws ParseException {
        if (data == null) {
            return null;
        }
        return df.parse(data);
    }

    public static Date parseTime(String data, int beginIndex) throws ParseException {
        if (data == null) {
            return null;
        }
        return tf.parse(data, new ParsePosition(beginIndex));
    }

    public static Date parseTime(String data) throws ParseException {
        if (data == null) {
            return null;
        }
        return tf.parse(data);
    }

    public static Date parseTimestamp(String data, int beginIndex) throws ParseException {
        if (data == null) {
            return null;
        }
        return dtf.parse(data, new ParsePosition(beginIndex));
    }

    public static Date parseTimestamp(String data) throws ParseException {
        if (data == null) {
            return null;
        }
        return dtf.parse(data);
    }
}

