/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class DiGraph {
    private Map edges = new HashMap(100);

    public Set vertexSet() {
        return this.edges.keySet();
    }

    public Set getOutEdges(Object vertex) {
        return (Set)this.edges.get(vertex);
    }

    public Map getAdjacencyTable() {
        return this.edges;
    }

    public Set getAllOutEdges() {
        HashSet outedges = new HashSet();
        Iterator it = this.vertexSet().iterator();
        while (it.hasNext()) {
            Set edge = this.getOutEdges(it.next());
            if (edge == null) continue;
            outedges.addAll(edge);
        }
        return outedges;
    }

    public Stack sort() {
        return this.depthTopSort();
    }

    public Stack depthTopSort() {
        HashMap visited = new HashMap();
        Stack topOrder = new Stack();
        Iterator it = this.vertexSet().iterator();
        while (it.hasNext()) {
            visited.put(it.next(), Boolean.FALSE);
        }
        it = this.vertexSet().iterator();
        while (it.hasNext()) {
            Object v = it.next();
            Boolean bool = (Boolean)visited.get(v);
            if (bool != Boolean.FALSE) continue;
            this.recDepthSort(v, visited, topOrder);
        }
        return topOrder;
    }

    private void recDepthSort(Object v, Map visited, Stack topOrder) {
        visited.put(v, Boolean.TRUE);
        Set edge = this.getOutEdges(v);
        if (edge != null) {
            Iterator it = edge.iterator();
            while (it.hasNext()) {
                Object outv = it.next();
                Boolean bool = (Boolean)visited.get(outv);
                if (bool != Boolean.FALSE) continue;
                this.recDepthSort(outv, visited, topOrder);
            }
        }
        topOrder.push(v);
    }

    public boolean hasNextLayers() {
        Set outedges;
        Set vertices = this.vertexSet();
        return !vertices.equals(outedges = this.getAllOutEdges());
    }

    public Set nextLayer() {
        HashSet vertices = new HashSet();
        vertices.addAll(this.vertexSet());
        HashSet outedges = new HashSet();
        outedges.addAll(this.getAllOutEdges());
        vertices.removeAll(outedges);
        this.remove(vertices);
        return vertices;
    }

    public void put(Object vertex, Set outedges) {
        if (this.edges.containsKey(vertex)) {
            Set edge = (Set)this.edges.get(vertex);
            if (edge != null) {
                if (outedges != null) {
                    edge.addAll(outedges);
                }
            } else if (outedges != null) {
                edge = outedges;
                this.edges.put(vertex, edge);
            }
        } else {
            this.edges.put(vertex, outedges);
        }
        if (outedges != null) {
            Iterator it = outedges.iterator();
            while (it.hasNext()) {
                Object v = it.next();
                if (this.edges.containsKey(v)) continue;
                this.edges.put(v, null);
            }
        }
    }

    public void put(Object vertex, Object avertex) {
        if (vertex == null) {
            return;
        }
        Set<Object> edge = null;
        if (this.edges.containsKey(vertex)) {
            if (avertex != null) {
                edge = (Set)this.edges.get(vertex);
                if (edge == null) {
                    edge = new HashSet();
                    this.edges.put(vertex, edge);
                }
                edge.add(avertex);
            }
        } else {
            if (avertex != null) {
                edge = new HashSet<Object>();
                edge.add(avertex);
            }
            this.edges.put(vertex, edge);
        }
        if (!this.edges.containsKey(avertex)) {
            this.edges.put(avertex, null);
        }
    }

    public void remove(Object vertex) {
        this.edges.remove(vertex);
        Iterator it = this.vertexSet().iterator();
        while (it.hasNext()) {
            Set edge = (Set)this.edges.get(it.next());
            if (edge == null) continue;
            edge.remove(vertex);
        }
    }

    public void remove(Set vset) {
        Iterator it = vset.iterator();
        while (it.hasNext()) {
            this.remove(it.next());
        }
    }

    public boolean hasCycle() {
        Iterator it = this.vertexSet().iterator();
        while (it.hasNext()) {
            Object vertex = it.next();
            if (!this.hasPath(vertex, vertex)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.vertexSet().isEmpty();
    }

    public boolean hasPath(Object start, Object end) {
        Set outedges = this.getOutEdges(start);
        if (outedges == null || outedges.isEmpty()) {
            return false;
        }
        if (outedges.contains(end)) {
            return true;
        }
        Iterator it = outedges.iterator();
        while (it.hasNext()) {
            if (!this.hasPath(it.next(), end)) continue;
            return true;
        }
        return false;
    }

    public void printEdge(Object vertex) {
        if (!this.edges.containsKey(vertex)) {
            return;
        }
        Set edge = (Set)this.edges.get(vertex);
        System.out.print(vertex + ": ");
        if (edge == null) {
            System.out.println();
            return;
        }
        Iterator it = edge.iterator();
        while (it.hasNext()) {
            System.out.print("  [" + it.next() + "]");
        }
        System.out.println();
    }

    public static void main(String[] args) {
        DiGraph dg = new DiGraph();
        String a1 = new String("1");
        String a2 = new String("2");
        String a3 = new String("3");
        String a4 = new String("4");
        String a5 = new String("5");
        String a6 = new String("6");
        HashSet s1 = new HashSet();
        HashSet<String> s2 = new HashSet<String>();
        s2.add(a4);
        s2.add(a1);
        HashSet<String> s3 = new HashSet<String>();
        s3.add(a6);
        s3.add(a2);
        HashSet<String> s4 = new HashSet<String>();
        s4.add(a6);
        s4.add(a5);
        s4.add(a3);
        HashSet<String> s5 = new HashSet<String>();
        s5.add(a1);
        HashSet<String> s6 = new HashSet<String>();
        s6.add(a5);
        s6.add(a2);
        s6.add(a1);
        dg.put((Object)a1, null);
        dg.put((Object)a2, s2);
        dg.put((Object)a3, s3);
        dg.put((Object)a4, s4);
        dg.put((Object)a5, s5);
        dg.put((Object)a6, s6);
        dg.printEdge(a1);
        dg.printEdge(a2);
        dg.printEdge(a3);
        dg.printEdge(a4);
        dg.printEdge(a5);
        dg.printEdge(a6);
        System.out.println("This diGraph has cycle is " + dg.hasCycle());
        System.out.println("1->1 has cycle is " + dg.hasPath(a1, a1));
        System.out.println("2->2 has cycle is " + dg.hasPath(a2, a2));
        System.out.println("3->3 has cycle is " + dg.hasPath(a3, a3));
        System.out.println("4->4 has cycle is " + dg.hasPath(a4, a4));
        System.out.println("5->5 has cycle is " + dg.hasPath(a5, a5));
        System.out.println("6->6 has cycle is " + dg.hasPath(a6, a6));
        dg.remove(a6);
        System.out.println("edges after remove 6");
        dg.printEdge(a1);
        dg.printEdge(a2);
        dg.printEdge(a3);
        dg.printEdge(a4);
        dg.printEdge(a5);
        dg.printEdge(a6);
        dg.remove(a5);
        dg.remove(a4);
        Stack s = dg.depthTopSort();
        while (!s.empty()) {
            System.out.print(" [" + s.pop() + "]");
        }
        System.out.println();
        System.out.println("--------------TEST LAYER-------------");
        dg.put((Object)a1, a4);
        dg.put((Object)a2, a4);
        dg.put((Object)a5, a4);
        dg.put((Object)a5, a6);
        dg.put((Object)a6, a1);
        int i = 1;
        while (dg.hasNextLayers()) {
            Set layer = dg.nextLayer();
            System.out.print("Layer " + i + ": ");
            ++i;
        }
    }
}

