/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import com.runqian.base.util.DateTool;
import com.runqian.base.util.Escape;
import com.runqian.base.util.NStringMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class IniFile {
    private volatile Map ht = null;
    private int fileLen = 0;
    private static String charset = "GB2312";
    File file = null;
    private boolean caseSensitive = false;

    private boolean continueLine(String s) {
        int i = 0;
        int j = s.length() - 1;
        while (j >= 0 && s.charAt(j--) == '\\') {
            ++i;
        }
        return i % 2 == 1;
    }

    private String loadConvert(String s) {
        int i = s.length();
        StringBuffer sb = new StringBuffer(i);
        int j = 0;
        while (j < i) {
            int c;
            if ((c = s.charAt(j++)) == 92) {
                if ((c = s.charAt(j++)) == 116) {
                    c = 9;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 102) {
                    c = 12;
                }
                sb.append((char)c);
                continue;
            }
            sb.append((char)c);
        }
        try {
            return new String(sb.toString().getBytes(charset));
        }
        catch (Exception exception) {
            return sb.toString();
        }
    }

    public IniFile() {
    }

    public IniFile(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public IniFile(String fileName) throws FileNotFoundException, IOException {
        this(fileName, false);
    }

    public IniFile(String fileName, boolean caseSensitive) throws FileNotFoundException, IOException {
        this.caseSensitive = caseSensitive;
        this.file = new File(fileName);
        this.read(this.file);
    }

    public IniFile(File path, String fileName) throws FileNotFoundException, IOException {
        this(path, fileName, false);
    }

    public IniFile(File path, String fileName, boolean caseSensitive) throws FileNotFoundException, IOException {
        this.caseSensitive = caseSensitive;
        this.file = new File(path, fileName);
        this.read(this.file);
    }

    public IniFile(File file) throws FileNotFoundException, IOException {
        this(file, false);
    }

    public IniFile(File file, boolean caseSensitive) throws FileNotFoundException, IOException {
        this.caseSensitive = caseSensitive;
        this.file = file;
        this.read(file);
    }

    public IniFile(InputStream is) throws FileNotFoundException, IOException {
        this(is, false);
    }

    public IniFile(InputStream is, boolean caseSensitive) throws FileNotFoundException, IOException {
        this.caseSensitive = caseSensitive;
        this.read(is);
    }

    public void read(File file) throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(file);
        this.read(is);
    }

    public void read(InputStream is) throws FileNotFoundException, IOException {
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(is, charset));
        String currSectionName = null;
        Map ht1 = null;
        ht1 = this.caseSensitive ? new HashMap() : new NStringMap();
        int fileLen1 = 0;
        while (true) {
            char c;
            String s;
            if ((s = bufferedreader.readLine()) == null) {
                this.ht = ht1;
                this.fileLen = fileLen1;
                return;
            }
            if (s.length() <= 0 || (c = s.charAt(0)) == '#' || c == '!') continue;
            while (this.continueLine(s)) {
                String s1 = bufferedreader.readLine();
                if (s1 == null) {
                    s1 = new String("");
                }
                String s2 = s.substring(0, s.length() - 1);
                int k = 0;
                k = 0;
                while (k < s1.length()) {
                    if (" \t\r\n\f".indexOf(s1.charAt(k)) == -1) break;
                    ++k;
                }
                s1 = s1.substring(k, s1.length());
                s = new String(String.valueOf(s2) + s1);
            }
            int len = s.length();
            int i = 0;
            while (i < len) {
                if (" \t\r\n\f".indexOf(s.charAt(i)) == -1) break;
                ++i;
            }
            if (i == len) continue;
            fileLen1 += len;
            int j = len - 1;
            while (j >= 0) {
                if (" \t\r\n\f".indexOf(s.charAt(j)) == -1) break;
                --j;
            }
            if (s.charAt(i) == '[' && s.charAt(j) == ']') {
                currSectionName = this.loadConvert(s.substring(i + 1, j));
                Map p = (HashMap)ht1.get(currSectionName);
                if (p == null) {
                    p = this.caseSensitive ? new HashMap() : new NStringMap();
                }
                ht1.put(currSectionName, p);
                continue;
            }
            if (currSectionName == null) continue;
            int l = 0;
            while (l < len) {
                char c1 = s.charAt(l);
                if (c1 == '\\') {
                    ++l;
                } else if (c1 == '=') break;
                ++l;
            }
            String s3 = s.substring(0, l);
            String s4 = l >= len - 1 ? "" : s.substring(l + 1, len);
            s3 = this.loadConvert(s3).trim();
            s4 = this.loadConvert(s4);
            Map p = (Map)ht1.get(currSectionName);
            p.put(s3, s4);
        }
    }

    public boolean sectionExists(String section) {
        return this.ht.containsKey(section);
    }

    public boolean keyExists(String section, String key) {
        Object o = this.ht.get(section);
        if (o == null) {
            return false;
        }
        return ((Properties)o).containsKey(key);
    }

    public Set readSectionNames() {
        return this.ht.keySet();
    }

    public Map readSection(String section) {
        Object o = this.ht.get(section);
        if (o == null) {
            return null;
        }
        return (Map)o;
    }

    public Iterator readKeyNames(String section) {
        Object o = this.ht.get(section);
        if (o == null) {
            return null;
        }
        return ((Map)o).keySet().iterator();
    }

    public String readString(String section, String key) {
        Map p = this.readSection(section);
        if (p == null) {
            return null;
        }
        return (String)p.get(key);
    }

    public int readInt(String section, String key, int def) {
        String s = this.readString(section, key);
        if (s == null) {
            return def;
        }
        try {
            int i = Integer.parseInt(s.trim());
            return i;
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public double readDouble(String section, String key, double def) {
        String s = this.readString(section, key);
        if (s == null) {
            return def;
        }
        try {
            double d = Double.parseDouble(s.trim());
            return d;
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public boolean readBoolean(String section, String key, boolean def) {
        String s = this.readString(section, key);
        if (s == null) {
            return def;
        }
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes");
    }

    public Date readDate(String section, String key) throws ParseException {
        String s = this.readString(section, key);
        return DateTool.parseDate(s);
    }

    public Date readTime(String section, String key) throws ParseException {
        String s = this.readString(section, key);
        return DateTool.parseTime(s);
    }

    public Date readDateTime(String section, String key) throws ParseException {
        String s = this.readString(section, key);
        return DateTool.parseTimestamp(s);
    }

    public void addSection(String section) {
        if (this.ht.containsKey(section)) {
            throw new RuntimeException("section " + section + " already exists");
        }
        Map p = null;
        p = this.caseSensitive ? new HashMap() : new NStringMap();
        this.ht.put(section, p);
    }

    public void writeString(String section, String key, String value) {
        Map p = this.readSection(section);
        if (p == null) {
            return;
        }
        p.put(key, value);
    }

    public void writeInt(String section, String key, int value) {
        Map p = this.readSection(section);
        if (p == null) {
            return;
        }
        p.put(key, Integer.toString(value));
    }

    public void writeDouble(String section, String key, double value) {
        Map p = this.readSection(section);
        if (p == null) {
            return;
        }
        p.put(key, Double.toString(value));
    }

    public void writeDate(String section, String key, Date value) {
        Map p = this.readSection(section);
        if (p == null) {
            return;
        }
        p.put(key, DateTool.formatDate(value));
    }

    public void writeTime(String section, String key, Date value) {
        Map p = this.readSection(section);
        if (p == null) {
            return;
        }
        p.put(key, DateTool.formatTime(value));
    }

    public void writeDateTime(String section, String key, Date value) {
        Map p = this.readSection(section);
        if (p == null) {
            return;
        }
        p.put(key, DateTool.formatTimestamp(value));
    }

    public void setFileName(String fileName) {
        this.file = new File(fileName);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void save() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, charset);
        String s = this.toString(true);
        osw.write(s, 0, s.length());
        osw.close();
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean escape) {
        StringBuffer sb = new StringBuffer(this.fileLen);
        Iterator sections = this.ht.keySet().iterator();
        String linesep = System.getProperty("line.separator");
        while (sections.hasNext()) {
            String section = (String)sections.next();
            sb.append('[');
            sb.append(section);
            sb.append(']');
            sb.append(linesep);
            Map p = (Map)this.ht.get(section);
            Iterator iterator = p.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = (String)p.get(key);
                sb.append(escape ? Escape.add(key) : key);
                sb.append('=');
                sb.append(escape ? Escape.add(value) : value);
                sb.append(linesep);
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        IniFile ini = new IniFile("e:\\src\\ht\\bin\\config.ini");
        System.out.println(ini.readDate("DB", "date"));
        System.out.println(ini.readTime("db", "time"));
        System.out.println(ini.readDateTime("db", "datetime"));
        ini.addSection("xu");
        ini.writeDate("xu", "date", new Date());
        ini.writeString("xu", "dir", "c:\\winnt\\system");
        ini.setFileName("d:\\xu.ini");
        ini.save();
        System.out.println(ini);
    }
}

