/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;

public class IntArrayList
extends AbstractList
implements Serializable {
    private transient int[] _data = null;
    private int _size = 0;

    public IntArrayList() {
        this(8);
    }

    public IntArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity " + capacity);
        }
        this._data = new int[capacity];
    }

    public int capacity() {
        return this._data.length;
    }

    public int size() {
        return this._size;
    }

    public int getInt(int index) {
        this.checkRange(index);
        return this._data[index];
    }

    public boolean containsInt(int value) {
        return -1 != this.indexOfInt(value);
    }

    public int indexOfInt(int value) {
        int i = 0;
        while (i < this._size) {
            if (value == this._data[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOfInt(int value) {
        int i = this._size - 1;
        while (i >= 0) {
            if (value == this._data[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int setInt(int index, int value) {
        this.checkRange(index);
        int old = this._data[index];
        this._data[index] = value;
        return old;
    }

    public boolean addInt(int value) {
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = value;
        return true;
    }

    public void addInt(int index, int value) {
        this.checkRangeIncludingEndpoint(index);
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = value;
        ++this._size;
    }

    public void clear() {
        ++this.modCount;
        this._size = 0;
    }

    public int removeIntAt(int index) {
        this.checkRange(index);
        ++this.modCount;
        int oldval = this._data[index];
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public boolean removeInt(int value) {
        int index = this.indexOfInt(value);
        if (-1 == index) {
            return false;
        }
        this.removeIntAt(index);
        return true;
    }

    public void ensureCapacity(int mincap) {
        ++this.modCount;
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            int[] olddata = this._data;
            this._data = new int[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._size < this._data.length) {
            int[] olddata = this._data;
            this._data = new int[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        int i = 0;
        while (i < this._size) {
            out.writeInt(this._data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new int[in.readInt()];
        int i = 0;
        while (i < this._size) {
            this._data[i] = in.readInt();
            ++i;
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + index);
        }
    }

    public Object get(int index) {
        return new Integer(this.getInt(index));
    }

    public boolean contains(Object value) {
        return this.containsInt((Integer)value);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int indexOf(Object value) {
        return this.indexOfInt((Integer)value);
    }

    public int lastIndexOf(Object value) {
        return this.lastIndexOfInt((Integer)value);
    }

    public Object set(int index, Object value) {
        return new Integer(this.setInt(index, (Integer)value));
    }

    public boolean add(Object value) {
        return this.addInt((Integer)value);
    }

    public void add(int index, Object value) {
        this.addInt(index, (Integer)value);
    }

    public Object remove(int index) {
        return new Integer(this.removeIntAt(index));
    }

    public boolean remove(Object value) {
        return this.removeInt((Integer)value);
    }
}

