/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IntHashtable
implements Serializable,
Cloneable {
    private int[] keys;
    private Object[] objs;
    private int count;

    public IntHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.keys = new int[initialCapacity];
        this.objs = new Object[initialCapacity];
    }

    public IntHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashtable() {
        this(11, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Iterator keyIterator() {
        return new Iterator(this);
    }

    public java.util.Iterator valueIterator() {
        return new ValueIterator();
    }

    public Enumerator keys() {
        return new Enumerator(this);
    }

    public Enumeration elements() {
        return new ValueEnumerator();
    }

    public boolean contains(Object value) {
        Object[] objs = this.objs;
        if (value == null) {
            int i = 0;
            while (i < this.count) {
                if (objs[i] == null) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (value.equals(objs[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        int[] keys = this.keys;
        int i = 0;
        while (i < this.count) {
            if (keys[i] == key) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object get(int key) {
        int[] keys = this.keys;
        int i = 0;
        while (i < this.count) {
            if (keys[i] == key) {
                return this.objs[i];
            }
            ++i;
        }
        return null;
    }

    public Object put(int key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        int[] keys = this.keys;
        Object[] objs = this.objs;
        int i = 0;
        while (i < this.count) {
            if (keys[i] == key) {
                Object o = objs[i];
                objs[i] = value;
                return o;
            }
            ++i;
        }
        if (this.count >= keys.length) {
            int len = (int)((double)this.count * 1.3) + 1;
            this.keys = new int[len];
            this.objs = new Object[len];
            System.arraycopy(keys, 0, this.keys, 0, this.count);
            System.arraycopy(objs, 0, this.objs, 0, this.count);
        }
        this.keys[this.count] = key;
        this.objs[this.count] = value;
        ++this.count;
        return null;
    }

    public Object remove(int key) {
        int[] keys = this.keys;
        int i = 0;
        while (i < this.count) {
            if (keys[i] == key) {
                return this.removeEntry(i);
            }
            ++i;
        }
        return null;
    }

    private final void checkIndex(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("index must be >=0 and <" + this.count + " : " + index);
        }
    }

    public Object removeEntry(int index) {
        this.checkIndex(index);
        Object[] objs = this.objs;
        Object o = objs[index];
        System.arraycopy(this.keys, index + 1, this.keys, index, this.count - index - 1);
        System.arraycopy(objs, index + 1, objs, index, this.count - index - 1);
        --this.count;
        objs[this.count] = null;
        return o;
    }

    public void clear() {
        Object[] objs = this.objs;
        int i = 0;
        while (i < objs.length) {
            objs[i] = null;
            ++i;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            IntHashtable t = (IntHashtable)super.clone();
            t.keys = (int[])this.keys.clone();
            t.objs = (Object[])this.objs.clone();
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int getKey(int index) {
        this.checkIndex(index);
        return this.keys[index];
    }

    public Object getValue(int index) {
        this.checkIndex(index);
        return this.objs[index];
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        int[] keys = this.keys;
        Object[] objs = this.objs;
        int i = 0;
        while (i < this.count) {
            if (keys[i] >= 0) {
                buf.append(keys[i]).append('=').append(objs[i]);
                if (i < this.count - 1) {
                    buf.append(", ");
                }
            }
            ++i;
        }
        buf.append('}');
        return buf.toString();
    }

    public static void main(String[] args) {
        IntHashtable ih = new IntHashtable();
        ih.put(31, "this31");
        ih.put(3, "that3");
        ih.put(53, "there53");
        ih.put(11, "there11");
        ih.put(15, "there15");
        ih.put(10, "there10");
        ih.put(43, "there43");
        ih.put(98, "there98");
        System.out.println(ih);
        Iterator it = ih.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            System.out.println(String.valueOf(key) + "=" + ih.get(key));
            if (key != 15) continue;
            it.remove();
        }
        System.out.println("****" + ih.get(31) + "****");
        Enumerator enumerator = ih.keys();
        while (enumerator.hasMoreElements()) {
            int key = enumerator.nextElement();
            System.out.println(String.valueOf(key) + "=" + ih.get(key));
        }
    }

    public static class Enumerator {
        IntHashtable ih;
        int index = 0;

        Enumerator(IntHashtable ih) {
            this.ih = ih;
        }

        public boolean hasMoreElements() {
            return this.index < this.ih.count;
        }

        public int nextElement() {
            if (this.index < this.ih.count) {
                return this.ih.keys[this.index++];
            }
            throw new NoSuchElementException();
        }
    }

    public static class Iterator {
        IntHashtable ih;
        int index = 0;

        Iterator(IntHashtable ih) {
            this.ih = ih;
        }

        public boolean hasNext() {
            return this.index < this.ih.count;
        }

        public int next() {
            if (this.index < this.ih.count) {
                return this.ih.keys[this.index++];
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.index < 1) {
                throw new IllegalStateException();
            }
            --this.index;
            if (this.index < this.ih.count) {
                this.ih.removeEntry(this.index);
                return;
            }
            throw new NoSuchElementException();
        }
    }

    class ValueEnumerator
    implements Enumeration {
        int index = 0;

        ValueEnumerator() {
        }

        public boolean hasMoreElements() {
            return this.index < IntHashtable.this.count;
        }

        public Object nextElement() {
            if (this.index < IntHashtable.this.count) {
                return IntHashtable.this.objs[this.index++];
            }
            throw new NoSuchElementException();
        }
    }

    class ValueIterator
    implements java.util.Iterator {
        int index = 0;

        ValueIterator() {
        }

        public boolean hasNext() {
            return this.index < IntHashtable.this.count;
        }

        public Object next() {
            if (this.index < IntHashtable.this.count) {
                return IntHashtable.this.objs[this.index++];
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.index < 1) {
                throw new IllegalStateException();
            }
            --this.index;
            if (this.index < IntHashtable.this.count) {
                IntHashtable.this.removeEntry(this.index);
                return;
            }
            throw new NoSuchElementException();
        }
    }
}

