/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import com.runqian.base.util.Sentence;
import java.util.Map;

public final class MacroResolver {
    private int len = 0;
    private int idx = 0;
    private String str;
    private String token;
    private StringBuffer newStr;

    public MacroResolver(String str) {
        this.str = str;
        this.len = str == null ? -1 : str.length();
    }

    public boolean hasNext() {
        while (this.idx < this.len) {
            int tmp;
            char ch = this.str.charAt(this.idx);
            if (ch == '\'' || ch == '\"') {
                tmp = Sentence.scanQuotation(this.str, this.idx);
                if (tmp < 0) {
                    if (this.newStr != null) {
                        this.newStr.append(this.str.substring(this.idx));
                    }
                    this.idx = this.len;
                    this.token = null;
                    return false;
                }
                if (this.newStr != null) {
                    this.newStr.append(this.str.substring(this.idx, tmp + 1));
                }
                this.idx = tmp + 1;
                continue;
            }
            if (ch == '$') {
                if (this.idx < this.len && this.str.charAt(this.idx + 1) == '{') {
                    tmp = Sentence.scanBrace(this.str, this.idx + 1);
                    if (tmp < 0) {
                        if (this.newStr != null) {
                            this.newStr.append(this.str.substring(this.idx));
                        }
                        this.idx = this.len;
                        this.token = null;
                        return false;
                    }
                    if (this.newStr == null) {
                        this.newStr = new StringBuffer(this.len + 80);
                        this.newStr.append(this.str.substring(0, this.idx));
                    }
                    this.token = this.str.substring(this.idx + 2, tmp);
                    this.idx = tmp + 1;
                    return true;
                }
                ++this.idx;
                if (this.newStr == null) continue;
                this.newStr.append(ch);
                continue;
            }
            ++this.idx;
            if (this.newStr == null) continue;
            this.newStr.append(ch);
        }
        this.token = null;
        return false;
    }

    public String next() {
        return this.token;
    }

    public void setValue(String value) {
        if (value != null) {
            this.newStr.append(value);
        }
    }

    public String getResolvedStr() {
        return this.newStr == null ? this.str : this.newStr.toString();
    }

    public static String replaceMacros(String text, Map macros) {
        MacroResolver mr = new MacroResolver(text);
        while (mr.hasNext()) {
            String macroName = mr.next().trim();
            mr.setValue((String)macros.get(macroName));
        }
        return mr.getResolvedStr();
    }

    public static String onlyRemoveBrace(String text) {
        MacroResolver mr = new MacroResolver(text);
        while (mr.hasNext()) {
            String macroName = mr.next();
            mr.setValue(macroName);
        }
        return mr.getResolvedStr();
    }

    public static int getLengthExceptMacros(String text) {
        MacroResolver mr = new MacroResolver(text);
        while (mr.hasNext()) {
            mr.next();
            mr.setValue("");
        }
        try {
            int i = mr.getResolvedStr().getBytes("GB2312").length;
            return i;
        }
        catch (Exception e) {
            throw new RuntimeException("\u53d6GB2312\u5b57\u7b26\u4e32\u4e2d\u7684\u5b57\u8282\u7801\u957f\u5ea6\u65f6\u9519");
        }
    }

    public static void main(String[] args) {
        String s = "${a} select $abc + 1} from tab where $abc='${1}'";
        MacroResolver sr = new MacroResolver(s);
        System.out.println(s);
        while (sr.hasNext()) {
            String m = sr.next();
            System.out.println(m);
            if (!m.equals("a")) continue;
            sr.setValue("A");
        }
        String s1 = sr.getResolvedStr();
        System.out.println(s1);
        System.out.println(s == s1);
        s = "abc${\u001b\u0001}efg";
        System.out.println(MacroResolver.onlyRemoveBrace(s));
        System.out.println(MacroResolver.getLengthExceptMacros(s));
    }
}

