/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.Escape;
import com.runqian.base.util.Sentence;

public class Macros {
    String[] names = new String[8];
    String[] titles = new String[8];
    String[] values = new String[8];
    int count = 0;

    public Macros() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    void expandTo(int size) {
        if (size > this.names.length) {
            String[] tmp = this.names;
            this.names = new String[size + 8];
            if (tmp != null) {
                System.arraycopy(tmp, 0, this.names, 0, this.count);
            }
            tmp = this.titles;
            this.titles = new String[size + 8];
            if (tmp != null) {
                System.arraycopy(tmp, 0, this.titles, 0, this.count);
            }
            tmp = this.values;
            this.values = new String[size + 8];
            if (tmp != null) {
                System.arraycopy(tmp, 0, this.values, 0, this.count);
            }
        }
    }

    public Macros(String macrosStr) {
        int i = 0;
        ArgumentTokenizer at = new ArgumentTokenizer(macrosStr.trim(), ';');
        while (at.hasNext()) {
            String one = at.next();
            String name = "";
            String title = "";
            String value = "";
            int pos = one.indexOf(61);
            if (pos < 0) {
                name = one;
            } else {
                name = one.substring(0, pos);
                if (pos < one.length() - 1) {
                    int pos1 = Sentence.indexOf(one, ",", pos + 1, 0);
                    if (pos1 < 0) {
                        title = Escape.remove(one.substring(pos + 1));
                    } else {
                        title = Escape.remove(one.substring(pos + 1, pos1));
                        value = Escape.remove(one.substring(pos1 + 1));
                    }
                }
            }
            name = name.trim();
            if (name.length() == 0) continue;
            this.expandTo(i + 1);
            this.names[i] = name;
            this.titles[i] = title;
            this.values[i] = value;
            ++i;
            ++this.count;
        }
    }

    public String getName(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException("index" + index + " out of arguments' number");
        }
        return this.names[index];
    }

    public String getTitle(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException("index" + index + " out of arguments' number");
        }
        return this.titles[index];
    }

    public String getValue(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException("index" + index + " out of arguments' number");
        }
        return this.values[index];
    }

    public String getTitle(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        int i = 0;
        while (i < this.count) {
            if (name.equals(this.names[i])) {
                return this.titles[i];
            }
            ++i;
        }
        return null;
    }

    public String getValue(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        int i = 0;
        while (i < this.count) {
            if (name.equals(this.names[i])) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public void set(int index, String name, String title, String value) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("index" + index + " out of arguments' number");
        }
        if (index >= this.count) {
            this.expandTo(index + 1);
        }
        if (name == null) {
            return;
        }
        if ((name = name.trim()).length() == 0) {
            return;
        }
        this.names[index] = name;
        this.titles[index] = title == null ? "" : title;
        String string = this.values[index] = value == null ? "" : value;
        if (index >= this.count) {
            this.count = index + 1;
        }
    }

    public void set(String name, String title, String value) {
        if (name == null) {
            return;
        }
        if ((name = name.trim()).length() == 0) {
            return;
        }
        int i = 0;
        while (i < this.names.length) {
            if (name.equalsIgnoreCase(this.names[i])) {
                this.values[i] = value;
                this.titles[i] = title;
                return;
            }
            ++i;
        }
        this.add(name, title, value);
    }

    public void add(String name, String title, String value) {
        this.set(this.count, name, title, value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32 * this.count);
        int i = 0;
        while (i < this.count) {
            sb.append(this.names[i]).append('=');
            sb.append(Escape.add(this.titles[i], "\t\r\n'\";,"));
            sb.append(',');
            sb.append(Escape.add(this.values[i], "\t\r\n'\";,"));
            if (i < this.count - 1) {
                sb.append(';');
            }
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        Macros ms = new Macros();
        ms.add("x", null, null);
        ms.add("y", null, "abc\\");
        String s = ms.toString();
        System.out.println(s);
        ms = new Macros("x=,;y=,abc\\;");
        System.out.println(ms);
    }
}

