/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import java.io.Serializable;

public class Matrix
implements Serializable,
Cloneable {
    int rowNum;
    int colNum;
    Object[] data;

    public Matrix() {
        this(20, 10);
    }

    public Matrix(int rowNum, int colNum) {
        if (rowNum < 0) {
            throw new IllegalArgumentException("number of rows " + rowNum + " <= 0");
        }
        if (colNum < 0) {
            throw new IllegalArgumentException("number of columns " + colNum + " <= 0");
        }
        this.rowNum = rowNum;
        this.colNum = colNum;
        this.data = new Object[rowNum][colNum];
    }

    private boolean ensureCapacity(int rowCapacity, int colCapacity) {
        int oldColCapacity = this.getColCapacity();
        int oldRowCapacity = this.data.length;
        if (rowCapacity > oldRowCapacity) {
            Object[] oldData = this.data;
            this.data = new Object[rowCapacity];
            if (colCapacity <= oldColCapacity) {
                System.arraycopy(oldData, 0, this.data, 0, this.rowNum);
                int i = this.rowNum;
                while (i < rowCapacity) {
                    this.data[i] = new Object[oldColCapacity];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < rowCapacity) {
                    this.data[i] = new Object[colCapacity];
                    if (i < this.rowNum) {
                        System.arraycopy(oldData[i], 0, this.data[i], 0, this.colNum);
                    }
                    ++i;
                }
            }
        } else if (colCapacity <= oldColCapacity) {
            if (this.rowNum >= rowCapacity) {
                return false;
            }
            int i = this.rowNum;
            while (i < rowCapacity) {
                this.data[i] = new Object[oldColCapacity];
                ++i;
            }
        } else {
            int max = rowCapacity > this.rowNum ? rowCapacity : this.rowNum;
            int i = 0;
            while (i < max) {
                Object oldData = this.data[i];
                this.data[i] = new Object[colCapacity];
                if (i < this.rowNum) {
                    System.arraycopy(oldData, 0, this.data[i], 0, this.colNum);
                }
                ++i;
            }
        }
        return true;
    }

    private static void fill(Object[] o, int from, int to, Object val) {
        int i = from;
        while (i < to) {
            o[i] = val;
            ++i;
        }
    }

    private int getColCapacity() {
        return this.data.length == 0 ? this.colNum : ((Object[])this.data[0]).length;
    }

    public boolean setSize(int newRowNum, int newColNum) {
        boolean b = this.ensureCapacity(newRowNum, newColNum);
        if (this.colNum > newColNum) {
            int min = this.rowNum <= newRowNum ? this.rowNum : newRowNum;
            int i = 0;
            while (i < min) {
                Matrix.fill((Object[])this.data[i], newColNum, this.colNum, null);
                ++i;
            }
        }
        this.colNum = newColNum;
        if (this.rowNum > newRowNum) {
            Matrix.fill(this.data, newRowNum, this.rowNum, null);
        }
        this.rowNum = newRowNum;
        return b;
    }

    public void trimToSize() {
        Object[] oldData = this.data;
        this.data = new Object[this.rowNum][this.colNum];
        int i = 0;
        while (i < this.rowNum) {
            System.arraycopy(oldData[i], 0, this.data[i], 0, this.colNum);
            ++i;
        }
    }

    public int trimNullTrailCol() {
        int nullColNum = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.rowNum) {
            int tmp = 0;
            int j = this.colNum - 1;
            while (j >= 0) {
                if (this.get(i, j) != null) break;
                ++tmp;
                --j;
            }
            if (tmp < nullColNum) {
                nullColNum = tmp;
            }
            if (nullColNum == 0) {
                return 0;
            }
            ++i;
        }
        this.colNum -= nullColNum;
        return nullColNum;
    }

    public void insertRow(int row, int insertedRowNum) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("row: " + row + ", rowNum" + this.rowNum);
        }
        if (insertedRowNum < 1) {
            throw new IllegalArgumentException("insertedRowNum: " + insertedRowNum);
        }
        if (row > this.rowNum) {
            row = this.rowNum;
        }
        int newRow = row + insertedRowNum;
        int moved = this.rowNum - row;
        int oldCapacity = this.data.length;
        int minCapacity = this.rowNum + insertedRowNum;
        int colCapacity = this.getColCapacity();
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            Object[] oldData = this.data;
            this.data = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.data, 0, row);
            System.arraycopy(oldData, row, this.data, newRow, moved);
            int i = row;
            while (i < newRow) {
                this.data[i] = new Object[colCapacity];
                ++i;
            }
        } else {
            System.arraycopy(this.data, row, this.data, newRow, moved);
            int i = row;
            while (i < newRow) {
                this.data[i] = new Object[colCapacity];
                ++i;
            }
        }
        this.rowNum = minCapacity;
    }

    public void insertRow(int row) {
        this.insertRow(row, 1);
    }

    public void addRow(int addedRowNum) {
        this.insertRow(this.rowNum, addedRowNum);
    }

    public void addRow() {
        this.insertRow(this.rowNum, 1);
    }

    public void removeRow(int beginRow, int endRow) {
        int moved;
        if (beginRow >= endRow) {
            return;
        }
        if (beginRow < 0) {
            throw new IndexOutOfBoundsException("beginRow: " + beginRow + ", endRow" + endRow);
        }
        if (endRow > this.rowNum) {
            endRow = this.rowNum;
        }
        if ((moved = this.rowNum - endRow) < 0) {
            return;
        }
        System.arraycopy(this.data, endRow, this.data, beginRow, moved);
        int newRowNum = this.rowNum - (endRow - beginRow);
        Matrix.fill(this.data, newRowNum, this.rowNum, null);
        this.rowNum = newRowNum;
    }

    public void removeRow(int row) {
        this.removeRow(row, row + 1);
    }

    public int getRowCount() {
        return this.rowNum;
    }

    public int getRow() {
        return this.rowNum;
    }

    public void insertColumn(int beginRow, int endRow, int col, int insertedColNum) {
        if (col < 0) {
            throw new IndexOutOfBoundsException("col: " + col + ", colNum: " + this.colNum);
        }
        if (insertedColNum < 1) {
            throw new IllegalArgumentException("insertedColNum: " + insertedColNum);
        }
        if (beginRow < 0) {
            throw new IndexOutOfBoundsException("beginRow: " + beginRow + "must be >= 0");
        }
        if (endRow >= this.rowNum) {
            throw new IndexOutOfBoundsException("endRow: " + endRow + ", rowNum: " + this.rowNum);
        }
        if (endRow < beginRow) {
            return;
        }
        if (col > this.colNum) {
            col = this.colNum;
        }
        int newCol = col + insertedColNum;
        int moved = this.colNum - col;
        int minCapacity = this.colNum + insertedColNum;
        int oldCapacity = this.getColCapacity();
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            int i = 0;
            while (i < this.rowNum) {
                Object[] oldColData = (Object[])this.data[i];
                this.data[i] = new Object[newCapacity];
                if (i >= beginRow && i <= endRow) {
                    System.arraycopy(oldColData, 0, this.data[i], 0, col);
                    System.arraycopy(oldColData, col, this.data[i], newCol, moved);
                } else {
                    System.arraycopy(oldColData, 0, this.data[i], 0, oldColData.length);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.rowNum) {
                if (i >= beginRow && i < endRow) {
                    System.arraycopy(this.data[i], col, this.data[i], newCol, moved);
                    Matrix.fill((Object[])this.data[i], col, newCol, null);
                }
                ++i;
            }
        }
        this.colNum = minCapacity;
    }

    public void insertColumn(int col, int insertedColNum) {
        this.insertColumn(0, this.rowNum - 1, col, insertedColNum);
    }

    public void insertCol(int col, int insertedColNum) {
        this.insertColumn(col, insertedColNum);
    }

    public void insertColumn(int col) {
        if (col < 0) {
            throw new IndexOutOfBoundsException("col: " + col + ", colNum: " + this.colNum);
        }
        if (col > this.colNum) {
            col = this.colNum;
        }
        int moved = this.colNum - col;
        int minCapacity = this.colNum + 1;
        int oldCapacity = this.getColCapacity();
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            int i = 0;
            while (i < this.rowNum) {
                Object[] oldColData = (Object[])this.data[i];
                this.data[i] = new Object[newCapacity];
                System.arraycopy(oldColData, 0, this.data[i], 0, col);
                System.arraycopy(oldColData, col, this.data[i], col + 1, moved);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.rowNum) {
                System.arraycopy(this.data[i], col, this.data[i], col + 1, moved);
                Matrix.fill((Object[])this.data[i], col, col + 1, null);
                ++i;
            }
        }
        this.colNum = minCapacity;
    }

    public void insertCol(int col) {
        this.insertColumn(col, 1);
    }

    public void addColumn() {
        this.insertColumn(this.colNum, 1);
    }

    public void addColumn(int addedColNum) {
        this.insertColumn(this.colNum, addedColNum);
    }

    public void addCol() {
        this.insertColumn(this.colNum, 1);
    }

    public void addCol(int addedColNum) {
        this.insertColumn(this.colNum, addedColNum);
    }

    public void removeColumn(int beginCol, int endCol) {
        int moved;
        if (beginCol >= endCol) {
            return;
        }
        if (beginCol < 0) {
            throw new IndexOutOfBoundsException("beginCol: " + beginCol + ", endCol: " + endCol);
        }
        if (endCol > this.colNum) {
            endCol = this.colNum;
        }
        if ((moved = this.colNum - endCol) < 0) {
            return;
        }
        int newColNum = this.colNum - (endCol - beginCol);
        int i = 0;
        while (i < this.rowNum) {
            if (this.data[i] != null) {
                if (endCol < this.colNum) {
                    System.arraycopy(this.data[i], endCol, this.data[i], beginCol, moved);
                }
                Matrix.fill((Object[])this.data[i], newColNum, this.colNum, null);
            }
            ++i;
        }
        this.colNum = newColNum;
    }

    public void removeCol(int beginCol, int endCol) {
        this.removeColumn(beginCol, endCol);
    }

    public void removeColumn(int col) {
        this.removeColumn(col, col + 1);
    }

    public void removeCol(int col) {
        this.removeColumn(col, col + 1);
    }

    public void clear(int beginRow, int endRow, int beginCol, int endCol) {
        if (beginRow < 0) {
            beginRow = 0;
        }
        if (endRow > this.rowNum) {
            endRow = this.rowNum;
        }
        if (beginCol < 0) {
            beginCol = 0;
        }
        if (endCol > this.colNum) {
            endCol = this.colNum;
        }
        int i = beginRow;
        while (i < endRow) {
            Matrix.fill((Object[])this.data[i], beginCol, endCol, null);
            ++i;
        }
    }

    public void clear() {
        this.clear(0, this.rowNum, 0, this.colNum);
    }

    public void clearRow(int beginRow, int endRow) {
        this.clear(beginRow, endRow, 0, this.colNum);
    }

    public void clearCol(int beginCol, int endCol) {
        this.clear(0, this.rowNum, beginCol, endCol);
    }

    public int getColCount() {
        return this.colNum;
    }

    public int getColumn() {
        return this.colNum;
    }

    public Object get(int row, int col) {
        if (row < 0 || row >= this.rowNum) {
            throw new IndexOutOfBoundsException("row[" + row + "] out of bounds[" + this.rowNum + "]");
        }
        if (col < 0 || col >= this.colNum) {
            throw new IndexOutOfBoundsException("col[" + col + "] out of bounds[" + this.colNum + "]");
        }
        return ((Object[])this.data[row])[col];
    }

    public Object set(int row, int col, Object element) {
        if (row < 0 || row >= this.rowNum) {
            throw new IndexOutOfBoundsException("row[" + row + "] out of bounds[" + this.rowNum + "]");
        }
        if (col < 0 || col >= this.colNum) {
            throw new IndexOutOfBoundsException("col[" + col + "] out of bounds[" + this.colNum + "]");
        }
        Object[] colData = (Object[])this.data[row];
        Object o = colData[col];
        colData[col] = element;
        return o;
    }

    String toString(boolean all) {
        StringBuffer sb = new StringBuffer(4096);
        int n1 = this.rowNum;
        if (all) {
            n1 = this.data.length;
        }
        int n2 = this.colNum;
        if (all && this.data.length > 0) {
            n2 = ((Object[])this.data[0]).length;
        }
        int row = 0;
        while (row < n1) {
            sb.append(" | ");
            Object[] o = (Object[])this.data[row];
            if (o == null) {
                sb.append(" ---------------------------- |");
            } else {
                int col = 0;
                while (col < n2) {
                    sb.append(o[col]).append(" | ");
                    ++col;
                }
            }
            sb.append("\n");
            ++row;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public Object clone() {
        Matrix m = new Matrix(this.rowNum, this.colNum);
        int i = 0;
        while (i < this.rowNum) {
            System.arraycopy(this.data[i], 0, m.data[i], 0, this.colNum);
            ++i;
        }
        return m;
    }

    public static void main(String[] args) {
        Matrix m = new Matrix(3, 3);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                m.set(i, j, String.valueOf(i) + "," + j);
                ++j;
            }
            ++i;
        }
        m.insertColumn(1, 1, 1, 2);
        System.out.println(m);
        m.insertColumn(2, 1);
        System.out.println(m);
        m.insertRow(2, 2);
        System.out.println(m);
        m.removeColumn(3);
        System.out.println("num = " + m.getRow() + "," + m.getColumn());
        System.out.println("len = " + m.data.length + "," + ((Object[])m.data[0]).length);
        System.out.println(m);
        m.removeRow(2, 3);
        System.out.println("num = " + m.getRow() + "," + m.getColumn());
        System.out.println("len = " + m.data.length + "," + ((Object[])m.data[0]).length);
        System.out.println(m);
        Matrix m1 = (Matrix)m.clone();
        System.out.println("clone: ");
        System.out.println(m1);
        m.set(0, 0, "clone");
        System.out.println("set");
        System.out.println(m);
        System.out.println(m1);
        System.out.println(m.toString(true));
        m.trimToSize();
        System.out.println(m.toString(true));
        System.out.println("ensure");
        System.out.println(m.ensureCapacity(4, 3));
        System.out.println("set size(5,5) = " + m.setSize(5, 5));
        System.out.println(m.toString(true));
        m.set(4, 4, "xxxxx");
        System.out.println(m.toString(true));
        System.out.println(m.toString());
        System.out.println("set size(3,2) = " + m.setSize(3, 2));
        System.out.println(m.toString(true));
        System.out.println(m.toString());
        System.out.println("set size(4,4) = " + m.setSize(4, 4));
        System.out.println(m.toString(true));
        System.out.println(m.toString());
        System.out.println("trimNullTrailCol() = " + m.trimNullTrailCol());
        System.out.println(m.toString(true));
        System.out.println(m.toString());
    }
}

