/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import java.util.Arrays;

public class Matrix1 {
    int colNum;
    Object[] data;

    public Matrix1() {
        this(20, 10);
    }

    public Matrix1(int rowNum, int colNum) {
        this.colNum = colNum;
        this.data = new Object[rowNum][colNum];
    }

    public void insertRow(int row, int insertedRowNum) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("row: " + row + ", rowNum: " + this.data.length);
        }
        if (insertedRowNum < 1) {
            throw new IllegalArgumentException("insertedRowNum: " + insertedRowNum);
        }
        if (row > this.data.length) {
            row = this.data.length;
        }
        Object[] oldData = this.data;
        this.data = new Object[this.data.length + insertedRowNum];
        System.arraycopy(oldData, 0, this.data, 0, row);
        System.arraycopy(oldData, row, this.data, row + insertedRowNum, oldData.length - row);
    }

    public void insertRow(int row) {
        this.insertRow(row, 1);
    }

    public void addRow(int insertedRowNum) {
        this.insertRow(this.data.length, insertedRowNum);
    }

    public void addRow() {
        this.addRow(1);
    }

    public void removeRow(int beginRow, int endRow) {
        if (beginRow >= endRow) {
            return;
        }
        if (beginRow < 0) {
            throw new IndexOutOfBoundsException("beginRow: " + beginRow);
        }
        if (endRow >= this.data.length) {
            throw new IndexOutOfBoundsException("endRow: " + this.data.length);
        }
        Object[] oldData = this.data;
        int newRowNum = this.data.length - (endRow - beginRow);
        this.data = new Object[newRowNum];
        System.arraycopy(oldData, 0, this.data, 0, beginRow);
        System.arraycopy(oldData, endRow, this.data, beginRow, oldData.length - endRow);
    }

    public void removeRow(int row) {
        this.removeRow(row, 1);
    }

    public void insertColumn(int beginRow, int endRow, int col, int insertedColNum) {
        if (endRow < beginRow) {
            return;
        }
        if (beginRow < 0) {
            throw new IndexOutOfBoundsException("beginRow: " + beginRow + "must be >= 0");
        }
        if (endRow >= this.data.length) {
            throw new IndexOutOfBoundsException("endRow: " + endRow + ", rowNum: " + this.data.length);
        }
        if (col < 0) {
            throw new IndexOutOfBoundsException("col: " + col + ", colNum: " + this.colNum);
        }
        if (insertedColNum < 1) {
            throw new IllegalArgumentException("insertedColNum: " + insertedColNum);
        }
        if (col > this.colNum) {
            col = this.colNum;
        }
        int i = beginRow;
        while (i <= endRow) {
            int len;
            Object[] rowData = (Object[])this.data[i];
            if (rowData.length > col) {
                len = rowData.length + insertedColNum;
                this.data[i] = new Object[len];
                System.arraycopy(rowData, 0, this.data[i], 0, col);
                System.arraycopy(rowData, col, this.data[i], col + insertedColNum, rowData.length - col);
                if (len > this.colNum) {
                    this.colNum = len;
                }
            } else {
                len = col + insertedColNum;
                this.data[i] = new Object[len];
                System.arraycopy(rowData, 0, this.data[i], 0, rowData.length);
                if (len > this.colNum) {
                    this.colNum = len;
                }
            }
            ++i;
        }
    }

    public void insertColumn(int col, int insertedColNum) {
        this.insertColumn(0, this.data.length - 1, col, insertedColNum);
    }

    public void insertColumn(int col) {
        this.insertColumn(col, 1);
    }

    public void addColumn(int addedColNum) {
        this.insertColumn(this.colNum, addedColNum);
    }

    public void addColumn() {
        this.addColumn(1);
    }

    public void removeColumn(int beginCol, int endCol) {
        if (beginCol >= endCol) {
            return;
        }
        if (beginCol < 0) {
            throw new IndexOutOfBoundsException("beginCol: " + beginCol + "must be >= 0");
        }
        if (endCol >= this.colNum) {
            throw new IndexOutOfBoundsException("endCol: " + endCol + ", colNum: " + this.colNum);
        }
        int newColNum = this.colNum - (endCol - beginCol);
        int i = 0;
        while (i < this.data.length) {
            Object[] rowData = (Object[])this.data[i];
            if (rowData.length >= endCol) {
                if (rowData.length > newColNum) {
                    this.data[i] = new Object[newColNum];
                    System.arraycopy(rowData, 0, this.data[i], 0, beginCol);
                    System.arraycopy(rowData, endCol, this.data[i], beginCol, rowData.length - endCol);
                } else {
                    System.arraycopy(rowData, endCol, this.data[i], beginCol, rowData.length - endCol);
                    Arrays.fill(rowData, rowData.length - (endCol - beginCol), rowData.length, null);
                }
            } else if (rowData.length > beginCol && rowData.length < endCol) {
                if (rowData.length > newColNum) {
                    this.data[i] = new Object[newColNum];
                    System.arraycopy(rowData, 0, this.data[i], 0, beginCol);
                } else {
                    Arrays.fill(rowData, beginCol, rowData.length, null);
                }
            }
            ++i;
        }
        this.colNum = newColNum;
    }

    public void setRowCount(int newRowNum) {
        if (newRowNum > this.data.length) {
            this.addRow(newRowNum - this.data.length);
        } else if (newRowNum < this.data.length) {
            this.removeRow(newRowNum, this.data.length - newRowNum);
        }
    }

    public void setColCount(int newColNum) {
        if (newColNum > this.colNum) {
            this.addColumn(newColNum - this.colNum);
        } else if (newColNum < this.colNum) {
            this.removeColumn(newColNum, this.colNum - newColNum);
        }
    }

    public int getRowCount() {
        return this.data.length;
    }

    public int getColCount() {
        return this.colNum;
    }

    public Object get(int row, int col) {
        if (row < 0 || row >= this.data.length) {
            throw new IndexOutOfBoundsException("row: " + row + ", rowNum: " + this.data.length);
        }
        if (col < 0 || col >= this.colNum) {
            throw new IndexOutOfBoundsException("col: " + col + ", colNum: " + this.colNum);
        }
        Object[] rowData = (Object[])this.data[row];
        if (rowData == null) {
            return null;
        }
        if (col >= rowData.length) {
            return null;
        }
        return rowData[col];
    }

    public Object set(int row, int col, Object o) {
        if (row < 0 || row >= this.data.length) {
            throw new IndexOutOfBoundsException("row: " + row + ", rowNum: " + this.data.length);
        }
        if (col < 0 || col >= this.colNum) {
            throw new IndexOutOfBoundsException("col: " + col + ", colNum: " + this.colNum);
        }
        Object[] rowData = (Object[])this.data[row];
        Object old = null;
        if (rowData == null || rowData.length < col) {
            Object[] v = new Object[this.colNum];
            if (rowData != null) {
                System.arraycopy(rowData, 0, v, 0, rowData.length);
            }
            v[col] = o;
            this.data[row] = v;
        } else {
            old = rowData[col];
            rowData[col] = o;
        }
        return old;
    }

    public void clear() {
        int i = 0;
        while (i < this.data.length) {
            Object[] rowData = (Object[])this.data[i];
            if (rowData != null) {
                int j = 0;
                while (j < rowData.length) {
                    rowData[j] = null;
                    ++j;
                }
            }
            ++i;
        }
    }

    public void clear(int beginRow, int endRow, int beginCol, int endCol) {
        if (beginRow >= endRow || beginCol >= endCol) {
            return;
        }
        if (beginRow < 0) {
            throw new IndexOutOfBoundsException("beginRow: " + beginRow);
        }
        if (endRow > this.data.length) {
            throw new IndexOutOfBoundsException("endRow: " + endRow + ", rowNum: " + this.data.length);
        }
        if (beginCol < 0) {
            throw new IndexOutOfBoundsException("beginCol: " + beginCol);
        }
        if (endCol > this.colNum) {
            throw new IndexOutOfBoundsException("endCol: " + endCol + ", colNum: " + this.colNum);
        }
        int i = beginRow;
        while (i < endRow) {
            Object[] rowData = (Object[])this.data[i];
            if (rowData != null) {
                int end = endCol <= rowData.length ? endCol : rowData.length;
                int j = beginCol;
                while (j < end) {
                    rowData[j] = null;
                    ++j;
                }
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.data.length * this.colNum * 10);
        int i = 0;
        while (i < this.data.length) {
            int j;
            Object[] rowData = (Object[])this.data[i];
            if (rowData == null) {
                j = 0;
                while (j < this.colNum) {
                    sb.append("* | ");
                    ++j;
                }
            } else {
                j = 0;
                while (j < rowData.length) {
                    sb.append(rowData[j]).append(" | ");
                    ++j;
                }
                j = rowData.length;
                while (j < this.colNum) {
                    sb.append("* | ");
                    ++j;
                }
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        Matrix1 m = new Matrix1(3, 3);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                m.set(i, j, String.valueOf(i) + "," + j);
                ++j;
            }
            ++i;
        }
        System.out.println(m);
        m.insertColumn(1, 1, 1, 2);
        System.out.println(m);
        m.insertRow(1, 1);
        System.out.println(m);
        m.set(1, 2, "set");
        System.out.println(m);
        m.removeColumn(2, 4);
        System.out.println(m);
    }
}

