/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class NStringMap
implements Map,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    static final String NULL_KEY = new String("");
    private transient Set entrySet = null;
    volatile transient Set keySet = null;
    volatile transient Collection values = null;

    public NStringMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
    }

    public NStringMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public NStringMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
    }

    public NStringMap(Map m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f);
        this.putAllForCreate(m);
    }

    static String maskNull(Object key) {
        return key == null ? NULL_KEY : (String)key;
    }

    static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    static int hash(String x) {
        int h = 0;
        int i = 0;
        while (i < x.length()) {
            h = 31 * h + Character.toLowerCase(x.charAt(i));
            ++i;
        }
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    static boolean eq(Object x, Object y) {
        return x == y || ((String)x).equalsIgnoreCase((String)y);
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object get(Object key) {
        if (key != null && !(key instanceof String)) {
            throw new IllegalArgumentException("key must be String");
        }
        String k = NStringMap.maskNull(key);
        int hash = NStringMap.hash(k);
        int i = NStringMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && NStringMap.eq(k, e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return e;
    }

    public boolean containsKey(Object key) {
        if (key != null && !(key instanceof String)) {
            throw new IllegalArgumentException("key must be String");
        }
        String k = NStringMap.maskNull(key);
        int hash = NStringMap.hash(k);
        int i = NStringMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && NStringMap.eq(k, e.key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    Entry getEntry(Object key) {
        String k = NStringMap.maskNull(key);
        int hash = NStringMap.hash(k);
        int i = NStringMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (!(e == null || e.hash == hash && NStringMap.eq(k, e.key))) {
            e = e.next;
        }
        return e;
    }

    public Object put(Object key, Object value) {
        if (key != null && !(key instanceof String)) {
            throw new IllegalArgumentException("key must be String");
        }
        String k = NStringMap.maskNull(key);
        int hash = NStringMap.hash(k);
        int i = NStringMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && NStringMap.eq(k, e.key)) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, k, value, i);
        return null;
    }

    private void putForCreate(Object key, Object value) {
        String k = NStringMap.maskNull(key);
        int hash = NStringMap.hash(k);
        int i = NStringMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.hash == hash && NStringMap.eq(k, e.key)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, k, value, i);
    }

    void putAllForCreate(Map m) {
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.putForCreate(e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (this.size < this.threshold || oldCapacity > newCapacity) {
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        int j = 0;
        while (j < src.length) {
            Entry e = src[j];
            if (e != null) {
                Entry next;
                src[j] = null;
                do {
                    next = e.next;
                    int i = NStringMap.indexFor(e.hash, newCapacity);
                    e.next = newTable[i];
                    newTable[i] = e;
                } while ((e = next) != null);
            }
            ++j;
        }
    }

    public void putAll(Map t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            int capacity = this.table.length;
            while (capacity < n) {
                capacity <<= 1;
            }
            this.resize(capacity);
        }
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            if (key != null && !(key instanceof String)) {
                key = key.toString();
            }
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        if (key != null && !(key instanceof String)) {
            throw new IllegalArgumentException("key must be String");
        }
        Entry e = this.removeEntryForKey(key);
        return e == null ? e : e.value;
    }

    Entry removeEntryForKey(Object key) {
        Entry prev;
        if (key != null && !(key instanceof String)) {
            throw new IllegalArgumentException("key must be String");
        }
        String k = NStringMap.maskNull(key);
        int hash = NStringMap.hash(k);
        int i = NStringMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && NStringMap.eq(k, e.key)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    Entry removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        String k = NStringMap.maskNull(entry.getKey());
        int hash = NStringMap.hash(k);
        int i = NStringMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    public void clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            tab[i] = null;
            ++i;
        }
        this.size = 0;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            Entry[] tab = this.table;
            int i = 0;
            while (i < tab.length) {
                Entry e = tab[i];
                while (e != null) {
                    if (e.value == null) {
                        return true;
                    }
                    e = e.next;
                }
                ++i;
            }
            return false;
        }
        Entry[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            Entry e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Entry e = (Entry)i.next();
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        Iterator i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Entry e = (Entry)i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            buf.append((key == this ? "(this Map)" : key) + "=" + (value == this ? "(this Map)" : value));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public Object clone() {
        NStringMap result = null;
        try {
            result = (NStringMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.putAllForCreate(this);
        return result;
    }

    void addEntry(int hash, Object key, Object value, int bucketIndex) {
        this.table[bucketIndex] = new Entry(hash, key, value, this.table[bucketIndex]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, Object key, Object value, int bucketIndex) {
        this.table[bucketIndex] = new Entry(hash, key, value, this.table[bucketIndex]);
        ++this.size;
    }

    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        int size = s.readInt();
        int i = 0;
        while (i < size) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.putForCreate(key, value);
            ++i;
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public static void main(String[] args) {
        NStringMap map = new NStringMap();
        map.put("Xu", "this31");
        map.put("Xu", "that3");
        map.put("xU", "there53");
        map.put((Object)null, "dfsfds");
        System.out.println(map);
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            System.out.println(e.getKey() + "=" + e.getValue());
        }
    }

    static class Entry
    implements Map.Entry {
        final Object key;
        Object value;
        final int hash;
        Entry next;

        Entry(int h, Object k, Object v, Entry n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public Object getKey() {
            return NStringMap.unmaskNull(this.key);
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        public int hashCode() {
            return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private abstract class HashIterator
    implements Iterator {
        Entry next;
        int expectedModCount;
        int index;
        Entry current;

        HashIterator() {
            this.expectedModCount = NStringMap.this.modCount;
            Entry[] t = NStringMap.this.table;
            int i = t.length;
            Entry n = null;
            if (NStringMap.this.size != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.index = i;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        Entry nextEntry() {
            if (NStringMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            Entry n = e.next;
            Entry[] t = NStringMap.this.table;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            this.current = e;
            return this.current;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (NStringMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            NStringMap.this.removeEntryForKey(k);
            this.expectedModCount = NStringMap.this.modCount;
        }
    }

    private class ValueIterator
    extends HashIterator {
        ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends HashIterator {
        KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class EntryIterator
    extends HashIterator {
        EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class KeySet
    extends AbstractSet {
        KeySet() {
        }

        public Iterator iterator() {
            return NStringMap.this.newKeyIterator();
        }

        public int size() {
            return NStringMap.this.size;
        }

        public boolean contains(Object o) {
            return NStringMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return NStringMap.this.removeEntryForKey(o) != null;
        }

        public void clear() {
            NStringMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection {
        Values() {
        }

        public Iterator iterator() {
            return NStringMap.this.newValueIterator();
        }

        public int size() {
            return NStringMap.this.size;
        }

        public boolean contains(Object o) {
            return NStringMap.this.containsValue(o);
        }

        public void clear() {
            NStringMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return NStringMap.this.newEntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = NStringMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        public boolean remove(Object o) {
            return NStringMap.this.removeMapping(o) != null;
        }

        public int size() {
            return NStringMap.this.size;
        }

        public void clear() {
            NStringMap.this.clear();
        }
    }
}

