/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ObjectCache {
    private static Character[] chars = new Character[256];
    private static Byte[] bytes;
    private static Short[] shorts;
    private static Integer[] integers;
    private static Long[] longs;
    private static Map dateFormatCache;
    private static Map numberFormatCache;

    static {
        char ch = '\u0000';
        int i = 0;
        while (i < chars.length) {
            ObjectCache.chars[i] = new Character(ch);
            ++i;
            ch = (char)(ch + '\u0001');
        }
        bytes = new Byte[256];
        byte b = -128;
        int i2 = 0;
        while (i2 < bytes.length) {
            ObjectCache.bytes[i2] = new Byte(b);
            ++i2;
            b = (byte)(b + 1);
        }
        shorts = new Short[1000];
        short sh = 0;
        int i3 = 0;
        while (i3 < shorts.length) {
            ObjectCache.shorts[i3] = new Short(sh);
            ++i3;
            sh = (short)(sh + 1);
        }
        integers = new Integer[10000];
        int in = 0;
        int i4 = 0;
        while (i4 < integers.length) {
            ObjectCache.integers[i4] = new Integer(in);
            ++i4;
            ++in;
        }
        longs = new Long[1000];
        long l = 0L;
        int i5 = 0;
        while (i5 < longs.length) {
            ObjectCache.longs[i5] = new Long(l);
            ++i5;
            ++l;
        }
        dateFormatCache = Collections.synchronizedMap(new HashMap());
        dateFormatCache.put("yyyy-MM-dd", new SimpleDateFormat("yyyy-MM-dd"));
        dateFormatCache.put("HH:mm:ss", new SimpleDateFormat("HH:mm:ss"));
        dateFormatCache.put("yyyy-MM-dd hh:mm:ss", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        numberFormatCache = Collections.synchronizedMap(new HashMap());
        numberFormatCache.put("#0.00", new DecimalFormat("#0.00"));
        numberFormatCache.put("#,##0.00", new DecimalFormat("#,##0.00"));
    }

    public static Character getCharacter(char ch) {
        if (ch < '\u0100') {
            return chars[ch];
        }
        return new Character(ch);
    }

    public static Byte getByte(byte b) {
        return bytes[b - -128];
    }

    public static Short getShort(short s) {
        if (s >= 0 && s < 1000) {
            return shorts[s];
        }
        return new Short(s);
    }

    public static Integer getInteger(int i) {
        if (i >= 0 && i < 10000) {
            return integers[i];
        }
        return new Integer(i);
    }

    public static Long getLong(long l) {
        if (l >= 0L && l < 1000L) {
            return longs[(int)l];
        }
        return new Long(l);
    }

    public static DateFormat getDateFormat(String format) {
        DateFormat df = (DateFormat)dateFormatCache.get(format);
        if (df == null) {
            df = new SimpleDateFormat(format);
            dateFormatCache.put(format, df);
        }
        return df;
    }

    public static NumberFormat getNumberFormat(String format) {
        NumberFormat nf = (NumberFormat)numberFormatCache.get(format);
        if (nf == null) {
            nf = new DecimalFormat(format);
            numberFormatCache.put(format, nf);
        }
        return nf;
    }
}

