/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import com.runqian.base.util.IniFile;
import com.runqian.base.util.ReportError;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Set;

public class PrinterCodeManager {
    private static SoftReference pcMap = null;

    private static IniFile checkPcMap() {
        try {
            IniFile ini = null;
            if (pcMap == null || (ini = (IniFile)pcMap.get()) == null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream is = cl.getResourceAsStream("printer.ini");
                if (is == null) {
                    throw new ReportError("\u672a\u53d1\u73b0\u6253\u5370\u673a\u63a7\u5236\u7801\u8868\u6587\u4ef6printer.ini");
                }
                ini = new IniFile(is, false);
                pcMap = new SoftReference<IniFile>(ini);
            }
            return ini;
        }
        catch (ReportError e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReportError("\u88c5\u8f7d\u6253\u5370\u673a\u63a7\u5236\u7801\u8868\u6587\u4ef6printer.ini\u65f6\u51fa\u9519", e);
        }
    }

    public static void reloadPrinterCode() {
        pcMap = null;
    }

    public static Set getPrinterNames() {
        IniFile ini = PrinterCodeManager.checkPcMap();
        return ini.readSectionNames();
    }

    public static Map getPrinterCodeMap(String printerName) {
        IniFile ini = PrinterCodeManager.checkPcMap();
        return ini.readSection(printerName);
    }
}

