/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import java.io.PrintStream;

public class ReportError
extends RuntimeException {
    private String cell = null;
    private String errorMsg = null;
    private Throwable cause = null;

    public ReportError() {
        super("report error");
    }

    public ReportError(String errorMsg) {
        super(errorMsg);
        this.errorMsg = errorMsg;
    }

    public ReportError(String errorMsg, Throwable cause) {
        super(errorMsg);
        this.errorMsg = errorMsg;
        this.cause = cause;
    }

    public void setCellId(String id) {
        this.cell = id;
    }

    public String getMessage() {
        return this.toString();
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getErrorMsg() {
        return this.errorMsg == null ? "" : this.errorMsg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        if (this.cell != null) {
            sb.append("\u5355\u5143\u683c").append(this.cell).append("\u4e2d\u6709\u9519\u8bef");
        }
        if (this.errorMsg != null) {
            sb.append(": ").append(this.errorMsg);
        }
        if (this.cause != null) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("\u9519\u8bef\u6765\u6e90: ");
            if (this.cause.getMessage() == null) {
                sb.append(this.cause.getClass().getName());
            } else {
                sb.append(this.cause.getMessage());
            }
        }
        return sb.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            super.printStackTrace(ps);
        }
    }
}

