/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import com.runqian.base.util.Sentence;

public final class SQLParser {
    public static final int SQL_UNKNOWN = 100;
    public static final int SQL_SELECT = 101;
    public static final int SQL_INSERT = 102;
    public static final int SQL_DELETE = 103;
    public static final int SQL_UPDATE = 104;
    public static final int KEY_SELECT = 0;
    public static final int KEY_FROM = 1;
    public static final int KEY_WHERE = 2;
    public static final int KEY_GROUPBY = 3;
    public static final int KEY_HAVING = 4;
    public static final int KEY_ORDERBY = 5;
    public static final int KEY_INSERT = 0;
    public static final int KEY_VALUES = 1;
    public static final int KEY_DELETE = 0;
    public static final int KEY_UPDATE = 0;
    public static final int KEY_SET = 1;
    private int type;
    private String sql;
    private static final String[] selectKeys = new String[]{"SELECT", "FROM", "WHERE", "GROUP", "HAVING", "ORDER"};
    private static final String[] insertKeys = new String[]{"INTO", "VALUES"};
    private static final String[] deleteKeys = new String[]{"FROM", "WHERE", "WHERE"};
    private static final String[] updateKeys = new String[]{"UPDATE", "SET", "WHERE"};

    public SQLParser(String sql) {
        this.sql = sql;
        this.type = SQLParser.parseSQLType(sql);
    }

    private static String getClause(String sql, int key, String[] keyValues) {
        int q;
        if (key < 0 || key > keyValues.length) {
            return null;
        }
        String keyValue = keyValues[key];
        int p = Sentence.phraseAt(sql, keyValue, 0, 1);
        if (p < 0) {
            return null;
        }
        switch (key) {
            case 3: 
            case 5: {
                p = Sentence.phraseAt(sql, "BY", p, 1);
                if (p < 0) {
                    return null;
                }
                p += 2;
                break;
            }
            case 0: {
                q = Sentence.phraseAt(sql, "DISTINCT", p, 1);
                if (q >= 0) {
                    p = q + 8;
                    break;
                }
            }
            default: {
                p += keyValue.length();
            }
        }
        q = -1;
        while (q < 0 && key < keyValues.length - 1) {
            q = Sentence.phraseAt(sql, keyValues[++key], p, 1);
        }
        if (q < 0) {
            return sql.substring(p).trim();
        }
        return sql.substring(p, q).trim();
    }

    public static String getClause(String sql, int key) {
        switch (SQLParser.parseSQLType(sql)) {
            case 101: {
                return SQLParser.getClause(sql, key, selectKeys);
            }
            case 102: {
                return SQLParser.getClause(sql, key, insertKeys);
            }
            case 103: {
                return SQLParser.getClause(sql, key, deleteKeys);
            }
            case 104: {
                return SQLParser.getClause(sql, key, updateKeys);
            }
        }
        return null;
    }

    public String getClause(int key) {
        switch (this.type) {
            case 101: {
                return SQLParser.getClause(this.sql, key, selectKeys);
            }
            case 102: {
                return SQLParser.getClause(this.sql, key, insertKeys);
            }
            case 103: {
                return SQLParser.getClause(this.sql, key, deleteKeys);
            }
            case 104: {
                return SQLParser.getClause(this.sql, key, updateKeys);
            }
        }
        return null;
    }

    private static String modify(String sql, int key, String clause, String[] keyValues) {
        if (key < 0 || key > keyValues.length) {
            return sql;
        }
        int p = -1;
        int i = key;
        StringBuffer dst = new StringBuffer(2 * sql.length());
        while (p < 0) {
            p = Sentence.phraseAt(sql, keyValues[i], 0, 1);
            if (++i == keyValues.length) break;
        }
        if (p > 0) {
            dst.append(sql.substring(0, p));
        } else if (p < 0) {
            dst.append(sql);
            dst.append(' ');
        }
        if (clause != null && clause.trim().length() != 0) {
            dst.append(keyValues[key]);
            if (key == 0) {
                if (Sentence.phraseAt(sql, "DISTINCT", 0, 1) > 0) {
                    dst.append(" DISTINCT");
                }
            } else if (key == 3 || key == 5) {
                dst.append(" BY");
            }
            dst.append(' ');
            dst.append(clause);
        }
        if (p < 0) {
            return dst.toString();
        }
        if (i == key + 1) {
            int q = -1;
            while (q < 0 && i < keyValues.length) {
                q = Sentence.phraseAt(sql, keyValues[i], p, 1);
                if (q >= 0) break;
                ++i;
            }
            p = q;
        }
        if (p >= 0) {
            dst.append(' ');
            dst.append(sql.substring(p));
        }
        return dst.toString();
    }

    public static String modify(String sql, int key, String clause) {
        switch (SQLParser.parseSQLType(sql)) {
            case 100: 
            case 101: {
                return SQLParser.modify(sql, key, clause, selectKeys);
            }
            case 102: {
                return SQLParser.modify(sql, key, clause, insertKeys);
            }
            case 103: {
                return SQLParser.modify(sql, key, clause, deleteKeys);
            }
            case 104: {
                return SQLParser.modify(sql, key, clause, updateKeys);
            }
        }
        return sql;
    }

    public void modify(int key, String clause) {
        switch (this.type) {
            case 100: 
            case 101: {
                this.sql = SQLParser.modify(this.sql, key, clause, selectKeys);
                break;
            }
            case 102: {
                this.sql = SQLParser.modify(this.sql, key, clause, insertKeys);
                break;
            }
            case 103: {
                this.sql = SQLParser.modify(this.sql, key, clause, deleteKeys);
                break;
            }
            case 104: {
                this.sql = SQLParser.modify(this.sql, key, clause, updateKeys);
            }
        }
    }

    private static String mergeWhere(String sql, String where, String[] keyValues) {
        if (where.equals("1") || where.equals("1=1")) {
            return sql;
        }
        int i = 2;
        StringBuffer dst = new StringBuffer(2 * where.length());
        int p = Sentence.phraseAt(sql, keyValues[i], 0, 1);
        if (p >= 0) {
            p += 5;
        }
        int q = -1;
        while (q < 0 && ++i < keyValues.length) {
            q = Sentence.phraseAt(sql, keyValues[i], 0, 1);
        }
        if (q < 0) {
            q = sql.length();
        }
        if (p >= 0) {
            dst.append(sql.substring(0, p));
            dst.append('(');
            if (!where.equals("1=0") && !where.equals("0=1")) {
                dst.append(sql.substring(p, q));
                dst.append(") AND (");
            }
            dst.append(where);
            dst.append(')');
            dst.append(sql.substring(q));
        } else {
            dst.append(sql.substring(0, q));
            dst.append(" WHERE ");
            dst.append(where);
            dst.append(' ');
            dst.append(sql.substring(q));
        }
        return dst.toString();
    }

    public static String mergeWhere(String sql, String where) {
        if (where == null || where.trim().length() == 0) {
            return sql;
        }
        where = where.trim();
        switch (SQLParser.parseSQLType(sql)) {
            case 101: {
                return SQLParser.mergeWhere(sql, where, selectKeys);
            }
            case 103: {
                return SQLParser.mergeWhere(sql, where, deleteKeys);
            }
            case 104: {
                return SQLParser.mergeWhere(sql, where, updateKeys);
            }
        }
        return sql;
    }

    public void mergeWhere(String where) {
        if (where == null || where.trim().length() == 0) {
            return;
        }
        where = where.trim();
        switch (this.type) {
            case 101: {
                this.sql = SQLParser.mergeWhere(this.sql, where, selectKeys);
                break;
            }
            case 103: {
                this.sql = SQLParser.mergeWhere(this.sql, where, deleteKeys);
                break;
            }
            case 104: {
                this.sql = SQLParser.mergeWhere(this.sql, where, updateKeys);
            }
        }
    }

    public String toString() {
        return this.sql;
    }

    public static int parseSQLType(String sql) {
        if (sql == null) {
            return 100;
        }
        int i = 0;
        int len = sql.length();
        while (i < len && Character.isWhitespace(sql.charAt(i))) {
            ++i;
        }
        if ("SELECT".regionMatches(true, 0, sql, i, 6)) {
            return 101;
        }
        if ("INSERT".regionMatches(true, 0, sql, i, 6)) {
            return 102;
        }
        if ("DELETE".regionMatches(true, 0, sql, i, 6)) {
            return 103;
        }
        if ("UPDATE".regionMatches(true, 0, sql, i, 6)) {
            return 104;
        }
        return 100;
    }

    public int parseSQLType() {
        return this.type;
    }

    public static int scanQuotation(String sql, int start, char quote) {
        if (quote != sql.charAt(start)) {
            return -1;
        }
        int idx = start + 1;
        int len = sql.length();
        while (idx < len) {
            if ((idx = sql.indexOf(quote, idx)) < 0) break;
            if (idx + 1 < len) {
                if (sql.charAt(idx + 1) != quote) {
                    return idx;
                }
                ++idx;
            }
            ++idx;
        }
        return -1;
    }

    public static void main(String[] a) {
        String sss = "\t  insert into xu values('ddd')";
        System.out.println(SQLParser.parseSQLType(sss));
        System.out.println(SQLParser.modify(sss, 5, "dddd"));
    }
}

