/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class SQLTool {
    public static String getProcedureColumnTypeName(int columnType) {
        switch (columnType) {
            case 1: {
                return "in";
            }
            case 2: {
                return "inout";
            }
            case 4: {
                return "out";
            }
            case 3: {
                return "result";
            }
            case 5: {
                return "return";
            }
            case 0: {
                return "unknown";
            }
        }
        return "error_type";
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 2003: {
                return "array";
            }
            case -5: {
                return "bigint";
            }
            case -2: {
                return "binary";
            }
            case -7: {
                return "bit";
            }
            case 2004: {
                return "blob";
            }
            case 1: {
                return "char";
            }
            case 2005: {
                return "clob";
            }
            case 91: {
                return "date";
            }
            case 3: {
                return "decimal";
            }
            case 2001: {
                return "distinct";
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 4: {
                return "integer";
            }
            case 2000: {
                return "java_object";
            }
            case -4: {
                return "longvarbinary";
            }
            case -1: {
                return "longvarchar";
            }
            case 0: {
                return "null";
            }
            case 2: {
                return "numeric";
            }
            case 1111: {
                return "other";
            }
            case 7: {
                return "real";
            }
            case 2006: {
                return "ref";
            }
            case 5: {
                return "smallint";
            }
            case 2002: {
                return "struct";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case -6: {
                return "tinyint";
            }
            case -3: {
                return "varbinary";
            }
            case 12: {
                return "varchar";
            }
        }
        return "errortype";
    }

    public static void setObject(PreparedStatement pst, int index, Object obj, String encoding) throws SQLException, UnsupportedEncodingException {
        if (obj instanceof String && encoding != null) {
            obj = new String(((String)obj).getBytes(), encoding);
        }
        pst.setObject(index, obj);
    }

    public static void setObject(PreparedStatement pst, int index, Object o, int type) throws SQLException {
        if (o == null) {
            switch (type) {
                case 6: 
                case 262: {
                    pst.setNull(index, 12);
                    break;
                }
                case 19: 
                case 275: {
                    pst.setNull(index, 8);
                    break;
                }
                case 17: 
                case 273: {
                    pst.setNull(index, 4);
                    break;
                }
                case 2: {
                    pst.setNull(index, 91);
                    break;
                }
                case 3: {
                    pst.setNull(index, 92);
                    break;
                }
                case 4: {
                    pst.setNull(index, 93);
                    break;
                }
                default: {
                    pst.setNull(index, 12);
                    break;
                }
            }
        } else if (o instanceof BigDecimal) {
            pst.setBigDecimal(index, (BigDecimal)o);
        } else if (o instanceof Blob) {
            pst.setBlob(index, (Blob)o);
        } else if (o instanceof Boolean) {
            pst.setBoolean(index, (Boolean)o);
        } else if (o instanceof Byte) {
            pst.setByte(index, (Byte)o);
        } else if (o instanceof byte[]) {
            pst.setBytes(index, (byte[])o);
        } else if (o instanceof Clob) {
            pst.setClob(index, (Clob)o);
        } else if (o instanceof Date) {
            pst.setDate(index, (Date)o);
        } else if (o instanceof Double) {
            pst.setDouble(index, (Double)o);
        } else if (o instanceof Float) {
            pst.setFloat(index, ((Float)o).floatValue());
        } else if (o instanceof Integer) {
            pst.setInt(index, (Integer)o);
        } else if (o instanceof Long) {
            pst.setLong(index, (Long)o);
        } else if (o instanceof Ref) {
            pst.setRef(index, (Ref)o);
        } else if (o instanceof Short) {
            pst.setShort(index, (Short)o);
        } else if (o instanceof String) {
            pst.setString(index, (String)o);
        } else if (o instanceof Time) {
            pst.setTime(index, (Time)o);
        } else if (o instanceof Timestamp) {
            pst.setTimestamp(index, (Timestamp)o);
        } else {
            pst.setObject(index, o);
        }
    }

    public static Object getObject(ResultSet rs, int index, String encoding) throws SQLException, UnsupportedEncodingException {
        Object obj = rs.getObject(index);
        if (obj instanceof String && encoding != null) {
            obj = new String(((String)obj).getBytes(encoding));
        }
        return obj;
    }
}

