/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

import java.sql.Timestamp;
import java.util.Date;

public final class Sentence {
    public static final int IGNORE_CASE = 1;
    public static final int IGNORE_PARS = 2;
    public static final int ONLY_FIRST = 4;
    public static final int ONLY_PHRASE = 8;
    public static final int IGNORE_QUOTE = 16;
    public static final int UPPER_WHEN_TRIM = 16;
    public static final int LOWER_WHEN_TRIM = 32;
    private static final boolean LOG = false;
    private String str;
    private char escapeChar = (char)92;

    public static void log(Object o) {
    }

    public Sentence(String str) {
        this.str = str;
    }

    public Sentence(String str, char escapeChar) {
        this.str = str;
        this.escapeChar = escapeChar;
    }

    public static int scanIdentifier(String str, int start) {
        int len = str.length();
        char ch = str.charAt(start);
        if (!Character.isJavaIdentifierStart(ch)) {
            return -1;
        }
        int i = start + 1;
        while (i < len) {
            if (str.charAt(i) == '\u0000' || str.charAt(i) == '\u0001' || !Character.isJavaIdentifierPart(str.charAt(i))) break;
            ++i;
        }
        return i - 1;
    }

    public static int scanQuotation(String str, int start, char escapeChar) {
        char quote = str.charAt(start);
        if (quote != '\"' && quote != '\'') {
            return -1;
        }
        int idx = start + 1;
        int len = str.length();
        while (idx < len) {
            char ch = str.charAt(idx);
            if (ch == escapeChar) {
                idx += 2;
                continue;
            }
            if (ch == quote) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static int scanQuotation(String str, int start) {
        return Sentence.scanQuotation(str, start, '\\');
    }

    public static int scanParenthesis(String str, int start, char escapeChar) {
        if (str.charAt(start) != '(') {
            return -1;
        }
        int len = str.length();
        int i = start + 1;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '(': {
                    i = Sentence.scanParenthesis(str, i, escapeChar);
                    if (i < 0) {
                        return -1;
                    }
                    ++i;
                    break;
                }
                case '\"': 
                case '\'': {
                    i = Sentence.scanQuotation(str, i, escapeChar);
                    if (i < 0) {
                        return -1;
                    }
                    ++i;
                    break;
                }
                case ')': {
                    return i;
                }
                default: {
                    if (ch == escapeChar) {
                        ++i;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    public static int scanParenthesis(String str, int start) {
        return Sentence.scanParenthesis(str, start, '\\');
    }

    public static int scanBracket(String str, int start, char escapeChar) {
        if (str.charAt(start) != '[') {
            return -1;
        }
        int len = str.length();
        int i = start + 1;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '[': {
                    i = Sentence.scanBracket(str, i, escapeChar);
                    if (i < 0) {
                        return -1;
                    }
                    ++i;
                    break;
                }
                case '\"': 
                case '\'': {
                    i = Sentence.scanQuotation(str, i, escapeChar);
                    if (i < 0) {
                        return -1;
                    }
                    ++i;
                    break;
                }
                case ']': {
                    return i;
                }
                default: {
                    if (ch == escapeChar) {
                        ++i;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    public static int scanBracket(String str, int start) {
        return Sentence.scanBracket(str, start, '\\');
    }

    public static int scanBrace(String str, int start, char escapeChar) {
        if (str.charAt(start) != '{') {
            return -1;
        }
        int len = str.length();
        int i = start + 1;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '{': {
                    i = Sentence.scanBrace(str, i, escapeChar);
                    if (i < 0) {
                        return -1;
                    }
                    ++i;
                    break;
                }
                case '\"': 
                case '\'': {
                    i = Sentence.scanQuotation(str, i, escapeChar);
                    if (i < 0) {
                        return -1;
                    }
                    ++i;
                    break;
                }
                case '}': {
                    return i;
                }
                default: {
                    if (ch == escapeChar) {
                        ++i;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    public static int scanBrace(String str, int start) {
        return Sentence.scanBrace(str, start, '\\');
    }

    public static String trim(String str, int ifcase, char escapeChar) {
        int idx = 0;
        int len = str.length();
        int flag = 0;
        StringBuffer dst = new StringBuffer(len);
        while (idx < len) {
            char ch = str.charAt(idx);
            if ((ch == '\"' || ch == '\'') && (idx > 0 && str.charAt(idx - 1) != escapeChar || idx == 0)) {
                int i;
                if (flag == 2) {
                    dst.append(' ');
                }
                if ((i = Sentence.scanQuotation(str, idx, escapeChar)) < 0) {
                    throw new RuntimeException("\u672a\u627e\u5230\u4f4d\u7f6e" + idx + "\u5904\u5bf9\u5e94\u7684\u5f15\u53f7");
                }
                ++i;
                int j = idx;
                while (j < i) {
                    dst.append(str.charAt(j));
                    ++j;
                }
                idx = i;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                while (Character.isWhitespace(str.charAt(++idx))) {
                }
                if (flag <= 0) continue;
                flag = 2;
                continue;
            }
            if (Sentence.isWordChar(ch)) {
                if (flag == 2) {
                    dst.append(' ');
                }
                flag = 1;
            } else {
                flag = 0;
            }
            switch (ifcase) {
                case 16: {
                    dst.append(Character.toUpperCase(ch));
                    break;
                }
                case 32: {
                    dst.append(Character.toLowerCase(ch));
                    break;
                }
                default: {
                    dst.append(ch);
                }
            }
            ++idx;
        }
        return dst.toString();
    }

    public static String trim(String str, int ifcase) {
        return Sentence.trim(str, ifcase, '\\');
    }

    public static int phraseAt(String str, String phrase, int start, int flag, char escapeChar) {
        int slen = str.length();
        int plen = phrase.length();
        boolean iswordchar = false;
        int i = start;
        while (i < slen) {
            char ch = str.charAt(i);
            if ((ch == '\"' || ch == '\'') && (i > 0 && str.charAt(i - 1) != '\\' || i == 0)) {
                if ((i = Sentence.scanQuotation(str, i, escapeChar)) < 0) {
                    return -1;
                }
                ++i;
                iswordchar = false;
                continue;
            }
            if ((flag & 2) == 0 && ch == '(') {
                if ((i = Sentence.scanParenthesis(str, i, escapeChar)) < 0) {
                    return -1;
                }
                ++i;
                iswordchar = false;
                continue;
            }
            if (!(iswordchar || !phrase.regionMatches((flag & 1) > 0, 0, str, i, plen) || i + plen < slen && Sentence.isWordChar(str.charAt(i + plen)))) {
                return i;
            }
            iswordchar = Sentence.isWordChar(ch);
            ++i;
        }
        return -1;
    }

    public static int phraseAt(String str, String phrase, int start, int flag) {
        return Sentence.phraseAt(str, phrase, start, flag, '\\');
    }

    public static String replace(String str, int start, String sold, String snew, int flag, char escapeChar) {
        int strlen = str.length();
        int len = sold.length();
        StringBuffer dst = null;
        char preChar = '*';
        int i = start;
        while (i < strlen) {
            int j;
            int idx;
            char ch = str.charAt(i);
            if ((ch == '\'' || ch == '\"') && (flag & 0x10) == 0 && (i == 0 || i > 0 && str.charAt(i - 1) != escapeChar)) {
                idx = Sentence.scanQuotation(str, i, escapeChar);
                if (idx < 0) {
                    throw new RuntimeException("\u672a\u627e\u5230\u4f4d\u7f6e" + i + "\u5904\u5bf9\u5e94\u7684\u5f15\u53f7");
                }
                ++idx;
                if (dst != null) {
                    j = i;
                    while (j < idx) {
                        dst.append(str.charAt(j));
                        ++j;
                    }
                }
                i = idx;
                preChar = '*';
                continue;
            }
            if ((flag & 2) == 0 && ch == '(') {
                idx = Sentence.scanParenthesis(str, i, escapeChar);
                if (idx < 0) {
                    throw new RuntimeException("\u672a\u627e\u5230\u4f4d\u7f6e" + i + "\u5904\u5bf9\u5e94\u7684\u5706\u62ec\u53f7");
                }
                ++idx;
                if (dst != null) {
                    j = i;
                    while (j < idx) {
                        dst.append(str.charAt(j));
                        ++j;
                    }
                }
                i = idx;
                preChar = '*';
                continue;
            }
            boolean lb = sold.regionMatches((flag & 1) > 0, 0, str, i, len);
            if (lb && (flag & 8) > 0) {
                boolean bl = lb = !Sentence.isWordChar(sold.charAt(0)) || !Sentence.isWordChar(preChar);
                if (i + len < strlen) {
                    boolean bl2 = lb = lb && (!Sentence.isWordChar(sold.charAt(len - 1)) || !Sentence.isWordChar(str.charAt(i + len)));
                }
            }
            if (lb) {
                if (dst == null) {
                    dst = new StringBuffer(strlen << 2);
                    j = 0;
                    while (j < i) {
                        dst.append(str.charAt(j));
                        ++j;
                    }
                }
                dst.append(snew);
                preChar = str.charAt((i += len) - 1);
                if ((flag & 4) <= 0) continue;
                while (i < strlen) {
                    dst.append(str.charAt(i++));
                }
                break;
            }
            if (dst != null) {
                dst.append(ch);
            }
            preChar = ch;
            ++i;
        }
        return dst == null ? str : dst.toString();
    }

    public static String replace(String str, int start, String sold, String snew, int flag) {
        return Sentence.replace(str, start, sold, snew, flag, '\\');
    }

    public static String replace(String str, String sold, String snew, int flag) {
        return Sentence.replace(str, 0, sold, snew, flag, '\\');
    }

    public int scanQuotation(int start) {
        return Sentence.scanQuotation(this.str, start, this.escapeChar);
    }

    public void trim(int ifcase) {
        this.str = Sentence.trim(this.str, ifcase, this.escapeChar);
    }

    public int phraseAt(String phrase, int start, int flag) {
        return Sentence.phraseAt(this.str, phrase, start, flag, this.escapeChar);
    }

    public int replace(int start, String sold, String snew, int flag) {
        int strlen = this.str.length();
        int len = sold.length();
        int count = 0;
        StringBuffer dst = null;
        char preChar = '*';
        int i = start;
        while (i < strlen) {
            int j;
            int idx;
            char ch = this.str.charAt(i);
            if ((ch == '\"' || ch == '\'') && (i > 0 && this.str.charAt(i - 1) != '\\' || i == 0)) {
                idx = Sentence.scanQuotation(this.str, i, this.escapeChar);
                if (idx < 0) {
                    return 0;
                }
                ++idx;
                if (dst != null) {
                    j = i;
                    while (j < idx) {
                        dst.append(this.str.charAt(j));
                        ++j;
                    }
                }
                i = idx;
                preChar = '*';
                continue;
            }
            if ((flag & 2) == 0 && ch == '(') {
                idx = Sentence.scanParenthesis(this.str, i, this.escapeChar);
                if (idx < 0) {
                    return 0;
                }
                ++idx;
                if (dst != null) {
                    j = i;
                    while (j < idx) {
                        dst.append(this.str.charAt(j));
                        ++j;
                    }
                }
                i = idx;
                preChar = '*';
                continue;
            }
            boolean lb = sold.regionMatches((flag & 1) > 0, 0, this.str, i, len);
            if (lb && (flag & 8) > 0) {
                boolean bl = lb = !Sentence.isWordChar(sold.charAt(0)) || !Sentence.isWordChar(preChar);
                if (i + len < strlen) {
                    boolean bl2 = lb = lb && (!Sentence.isWordChar(sold.charAt(len - 1)) || !Sentence.isWordChar(this.str.charAt(i + len)));
                }
            }
            if (lb) {
                if (dst == null) {
                    dst = new StringBuffer(strlen << 2);
                    j = 0;
                    while (j < i) {
                        dst.append(this.str.charAt(j));
                        ++j;
                    }
                }
                dst.append(snew);
                preChar = this.str.charAt((i += len) - 1);
                ++count;
                if ((flag & 4) <= 0) continue;
                while (i < strlen) {
                    dst.append(this.str.charAt(i++));
                }
                break;
            }
            if (dst != null) {
                dst.append(ch);
            }
            ++i;
        }
        if (dst != null) {
            this.str = dst.toString();
        }
        return count;
    }

    public String toString() {
        return this.str;
    }

    public String getSentence() {
        return this.str;
    }

    public static int indexOf(String str, String find, int start, int flag, char escapeChar) {
        int slen = str.length();
        int plen = find.length();
        int i = start;
        while (i < slen) {
            char ch = str.charAt(i);
            if ((ch == '\"' || ch == '\'') && (i > 0 && str.charAt(i - 1) != '\\' || i == 0)) {
                if ((i = Sentence.scanQuotation(str, i, escapeChar)) < 0) {
                    return -1;
                }
                ++i;
                continue;
            }
            if ((flag & 2) == 0 && ch == '(') {
                if ((i = Sentence.scanParenthesis(str, i, escapeChar)) < 0) {
                    return -1;
                }
                ++i;
                continue;
            }
            if (find.regionMatches((flag & 1) > 0, 0, str, i, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String find, int start, int flag) {
        return Sentence.indexOf(this.str, find, start, flag, this.escapeChar);
    }

    public static int indexOf(String str, String find, int start, int flag) {
        return Sentence.indexOf(str, find, start, flag, '\\');
    }

    public static boolean isWordChar(char ch) {
        return Character.isJavaIdentifierStart(ch) || Character.isJavaIdentifierPart(ch);
    }

    public static void main(String[] args) {
        String s = "aa select * from aa where @aa.aaa=1";
        String s1 = Sentence.replace(s, 0, "@aa", "bbbbb", 12);
        System.out.println(s1);
        s1 = Sentence.replace(s, 0, "cc", "bbbbb", 8);
        System.out.println(s == s1 ? "equals" : "not equals");
        s = "this is an example.";
        System.out.println(Sentence.indexOf(s, "is", 0, 0));
        System.out.println(Sentence.phraseAt(s, "is", 0, 0));
        s = "(sdfsfs\\)f(dsfsdf))";
        System.out.println(String.valueOf(s) + " -- first ( : " + Sentence.scanParenthesis(s, 0));
        s = "this < iS \\\" is < \\\"  \tan  'sdf is sdf'";
        System.out.println(Sentence.trim(s, 0));
        System.out.println(Sentence.replace(s, 0, "<", "&lt;", 25));
        System.out.println(Sentence.replace(s, 0, "is", "***", 25));
        System.out.println(new Timestamp(new Date().getTime()));
        Sentence.replace(s, 0, "is", "***", 25);
        System.out.println(new Timestamp(new Date().getTime()));
        s = "ab cd";
        System.out.println(String.valueOf(s) + "===" + Sentence.scanIdentifier(s, 0));
        s = "'sfsd''sdfsd'sdfsdf";
        System.out.println(Sentence.scanQuotation(s, 0, '\''));
        s = "1";
        System.out.println(s);
        System.out.println(Sentence.replace(s, 0, "\\u", "@#x", 25));
    }
}

