/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util;

public class StringUtils {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final char[] c1Digit = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
    static final char[] c2Digit = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    static final char[] c1Unit = new char[]{'\u4edf', '\u4f70', '\u62fe'};
    static final char[] c2Unit = new char[]{'\u5343', '\u767e', '\u5341'};
    private static final String[] provinces;
    private static final int[] wi;
    private static final char[] codes;

    static {
        String[] stringArray = new String[92];
        stringArray[11] = "\u5317\u4eac";
        stringArray[12] = "\u5929\u6d25";
        stringArray[13] = "\u6cb3\u5317";
        stringArray[14] = "\u5c71\u897f";
        stringArray[15] = "\u5185\u8499\u53e4";
        stringArray[21] = "\u8fbd\u5b81";
        stringArray[22] = "\u5409\u6797";
        stringArray[23] = "\u9ed1\u9f99\u6c5f";
        stringArray[31] = "\u4e0a\u6d77";
        stringArray[32] = "\u6c5f\u82cf";
        stringArray[33] = "\u6d59\u6c5f";
        stringArray[34] = "\u5b89\u5fae";
        stringArray[35] = "\u798f\u5efa";
        stringArray[36] = "\u6c5f\u897f";
        stringArray[37] = "\u5c71\u4e1c";
        stringArray[41] = "\u6cb3\u5357";
        stringArray[42] = "\u6e56\u5317";
        stringArray[43] = "\u6e56\u5357";
        stringArray[44] = "\u5e7f\u4e1c";
        stringArray[45] = "\u5e7f\u897f";
        stringArray[46] = "\u6d77\u5357";
        stringArray[50] = "\u91cd\u5e86";
        stringArray[51] = "\u56db\u5ddd";
        stringArray[52] = "\u8d35\u5dde";
        stringArray[53] = "\u4e91\u5357";
        stringArray[54] = "\u897f\u85cf";
        stringArray[61] = "\u9655\u897f";
        stringArray[62] = "\u7518\u8083";
        stringArray[63] = "\u9752\u6d77";
        stringArray[64] = "\u5b81\u590f";
        stringArray[65] = "\u65b0\u7586";
        stringArray[71] = "\u53f0\u6e7e";
        stringArray[81] = "\u9999\u6e2f";
        stringArray[82] = "\u6fb3\u95e8";
        stringArray[91] = "\u56fd\u5916";
        provinces = stringArray;
        wi = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
        codes = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
    }

    public static final boolean isSpaceString(String s) {
        if (s == null) {
            return true;
        }
        int i = 0;
        int len = s.length();
        while (i < len) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final StringBuffer deunicode(String s, StringBuffer sb, String specialChars) {
        int len = s.length();
        if (sb == null) {
            sb = new StringBuffer(len * 2);
        }
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    sb.append('\\').append('\\');
                    break;
                }
                case '\t': {
                    sb.append('\\').append('t');
                    break;
                }
                case '\n': {
                    sb.append('\\').append('n');
                    break;
                }
                case '\r': {
                    sb.append('\\').append('r');
                    break;
                }
                case '\f': {
                    sb.append('\\').append('f');
                    break;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        sb.append('\\').append('u');
                        sb.append(hexDigits[ch >> 12 & 0xF]);
                        sb.append(hexDigits[ch >> 8 & 0xF]);
                        sb.append(hexDigits[ch >> 4 & 0xF]);
                        sb.append(hexDigits[ch & 0xF]);
                        break;
                    }
                    if (specialChars != null && specialChars.indexOf(ch) != -1) {
                        sb.append('\\');
                    }
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb;
    }

    public static final StringBuffer deunicode(String s, StringBuffer sb) {
        return StringUtils.deunicode(s, sb, null);
    }

    public static final String deunicode(String s, String specialChars) {
        return StringUtils.deunicode(s, null, specialChars).toString();
    }

    public static final String deunicode(String s) {
        return StringUtils.deunicode(s, null, null).toString();
    }

    public static final StringBuffer unicode(String s, StringBuffer sb) {
        int len = s.length();
        if (sb == null) {
            sb = new StringBuffer(len);
        }
        int i = 0;
        while (i < len) {
            char ch;
            if ((ch = s.charAt(i++)) != '\\') {
                sb.append(ch);
                continue;
            }
            if ((ch = s.charAt(i++)) == 'u') {
                int value = 0;
                int j = 0;
                while (j < 4) {
                    ch = s.charAt(i++);
                    switch (ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            value = (value << 4) + ch - 48;
                            break;
                        }
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            value = (value << 4) + 10 + ch - 97;
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': {
                            value = (value << 4) + 10 + ch - 65;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\\uxxxx\u7f16\u7801");
                        }
                    }
                    ++j;
                }
                sb.append((char)value);
                continue;
            }
            switch (ch) {
                case 't': {
                    ch = '\t';
                    break;
                }
                case 'r': {
                    ch = '\r';
                    break;
                }
                case 'n': {
                    ch = '\n';
                    break;
                }
                case 'f': {
                    ch = '\f';
                }
            }
            sb.append(ch);
        }
        return sb;
    }

    public static final String unicode(String s) {
        return StringUtils.unicode(s, null).toString();
    }

    public static final String unicode2String(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            char aChar;
            if ((aChar = theString.charAt(x++)) == '\\') {
                if ((aChar = theString.charAt(x++)) != 'u') continue;
                int value = 0;
                int i = 0;
                while (i < 4) {
                    aChar = theString.charAt(x++);
                    switch (aChar) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            value = (value << 4) + aChar - 48;
                            break;
                        }
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            value = (value << 4) + 10 + aChar - 97;
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': {
                            value = (value << 4) + 10 + aChar - 65;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                        }
                    }
                    ++i;
                }
                outBuffer.append((char)value);
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    private static final String toRMB1(int money, char[] cDigit, char[] cUnit) {
        if (money > 10000 || money < 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer sb = new StringBuffer(10);
        boolean hasLeft = false;
        boolean hasZero = false;
        int i = 0;
        int currBit = 1000;
        while (i < 4) {
            int t = money / currBit;
            money %= currBit;
            if (t == 0) {
                hasZero = true;
            } else {
                if (hasLeft && hasZero) {
                    sb.append(cDigit[0]);
                }
                hasLeft = true;
                hasZero = false;
                sb.append(cDigit[t]);
                if (i < 3) {
                    sb.append(cUnit[i]);
                }
            }
            ++i;
            currBit /= 10;
        }
        return sb.toString();
    }

    public static final String toRMB(double money) {
        int wan;
        long yuan;
        int yi;
        char[] cDigit = c1Digit;
        char[] cUnit = c1Unit;
        StringBuffer sb = new StringBuffer(40);
        if (money < 0.0) {
            sb.append("\u8d1f");
            money = -money;
        }
        if ((yi = (int)((yuan = (long)money) / 100000000L)) > 10000) {
            throw new IllegalArgumentException("\u4eba\u6c11\u5e01\u5927\u5199\u4e0d\u652f\u6301\u5927\u4e8e\u4e00\u4e07\u4ebf\u7684\u6570");
        }
        if (yi != 0) {
            sb.append(StringUtils.toRMB1(yi, cDigit, cUnit));
            sb.append('\u4ebf');
        }
        if ((wan = (int)((yuan %= 100000000L) / 10000L)) != 0) {
            if (yi != 0 && wan < 1000) {
                sb.append('\u96f6');
            }
            sb.append(StringUtils.toRMB1(wan, cDigit, cUnit));
            sb.append('\u4e07');
        }
        if ((yuan %= 10000L) != 0L) {
            if ((yi != 0 || wan != 0) && yuan < 1000L || yi != 0 && wan == 0) {
                sb.append('\u96f6');
            }
            sb.append(StringUtils.toRMB1((int)yuan, cDigit, cUnit));
        }
        if (yi != 0 || wan != 0 || yuan != 0L) {
            sb.append('\u5706');
        }
        int jaoFeng = (int)((money + 0.001 - (double)((long)money)) * 100.0) % 100;
        int jao = jaoFeng / 10;
        int feng = jaoFeng % 10;
        if (jao != 0) {
            sb.append(cDigit[jao]);
            sb.append('\u89d2');
        }
        if (feng != 0) {
            if (jao == 0) {
                sb.append('\u96f6');
            }
            sb.append(cDigit[feng]);
            sb.append('\u5206');
        } else {
            sb.append('\u6574');
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final String toChinese(long l, boolean abbreviate, boolean uppercase) {
        block9: {
            block8: {
                sb = new StringBuffer(40);
                if (l < 0L) {
                    sb.append("\u8d1f");
                    l = -l;
                }
                cDigit = uppercase != false ? StringUtils.c1Digit : StringUtils.c2Digit;
                v0 = cUnit = uppercase != false ? StringUtils.c1Unit : StringUtils.c2Unit;
                if (!abbreviate) break block8;
                yi = (int)(l / 100000000L);
                if (yi > 10000) {
                    throw new IllegalArgumentException("\u6570\u5b57\u5927\u5199\u4e0d\u652f\u6301\u5927\u4e8e\u4e00\u4e07\u4ebf\u7684\u6570");
                }
                if (yi != 0) {
                    sb.append(StringUtils.toRMB1(yi, cDigit, cUnit));
                    sb.append('\u4ebf');
                }
                if ((wan = (int)((l %= 100000000L) / 10000L)) != 0) {
                    if (yi != 0 && wan < 1000) {
                        sb.append('\u96f6');
                    }
                    sb.append(StringUtils.toRMB1(wan, cDigit, cUnit));
                    sb.append('\u4e07');
                }
                if ((l %= 10000L) != 0L) {
                    if ((yi != 0 || wan != 0) && l < 1000L || yi != 0 && wan == 0) {
                        sb.append('\u96f6');
                    }
                    sb.append(StringUtils.toRMB1((int)l, cDigit, cUnit));
                }
                break block9;
            }
            pos = sb.length();
            if (l != 0L) ** GOTO lbl42
            sb.append('\u96f6');
            return sb.toString();
lbl-1000:
            // 1 sources

            {
                digit = (int)l % 10;
                sb.insert(pos, cDigit[digit]);
                l /= 10L;
lbl42:
                // 2 sources

                ** while (l > 0L)
            }
        }
        return sb.toString();
    }

    private static final boolean matches(String value, int pos1, String fmt, int pos2, boolean ignoreCase) {
        if (value == null || fmt == null) {
            return false;
        }
        int len1 = value.length();
        int len2 = fmt.length();
        while (pos2 < len2) {
            char ch;
            if ((ch = fmt.charAt(pos2++)) == '*') {
                if (pos1 == len1) {
                    while (pos2 < len2) {
                        if (fmt.charAt(pos2++) == '*') continue;
                        return false;
                    }
                    return true;
                }
                do {
                    if (!StringUtils.matches(value, pos1, fmt, pos2, ignoreCase)) continue;
                    return true;
                } while (pos1++ < len1);
                return false;
            }
            if (ch == '?' ? pos1 == len1 : (ignoreCase ? pos1 == len1 || Character.toUpperCase(ch) != Character.toUpperCase(value.charAt(pos1)) : pos1 == len1 || ch != value.charAt(pos1))) {
                return false;
            }
            ++pos1;
        }
        return pos1 == len1;
    }

    public static final boolean matches(String value, String fmt, boolean ifcase) {
        return StringUtils.matches(value, 0, fmt, 0, ifcase);
    }

    public static final boolean identify(String ident) {
        if (ident == null) {
            return false;
        }
        int len = ident.length();
        if (len != 15 && len != 18) {
            return false;
        }
        int i = 0;
        while (i < (len == 15 ? 15 : 17)) {
            char ch = ident.charAt(i);
            if (ch < '0' || ch > '9') {
                return false;
            }
            ++i;
        }
        int p = (ident.charAt(0) - 48) * 10 + (ident.charAt(1) - 48);
        if (p >= provinces.length || provinces[p] == null) {
            return false;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        if (len == 15) {
            year = 1900 + (ident.charAt(6) - 48) * 10 + (ident.charAt(7) - 48);
            month = (ident.charAt(8) - 48) * 10 + (ident.charAt(9) - 48);
            day = (ident.charAt(10) - 48) * 10 + (ident.charAt(11) - 48);
        } else {
            year = (ident.charAt(6) - 48) * 1000 + (ident.charAt(7) - 48) * 100 + (ident.charAt(8) - 48) * 10 + (ident.charAt(9) - 48);
            month = (ident.charAt(10) - 48) * 10 + (ident.charAt(11) - 48);
            day = (ident.charAt(12) - 48) * 10 + (ident.charAt(13) - 48);
        }
        if (month == 2) {
            if (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) ? day > 29 : day > 28) {
                return false;
            }
        } else if (month == 4 || month == 6 || month == 9 || month == 11) {
            if (day > 30) {
                return false;
            }
        } else if (month <= 12) {
            if (day > 31) {
                return false;
            }
        } else {
            return false;
        }
        if (len == 18) {
            int[] w = wi;
            int mod = 0;
            int i2 = 0;
            while (i2 < 17) {
                mod += (ident.charAt(i2) - 48) * w[i2];
                ++i2;
            }
            if (ident.charAt(17) != codes[mod %= 11]) {
                return false;
            }
        }
        return true;
    }

    public static String replace(String src, String findString, String replaceString) {
        int pos;
        if (src == null || src.trim().length() == 0) {
            return src;
        }
        if (findString == null || findString.length() == 0) {
            return src;
        }
        if (replaceString == null) {
            return src;
        }
        int start = 0;
        while ((pos = src.indexOf(findString, start)) >= 0) {
            if (pos == 0) {
                src = String.valueOf(replaceString) + src.substring(findString.length());
                start = replaceString.length();
                continue;
            }
            src = String.valueOf(src.substring(0, pos)) + replaceString + src.substring(pos + findString.length());
            start = pos + replaceString.length();
        }
        return src;
    }

    public static void main(String[] args) {
        try {
            String s = "\\\t\f\r\n\u4e2d\u56fdabc";
            System.out.println(s);
            s = StringUtils.deunicode(s);
            System.out.println(s);
            s = StringUtils.unicode(s);
            System.out.println(s);
            System.out.println("0 = " + StringUtils.toChinese(0L, false, true));
            System.out.println("348004023 =" + StringUtils.toChinese(348004023L, false, false));
            System.out.println("348004023 =" + StringUtils.toChinese(348004023L, false, true));
            System.out.println(StringUtils.matches("", "?", true));
            System.out.println(StringUtils.matches("1", "?", true));
            System.out.println(StringUtils.matches("", "*", true));
            System.out.println(StringUtils.matches("123", "*", true));
            System.out.println(StringUtils.matches("abc123", "*123", true));
            System.out.println(StringUtils.matches("abc123", "*1?3", true));
            System.out.println(StringUtils.matches("abc123", "*3", true));
            System.out.println(StringUtils.matches("abc123", "*34", true));
            System.out.println(StringUtils.identify("420503800131001"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

