/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util.db;

import com.runqian.base.util.DBTypes;
import com.runqian.base.util.Logger;
import com.runqian.base.util.db.ConnectionParam;
import com.runqian.base.util.db.DataSourceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class ConnectionManager {
    private static final String resFile = "com/runqian/base/util/db/jndiPrefix.properties";
    private HashMap params = null;
    private SoftReference prefix = null;
    private String defDB = null;
    InitialContext ctx = null;
    InitialContext myCtx = null;
    private static ConnectionManager cm = new ConnectionManager();
    static /* synthetic */ Class class$0;

    public static ConnectionManager getInstance() {
        return cm;
    }

    private ConnectionManager() {
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException("\u5904\u7406\u6570\u636e\u6e90\u8fde\u63a5\u7f13\u51b2\u6c60\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    private Properties checkPrefix() {
        if (this.prefix == null || this.prefix.get() == null) {
            InputStream is;
            Properties p = new Properties();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            if ((is = cl.getResourceAsStream(resFile)) == null) {
                Logger.info("\u672a\u53d1\u73b0JNDI\u7684\u524d\u7f00\u6587\u4ef6com/runqian/base/util/db/jndiPrefix.properties");
            } else {
                try {
                    p.load(is);
                }
                catch (IOException e) {
                    Logger.error("\u88c5\u8f7dJNDI\u524d\u7f00\u6587\u4ef6com/runqian/base/util/db/jndiPrefix.properties\u65f6\u51fa\u9519", e);
                }
            }
            this.prefix = new SoftReference<Properties>(p);
            return p;
        }
        return (Properties)this.prefix.get();
    }

    private static String getStr(NamedNodeMap nnm, String name) {
        Node n = nnm.getNamedItem(name);
        if (n == null) {
            return null;
        }
        return n.getNodeValue();
    }

    private static int getInt(NamedNodeMap nnm, String name, int def) {
        Node n = nnm.getNamedItem(name);
        if (n == null) {
            return def;
        }
        try {
            return Integer.parseInt(n.getNodeValue());
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    private void init() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream in = cl.getResourceAsStream("datasources.xml");
        if (in == null) {
            Logger.info("\u672a\u53d1\u73b0\u6570\u636e\u6e90\u914d\u7f6e\u6587\u4ef6datasources.xml");
            return;
        }
        if (this.myCtx == null) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.runqian.base.util.naming.FlatInitCtxFactory");
            this.myCtx = new InitialContext(env);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        });
        InputStreamReader isr = new InputStreamReader(in);
        InputSource is = new InputSource(isr);
        Document document = builder.parse(is);
        Element root = document.getDocumentElement();
        if (root == null || !"DataSources".equals(root.getNodeName())) {
            Logger.info("\u672a\u627e\u5230\u6839\u7ed3\u70b9DataSources\uff0c\u5c06\u65e0\u6cd5\u4f7f\u7528\u6da6\u4e7e\u6570\u636e\u6e90\u8fde\u63a5\u7f13\u51b2\u6c60");
            return;
        }
        this.readDataSources(root);
    }

    private void readDataSources(Node parent) {
        Logger.info("\u5f00\u59cb\u6346\u7ed1\u6570\u636e\u6e90...");
        NodeList list = parent.getChildNodes();
        int j = 0;
        while (j < list.getLength()) {
            Node node;
            if (this.params == null) {
                this.params = new HashMap();
            }
            if ((node = list.item(j)).getNodeType() == 1 && "DataSource".equals(node.getNodeName())) {
                NamedNodeMap nnm = node.getAttributes();
                String server = ConnectionManager.getStr(nnm, "server");
                String lookupName = ConnectionManager.getStr(nnm, "name");
                String def = ConnectionManager.getStr(nnm, "default");
                if ("true".equalsIgnoreCase(def) || "yes".equalsIgnoreCase(def)) {
                    if (this.defDB == null) {
                        this.defDB = lookupName;
                    } else {
                        Logger.info("\u5df2\u8bbe" + this.defDB + "\u4e3a\u7f3a\u7701\u6570\u636e\u6e90\uff0c\u4e0d\u80fd\u518d\u8bbe" + def);
                    }
                }
                ConnectionParam cp = new ConnectionParam();
                this.params.put(lookupName, cp);
                String charset = ConnectionManager.getStr(nnm, "charset");
                if (charset != null & !charset.equals("")) {
                    cp.setCharsetName(charset);
                }
                cp.setDBType(DBTypes.getDBType(ConnectionManager.getStr(nnm, "dbType")));
                if (server == null || server.trim().length() == 0 || "builtin".equalsIgnoreCase(server)) {
                    cp.setReserve(Boolean.TRUE);
                    cp.setName(lookupName);
                    cp.setDriver(ConnectionManager.getStr(nnm, "driver"));
                    cp.setUrl(ConnectionManager.getStr(nnm, "url"));
                    cp.setUser(ConnectionManager.getStr(nnm, "user"));
                    cp.setPassword(ConnectionManager.getStr(nnm, "password"));
                    cp.setMinConnection(ConnectionManager.getInt(nnm, "minConnection", 0));
                    cp.setMaxConnection(ConnectionManager.getInt(nnm, "maxConnection", 0));
                    cp.setLoginTimeout(ConnectionManager.getInt(nnm, "loginTimeout", 6) * 1000);
                    cp.setIdleTimeout(ConnectionManager.getInt(nnm, "idelTimeout", 1800) * 1000);
                    cp.setCloseTimeout(ConnectionManager.getInt(nnm, "closeTimeout", 3600) * 1000);
                    try {
                        DataSourceImpl ds = new DataSourceImpl(cp);
                        this.myCtx.bind(lookupName, (Object)ds);
                        Logger.info("  \u6346\u7ed1\u6570\u636e\u6e90" + lookupName);
                        Logger.info("    [" + cp + "]");
                    }
                    catch (Exception e) {
                        Logger.error("\u4ea7\u751f\u6570\u636e\u6e90" + lookupName + "\u65f6\u53d1\u751f\u9519\u8bef", e);
                    }
                } else if ("custom".equalsIgnoreCase(server)) {
                    cp.setReserve(Boolean.TRUE);
                    cp.setName(lookupName);
                    String className = ConnectionManager.getStr(nnm, "className");
                    String methodName = ConnectionManager.getStr(nnm, "methodName");
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    try {
                        Class<?> claz = cl.loadClass(className);
                        Class[] classArray = new Class[1];
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz;
                        Method method = claz.getMethod(methodName, classArray);
                        this.myCtx.bind(lookupName, (Object)method);
                        Logger.info("  \u6346\u7ed1\u6570\u636e\u6e90" + lookupName);
                        Logger.info("    [" + cp + "]");
                    }
                    catch (Exception e) {
                        Logger.error("\u4ea7\u751f\u6570\u636e\u6e90" + lookupName + "\u65f6\u53d1\u751f\u9519\u8bef", e);
                    }
                } else {
                    if (this.ctx == null) {
                        try {
                            this.ctx = new InitialContext();
                        }
                        catch (Exception e) {
                            Logger.error(String.valueOf(server) + "\u4e0a\u672a\u542fJNDI\u670d\u52a1", e);
                        }
                    }
                    cp.setReserve(Boolean.FALSE);
                    String pf = this.checkPrefix().getProperty(server);
                    if (pf == null) {
                        cp.setName(lookupName);
                    } else {
                        cp.setName(String.valueOf(pf.trim()) + lookupName);
                    }
                    Logger.info(" \u767b\u8bb0\u5728" + server + "\u4e0a\u7684\u6570\u636e\u6e90" + lookupName);
                }
            }
            ++j;
        }
        Logger.info("\u5b8c\u6210\u6346\u7ed1\u6570\u636e\u6e90");
    }

    public void setDefaultDataSource(String lookupName) {
        if (!this.params.containsKey(lookupName)) {
            throw new RuntimeException("\u672a\u627e\u5230\u6570\u636e\u6e90" + lookupName);
        }
        this.defDB = lookupName;
    }

    public Connection getConnection() {
        if (this.defDB == null) {
            throw new RuntimeException("\u672a\u8bbe\u7f3a\u7701\u6570\u636e\u6e90");
        }
        return this.getConnection(this.defDB);
    }

    public String getCharset() {
        if (this.defDB == null) {
            throw new RuntimeException("\u672a\u8bbe\u7f3a\u7701\u6570\u636e\u6e90");
        }
        return this.getCharset(this.defDB);
    }

    public int getDBType() {
        if (this.defDB == null) {
            throw new RuntimeException("\u672a\u8bbe\u7f3a\u7701\u6570\u636e\u6e90");
        }
        return this.getDBType(this.defDB);
    }

    public Connection getConnection(String lookupName) {
        try {
            ConnectionParam cp = (ConnectionParam)this.params.get(lookupName);
            String bindName = cp.getName();
            Object o = null;
            o = cp.getReserve() == Boolean.TRUE ? this.myCtx.lookup(bindName) : this.ctx.lookup(bindName);
            if (o instanceof DataSource) {
                return ((DataSource)o).getConnection();
            }
            if (o instanceof Method) {
                return (Connection)((Method)o).invoke(null, lookupName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u53d6\u6570\u636e\u6e90" + lookupName + "\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
        throw new RuntimeException("\u672a\u627e\u5230\u6570\u636e\u6e90" + lookupName);
    }

    public String getCharset(String lookupName) {
        ConnectionParam cp = (ConnectionParam)this.params.get(lookupName);
        if (cp == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u6570\u636e\u6e90" + lookupName);
        }
        return cp.getCharsetName();
    }

    public int getDBType(String lookupName) {
        ConnectionParam cp = (ConnectionParam)this.params.get(lookupName);
        if (cp == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u6570\u636e\u6e90" + lookupName);
        }
        return cp.getDBType();
    }
}

