/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util.db;

import com.runqian.base.util.db.DataSourceImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;

final class ConnectionProxy
implements InvocationHandler {
    private DataSourceImpl dsi = null;
    private Connection conn = null;
    String usr;
    String pwd;
    private boolean inUse = false;
    private long lastAccessTime;
    private long lastUseTime = this.lastAccessTime = System.currentTimeMillis();

    ConnectionProxy(DataSourceImpl dsi, Connection conn, String usr, String pwd, boolean inUse) {
        this.dsi = dsi;
        this.conn = conn;
        this.usr = usr;
        this.pwd = pwd;
        this.inUse = inUse;
    }

    public Connection getConnection() {
        Connection conn2 = (Connection)Proxy.newProxyInstance(this.conn.getClass().getClassLoader(), this.conn.getClass().getInterfaces(), (InvocationHandler)this);
        return conn2;
    }

    void close() {
        try {
            this.conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object obj = null;
        if ("close".equals(m.getName())) {
            this.dsi.setNotUse(this);
        } else {
            if (!this.inUse && !m.getName().equals("toString")) {
                throw new SQLException("\u6570\u636e\u5e93\u8fde\u63a5\u8d85\u8fc7\u6700\u5927\u7a7a\u95f2\u65f6\u95f4\uff0c\u5df2\u88ab\u8fd4\u56de\u7f13\u51b2\u6c60");
            }
            obj = m.invoke((Object)this.conn, args);
        }
        this.lastAccessTime = System.currentTimeMillis();
        return obj;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
        this.lastUseTime = System.currentTimeMillis();
    }

    long getLastUseTime() {
        return this.lastUseTime;
    }
}

