/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base.util.db;

import com.runqian.base.util.db.ConnectionParam;
import com.runqian.base.util.db.ConnectionProxy;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.sql.DataSource;

public final class DataSourceImpl
implements DataSource,
Runnable {
    ConnectionParam cp = null;
    PrintWriter out = null;
    LinkedList conns = new LinkedList();
    int monitorInterval = 3000;

    public DataSourceImpl(ConnectionParam cp) throws IllegalAccessException, ClassNotFoundException, InstantiationException, SQLException {
        this.cp = cp;
        Driver driver = (Driver)Class.forName(cp.getDriver()).newInstance();
        DriverManager.registerDriver(driver);
        int i = 0;
        while (i < cp.getMinConnection()) {
            Connection conn = DriverManager.getConnection(cp.getUrl(), cp.getUser(), cp.getPassword());
            this.conns.add(new ConnectionProxy(this, conn, cp.getUser(), cp.getPassword(), false));
            ++i;
        }
        Thread t = new Thread((Runnable)this, "__DataSourceMonitor");
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.currentThread();
                Thread.sleep(this.monitorInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LinkedList linkedList = this.conns;
            synchronized (linkedList) {
                int i = this.conns.size() - 1;
                while (i >= 0) {
                    ConnectionProxy _conn = (ConnectionProxy)this.conns.get(i);
                    long now = System.currentTimeMillis();
                    if (_conn.isInUse()) {
                        if (now - _conn.getLastAccessTime() >= (long)this.cp.getIdleTimeout()) {
                            _conn.setInUse(false);
                        }
                    } else if (now - _conn.getLastUseTime() >= (long)this.cp.getCloseTimeout()) {
                        this.conns.remove(_conn);
                        _conn.close();
                    }
                    --i;
                }
            }
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getFreeConnection(this.cp.getUser(), this.cp.getPassword(), this.cp.getLoginTimeout());
    }

    public Connection getConnection(String user, String password) throws SQLException {
        return this.getFreeConnection(user, password, this.cp.getLoginTimeout());
    }

    private boolean isSameUser(String usr, String pwd) {
        String usr1 = this.cp.getUser();
        String pwd1 = this.cp.getPassword();
        pwd = pwd == null ? "" : pwd;
        String string = pwd1 = pwd1 == null ? "" : pwd1;
        return !(usr != usr1 && !usr.equals(usr1) || pwd != pwd1 && !pwd.equals(pwd1));
    }

    private boolean checkClosed(Connection conn) {
        try {
            if (conn.isClosed()) {
                this.log("\u53d6\u5230\u7684Connection[" + conn + "]\u5df2\u88ab\u5173\u95ed");
                return true;
            }
        }
        catch (SQLException e) {
            this.log("\u53d6\u5230\u7684Connection[" + conn + "]\u5728\u68c0\u6d4b\u662f\u5426\u5173\u95ed\u65f6\u53d1\u751f\u5f02\u5e38");
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getFreeConnection(String usr, String pwd) throws SQLException {
        Connection conn = null;
        LinkedList linkedList = this.conns;
        synchronized (linkedList) {
            int max;
            ConnectionProxy _conn;
            int i = this.conns.size() - 1;
            while (i >= 0) {
                _conn = (ConnectionProxy)this.conns.get(i);
                if (this.isSameUser(usr, pwd) && !_conn.isInUse()) {
                    _conn.setInUse(true);
                    conn = _conn.getConnection();
                    if (!this.checkClosed(conn)) break;
                    this.conns.remove(_conn);
                    conn = null;
                    conn = this.getFreeConnection(usr, pwd);
                    break;
                }
                --i;
            }
            if (conn == null && ((max = this.cp.getMaxConnection()) == 0 || this.getConnectionCount() < max)) {
                conn = DriverManager.getConnection(this.cp.getUrl(), usr, pwd);
                _conn = new ConnectionProxy(this, conn, usr, pwd, true);
                this.conns.add(_conn);
                conn = _conn.getConnection();
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getFreeConnection(String usr, String pwd, long nTimeout) throws SQLException {
        Connection conn = null;
        long startTime = System.currentTimeMillis();
        LinkedList linkedList = this.conns;
        synchronized (linkedList) {
            while ((conn = this.getFreeConnection(usr, pwd)) == null) {
                try {
                    this.conns.wait(nTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - startTime < nTimeout) continue;
                throw new SQLException("\u6700\u5927\u7b49\u5f85\u65f6\u95f4\u5df2\u7ecf\u8d85\u8fc7");
            }
        }
        return conn;
    }

    public int getConnectionCount() {
        return this.conns.size();
    }

    public int getLoginTimeout() {
        return this.cp.getLoginTimeout();
    }

    public void setLoginTimeout(int milliSeconds) {
        this.cp.setLoginTimeout(milliSeconds);
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    public void setLogWriter(PrintWriter out) {
        this.out = out;
    }

    private void log(String msg) {
        if (this.out != null) {
            this.out.println(msg);
        }
    }

    public void setMonitorInterval(int millis) {
        if (millis < 1000) {
            return;
        }
        this.monitorInterval = millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNotUse(ConnectionProxy _conn) {
        LinkedList linkedList = this.conns;
        synchronized (linkedList) {
            _conn.setInUse(false);
            this.conns.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpInfo(boolean all) {
        int j = 0;
        int k = 0;
        StringBuffer sb = new StringBuffer(1024);
        String LN = System.getProperty("line.separator");
        sb.append("NumberOfConnection = ");
        StringBuffer sb1 = null;
        StringBuffer sb2 = null;
        if (all) {
            sb1 = new StringBuffer(1024);
            sb2 = new StringBuffer(1024);
        }
        LinkedList linkedList = this.conns;
        synchronized (linkedList) {
            sb.append(this.conns.size());
            int i = 0;
            while (i < this.conns.size()) {
                ConnectionProxy _conn = (ConnectionProxy)this.conns.get(i);
                Connection conn = _conn.getConnection();
                if (_conn.isInUse()) {
                    ++j;
                    if (all) {
                        sb1.append(conn).append(',');
                    }
                } else {
                    ++k;
                    if (all) {
                        sb2.append(conn).append(',');
                    }
                }
                ++i;
            }
        }
        sb.append(LN);
        sb.append("\tused=").append(j);
        if (all) {
            sb.append('[').append(sb1).append(']');
        }
        sb.append(LN).append("\tunused=").append(k);
        if (all) {
            sb.append('[').append(sb2).append(']').append(LN);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close() {
        int cc = 0;
        LinkedList linkedList = this.conns;
        synchronized (linkedList) {
            int i = this.conns.size() - 1;
            while (i >= 0) {
                ConnectionProxy _conn = (ConnectionProxy)this.conns.get(i);
                _conn.close();
                this.conns.remove(_conn);
                ++cc;
                --i;
            }
        }
        return cc;
    }
}

